<span id="meetingDetails">
    <div class="card-body">
        <table class="table table-striped projects tAC" id="meetingListTable">
            <thead>
                <tr>
                    <th>
                        STUDENT ID
                    </th>
                    <th>
                        NAME
                    </th>
                    <th>
                        MEETING DATE
                    </th>
                    <th>
                        MEETING TIME
                    </th>
                    <th>
                        MEETING TYPE
                    </th>
                    <th>
                        AGENDA
                    </th>
                    <th>
                        ACTION
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                session_start();

                require_once '../../common/connectToDB.php';
                $studentMeetingDetails = [];
                $sql = "SELECT ls.firstname,ls.lastname,ls.studentId,ls.username,ls.initialTestStatus,ls.studentCategory,lm.lifeCoachMeetingType,lm.studentId,lm.planDate,lm.planStartTime,lm.planEndTime,lm.lifeCoachMeetingMessage,lm.lifeCoachMeetingId FROM loginstudents ls INNER JOIN lifecoachmeeting lm ON ls.studentId = lm.studentId WHERE ls.admissionStatus = 'CONFIRMED' AND ls.initialTestStatus = 'COMPLETED' AND lm.lifeCoachMeetingType='".$_SESSION['meetingType'] ."' AND lm.lifeCoachMeetingStatus = 'PENDING' ORDER BY ls.studentId DESC, lm.lifeCoachMeetingId DESC";
                $result = mysqli_query($conn, $sql);
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        array_push($studentMeetingDetails, $row);
                        $studentId = '';
                        $meetingId = '';
                        $meetingTime = '';

                        $studentId = $row['studentId'];
                        $studentName = $row['firstname'] . " " . $row['lastname'];
                        $statusCss = 'badge bg-warning';
                        $meetingId = $row['lifeCoachMeetingId'];
                        $meetingTime = date('h:i a', strtotime($row['planStartTime'])) . '-' . date('h:i a', strtotime($row['planEndTime']));

                        if ($row['lifeCoachMeetingType'] == 'Primary Meeting') $statusCss = 'badge bg-info';
                        if ($row['lifeCoachMeetingType'] == 'Parents Meeting') $statusCss = 'badge bg-success';

                        echo "<tr class='tAC'>
                        <td><a class='btn fS15' href='#' onclick='showDetails(this.id)' id = '" . $studentId . "'>" . $studentId . "</a></td>
                        <td><a class='btn fS15' href='#' onclick='showDetails(this.id)' id = '" . $studentId . "'>" . $studentName . "</a></td>
                        <td>" . $row['planDate'] . "</td>
                        <td>" . $meetingTime . "</td>
                        <td><span class='" . $statusCss . "' >" . $row['lifeCoachMeetingType'] . "</span></td>
                        <td>" . $row['lifeCoachMeetingMessage'] . "</td>
                        <td><a class='btn btn-info tCW' href='#' title='Click here to Execute Meeting.' onclick='openNav(this.id)' id = '" . $meetingId . "'>Execute</a>
                            <a class='btn btn-warning btn-sm fS15'  href='#' id = '" . $studentId . "' title='Click here to Edit Meeting.' onclick=editNav($meetingId)>
                                <i class='fas fa-edit'></i> Edit</a>
                            </a>
                        </td>
                    </tr>";
                    }
                }
                ?>
            </tbody>
        </table>
    </div>
</span>

<script>
    var studentMeetingDetails = [];
    $(function() {
        $(document).ready(function() {
            studentMeetingDetails = <?php echo json_encode($studentMeetingDetails) ?>;
            // $("#meetingListTable").DataTable({
            //     "responsive": true,
            //     "autoWidth": false,
            //     "aLengthMenu": [
            //         [5, 10, 25, 50, 75, -1],
            //         [5, 10, 25, 50, 75, "All"]
            //     ],
            //     "pageLength": 20,
            //     "aaSorting": [],
            // });
        });
    });
</script>