<?php
session_start();
if (isset($_SESSION['lifeCoachLoginSuccessEdj'])) {
    if ($_SESSION['lifeCoachLoginSuccessEdj'] > 0) {
    } else {
        header('Location:../../lifeCoachLogin.php');
        exit;
    }
} else {
    header('Location:../../lifeCoachLogin.php');
    exit;
}
require '../../common/header.php';
require '../../common/navbar.php';
require_once '../../common/connectToDB.php';
$meetingType = '';
if (isset($_GET['m'])) {
    $meetingType = base64_decode($_GET['m']);
    $_SESSION['meetingType']  = $meetingType;
}

?>



<!-- side nav -->
<div id="mySidenav" class="sidenav">
    <div class="row">
        <div class="col-12">
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active tCW fS18" href="#meeting" role="tab" data-toggle="tab"
                        style="color:white !important;"><i class="fas fa-handshake fS21"></i> Meeting</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link tCW fS18" href="#Worksheets" role="tab" data-toggle="tab"
                        style="color:white !important;"><i class="fas fa-handshake fS21"></i> Worksheets</a>
                </li>
                <a href="#" class="pull-right" id="cancel" style="position: absolute;right: 17px;"
                    onclick="closeNav()"><i class="fas fa-window-close"></i></a>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane fade show active container" id="meeting">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="mt-1">Student Name: </label>
                                <label id="studentNameNav"></label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <p id="meetingId" hidden>
                        </p>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="">Date:</label>
                                <input type="date" class="form-control" id="meetingDate"
                                    onChange="onDateChange(this.id)" min='0' max='<?php echo date('Y-m-d') ?>'>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="">Start Time:</label>
                                <input type="time" class="form-control" id="meetingStartTime">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="">End Time:</label>
                                <input type="time" class="form-control" id="meetingEndTime">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="">Meeting Type</label>
                                <span class="" id="MeetingType" style="font-size:14px;"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>General Observation:</label>
                                <div class="input-group my-colorpicker2">
                                    <textarea class="form-control" rows="3" placeholder="Enter Your Note"
                                        id="generalNotes"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Insights Gained:</label>
                                <div class="input-group my-colorpicker2">
                                    <textarea class="form-control" rows="3" placeholder="Enter Your Note"
                                        id="personalNotes"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Progress Update:</label>
                                <div class="input-group my-colorpicker2">
                                    <textarea class="form-control" rows="3" placeholder="Enter Your Note"
                                        id="entrepreneurNotes"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer tAC">
                        <span id="savedData"></span>
                        <div class="card-footer tAC">
                            <p id='meetingErrorMessage' class="text-center"
                                style="color: red; font-size: 1.2em;   text-align: center;"></p>
                            <p id='meetingSuccessMessage' class="text-center"
                                style="color: #25C032; font-size: 1.2em;   text-align: center;"></p>
                            <input type="button" class="btn btn-primary" value="Submit" id="saveMeeting"
                                onclick="saveMeeting()" />
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane fade container" id="Worksheets">

                    <div class="row">
                        <div class="card-body">
                            <table class="table table-striped projects tAC bg-white" id="meetingListTable">
                                <thead>
                                    <tr>
                                        <th>
                                            Title
                                        </th>
                                        <th>
                                            Actions
                                        </th>
                                        <th>
                                            Deadline
                                        </th>
                                    </tr>
                                </thead>
                                <tbody id="worksheetBody">
                                    <?php
                                    require_once '../../common/connectToDB.php';

                                    $sql = "SELECT * FROM worksheets WHERE worksheetType !='' order by worksheetId desc";
                                    $result = mysqli_query($conn, $sql);
                                    if ($result->num_rows > 0) {
                                        $index = 1;
                                        while ($row = $result->fetch_assoc()) {

                                            $deadlineID = '"' . 'deadline' . $index . '"';
                                            $checkboxId = '"' . 'checkbox' . $index . '"';

                                            echo "<tr class='tAC'>
                                              <td>" . $row['worksheetTitle'] . "</td>
                                              <td><input type='checkbox' id=$checkboxId value='" . $row['worksheetId'] . "' onclick='changedeadlineDiv()'></td>
                                              <td><select class='cutom-select form-control' id=$deadlineID hidden>
                                              <option>Select Deadline</option>
                                              <option>1</option>
                                              <option>2</option>
                                              <option>3</option>
                                              <option>4</option>
                                              <option>5</option>
                                              <option>6</option>
                                              <option>7</option>
                                              <option>8</option>
                                              <option>9</option>
                                              <option>10</option>
                                              <option>11</option>
                                              <option>12</option>
                                              <option>13</option>
                                              <option>14</option>
                                              <option>15</option>
                                              </select></td>
                                             </tr>";
                                            $index += 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="card-footer tAC">
                        <span id="savedData"></span>
                        <div class="card-footer tAC">
                            <p id='worksheetErrorMessage' class="text-center"
                                style="color: red; font-size: 1.2em;   text-align: center;"></p>
                            <p id='worksheetSuccessMessage' class="text-center text-success"
                                style="color: green;font-size: 1.2em;font-weight:500;text-align: center;"></p>
                            <input type="button" class="btn btn-primary" value="Submit" id="saveworksheets"
                                onclick="saveworksheets()" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- side nav end -->

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">Upcoming Meetings</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
        <table class="table table-striped projects tAC" id="meetingListTable">
            <thead>
                <tr>
                    <th>
                        STUDENT ID
                    </th>
                    <th>
                        NAME
                    </th>
                    <th>
                        MEETING DATE
                    </th>
                    <th>
                        MEETING TIME
                    </th>
                    <th>
                        MEETING TYPE
                    </th>
                    <th>
                        AGENDA
                    </th>
                    <th>
                        ACTION
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                // session_start();

                require_once '../../common/connectToDB.php';
                $studentMeetingDetails = [];
                $sql = "SELECT ls.firstname,ls.lastname,ls.studentId,ls.username,ls.initialTestStatus,ls.studentCategory,lm.lifeCoachMeetingType,lm.studentId,lm.planDate,lm.planStartTime,lm.planEndTime,lm.lifeCoachMeetingMessage,lm.lifeCoachMeetingId FROM loginstudents ls INNER JOIN lifecoachmeeting lm ON ls.studentId = lm.studentId WHERE ls.admissionStatus = 'CONFIRMED' AND ls.initialTestStatus = 'COMPLETED' AND lm.lifeCoachMeetingType='".$_SESSION['meetingType'] ."' AND lm.lifeCoachMeetingStatus = 'PENDING' ORDER BY ls.studentId DESC, lm.lifeCoachMeetingId DESC";
                $result = mysqli_query($conn, $sql);
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        array_push($studentMeetingDetails, $row);
                        $studentId = '';
                        $meetingId = '';
                        $meetingTime = '';

                        $studentId = $row['studentId'];
                        $studentName = $row['firstname'] . " " . $row['lastname'];
                        $statusCss = 'badge bg-warning';
                        $meetingId = $row['lifeCoachMeetingId'];
                        $meetingTime = date('h:i a', strtotime($row['planStartTime'])) . '-' . date('h:i a', strtotime($row['planEndTime']));

                        if ($row['lifeCoachMeetingType'] == 'Primary Meeting') $statusCss = 'badge bg-info';
                        if ($row['lifeCoachMeetingType'] == 'Parents Meeting') $statusCss = 'badge bg-success';

                        echo "<tr class='tAC'>
                        <td><a class='btn fS15' href='#' onclick='showDetails(this.id)' id = '" . $studentId . "'>" . $studentId . "</a></td>
                        <td><a class='btn fS15' href='#' onclick='showDetails(this.id)' id = '" . $studentId . "'>" . $studentName . "</a></td>
                        <td>" . $row['planDate'] . "</td>
                        <td>" . $meetingTime . "</td>
                        <td><span class='" . $statusCss . "' >" . $row['lifeCoachMeetingType'] . "</span></td>
                        <td>" . $row['lifeCoachMeetingMessage'] . "</td>
                        <td><a class='btn btn-info tCW' href='#' title='Click here to Execute Meeting.' onclick='openNav(this.id)' id = '" . $meetingId . "'>Execute</a>
                            <a class='btn btn-warning btn-sm fS15'  href='#' id = '" . $studentId . "' title='Click here to Edit Meeting.' onclick=editNav($meetingId)>
                                <i class='fas fa-edit'></i> Edit</a>
                            </a>
                        </td>
                    </tr>";
                    }
                }
                ?>
            </tbody>
        </table>
    </div>                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
            var studentMeetingDetails = [];
            studentMeetingDetails = <?php echo json_encode($studentMeetingDetails) ?>;

    $(function () {
        $(document).ready(function () {
            // loadData();

        });
    });
</script>
<script src="upComingMeetings.js?v=<?php echo $fileVersion; ?>"></script>
<?php require '../../common/footer.php'; ?>