var meetingStartTime = '',
    meetingEndTime = '',
    meetingType = '',
    lifeCoachMeetingId = '',
    personalNotes = '',
    entrepreneurNotes = '',
    generalNotes = '';

var meetingDate = "";
var studentId = "";
function onDateChange(id) {
    var dateSplit = document.getElementById(id).value.split('-'),
        date,
        month,
        year;
    date = dateSplit[2];
    month = dateSplit[1];
    year = dateSplit[0];
    meetingDate = date + '-' + month + '-' + year;
}

// function loadData() {
//     $.post('upcomingMeetingDetails.php', {}, function (data) {
//         $('#meetingDetails').html(data);
//     });
// }

function selectDropdownValue(selectName, val) {
    val = val.toUpperCase().trim();
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text.trim();
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function resetSideNav() {
    document.getElementById('meetingDate').value = '';
    document.getElementById("meetingStartTime").value = '';
    document.getElementById("meetingEndTime").value = '';
    document.getElementById('generalNotes').value = '';
    document.getElementById('personalNotes').value = '';
    document.getElementById('entrepreneurNotes').value = '';
    document.getElementById('meetingSuccessMessage').innerHTML = '';
    document.getElementById('meetingErrorMessage').innerHTML = '';
    document.getElementById('studentNameNav').innerHTML = '';
    document.getElementById('saveMeeting').disabled = false;
    meetingDate = '';
}

function openNav(meetingId) {
    resetSideNav();
    studentId = '';
    document.getElementById("mySidenav").style.width = "850px";
    for (i = 0; i < studentMeetingDetails.length; i++) {
        if (studentMeetingDetails[i]['lifeCoachMeetingId'] == meetingId) {
            studentId = studentMeetingDetails[i]['studentId'];
            document.getElementById("MeetingType").innerHTML = studentMeetingDetails[i]['lifeCoachMeetingType'];
            document.getElementById("meetingId").innerHTML = studentMeetingDetails[i]['lifeCoachMeetingId'];
            document.getElementById('studentNameNav').innerHTML = studentMeetingDetails[i]['firstname'] + ' ' + studentMeetingDetails[i]['lastname'];
            if (studentMeetingDetails[i]['lifeCoachMeetingType'] == "Primary Meeting") {
                document.getElementById("MeetingType").setAttribute("class", "badge bg-info");
            }
            if (studentMeetingDetails[i]['lifeCoachMeetingType'] == "Secondary Meeting") {
                document.getElementById("MeetingType").setAttribute("class", "badge bg-warning");
            }
            if (studentMeetingDetails[i]['lifeCoachMeetingType'] == "Parents-Coach Meeting") {
                document.getElementById("MeetingType").setAttribute("class", "badge bg-warning");
            }
        }
    }
}

function closeNav() {
    document.getElementById("mySidenav").style.width = "0";
}

function showError(id, color, message) {
    document.getElementById(id).style.backgroundColor = color;
    document.getElementById('meetingErrorMessage').innerHTML = message;
}

function setHeaders() {
    meetingStartTime = document.getElementById("meetingStartTime").value.trim();
    meetingEndTime = document.getElementById("meetingEndTime").value.trim();
    meetingType = document.getElementById("MeetingType").innerHTML.trim();
    lifeCoachMeetingId = document.getElementById('meetingId').innerHTML.trim();
    personalNotes = document.getElementById('personalNotes').value.trim();
    entrepreneurNotes = document.getElementById('entrepreneurNotes').value.trim();
    generalNotes = document.getElementById('generalNotes').value.trim();
    return 1;
}

function formValidation() {
    if (meetingDate <= 0) {
        showError('meetingDate', "#ffc2b3", "Select Date");
        return 0;
    } else showError('meetingDate', '', '');

    if (meetingStartTime <= 0) {
        showError('meetingStartTime', "#ffc2b3", "Select Start Time");
        return 0;
    } else showError('meetingStartTime', '', '');

    if (meetingEndTime <= 0) {
        showError('meetingEndTime', "#ffc2b3", "Select End Time");
        return 0;
    } else showError('meetingEndTime', '', '');

    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

function saveMeeting() {
    document.getElementById('saveMeeting').disabled = true;

    var flagForSave = true;
    if (setHeaders() == 0) {
        document.getElementById('saveMeeting').disabled = false;
        return;
    }
    if (formValidation() == 0) {
        document.getElementById('saveMeeting').disabled = false;
        return;
    }
    personalNotes = escapeSpecialCharacters(personalNotes);
    entrepreneurNotes = escapeSpecialCharacters(entrepreneurNotes);
    generalNotes = escapeSpecialCharacters(generalNotes);
    document.getElementById('meetingSuccessMessage').innerHTML = "Saving please wait...";
    $.post('saveMeetingExecution.php', {
        'flagForSave': flagForSave,
        'meetingType': meetingType,
        'studentId': studentId,
        'meetingDate': meetingDate,
        'meetingStartTime': meetingStartTime,
        'meetingEndTime': meetingEndTime,
        'personalNotes': personalNotes,
        'entrepreneurNotes': entrepreneurNotes,
        'generalNotes': generalNotes,
        'lifeCoachMeetingId': lifeCoachMeetingId,
    }, function (data) {
        document.getElementById('meetingSuccessMessage').innerHTML = "Meeting Saved.";
        document.getElementById('saveMeeting').disabled = true;
        loadData();
    });
}

function showDetails(studentId) {
    window.location.href = 'viewstudentDetails.php?studentId=' + studentId;
}

function editNav(meetingId) {
    window.location.href = 'editMeeting.php?meetingId=' + meetingId;
}

function showWorksheetError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('worksheetErrorMessage').innerHTML = message;
}
function changedeadlineDiv(){
    var table = document.getElementById("worksheetBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        let tempworksheetId = table.rows[r].cells[1].getElementsByTagName("input")[0].checked;
        let tempDeadLine = table.rows[r].cells[2].getElementsByTagName("select")[0].value;

        if (tempworksheetId == true) {
            table.rows[r].cells[2].getElementsByTagName("select")[0].hidden = false;
        }
    }
}
function saveworksheets() {
    assignWorksheetData = [];
    meetingType = document.getElementById("MeetingType").innerHTML.trim();

    var flagForSave ='assignSheets';
    var table = document.getElementById("worksheetBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        let tempWorksheetName = table.rows[r].cells[0].innerHTML;
        let tempworksheetId = table.rows[r].cells[1].getElementsByTagName("input")[0].checked;
        let tempDeadLine = table.rows[r].cells[2].getElementsByTagName("select")[0].value;

        if (tempworksheetId == true) {
            if (table.rows[r].cells[2].getElementsByTagName("select")[0].value == 'Select Deadline') {
                table.rows[r].cells[2].getElementsByTagName("select")[0].style.backgroundColor = "#ff6666";
                showWorksheetError('', '#ff6666', "Enter dead line");
                return 0;
            } else {

                showWorksheetError('', '#ff6666', "");
                table.rows[r].cells[2].getElementsByTagName("select")[0].style.backgroundColor = "";
            }
        }

        if (tempworksheetId == true) {
            var obj = {
                'worksheetName': tempWorksheetName,
                'worksheetId': table.rows[r].cells[1].getElementsByTagName("input")[0].value,
                'deadLine': tempDeadLine,
            }
            assignWorksheetData.push(obj);

        }


    }

    console.log(assignWorksheetData, 'obj');
    document.getElementById('worksheetSuccessMessage').innerHTML = "Saving please wait...";
    document.getElementById('saveworksheets').disabled = true;

    $.post('assignWorksheets.php', {
        'flagForSave': flagForSave,
        'assignWorksheetData': assignWorksheetData,
        'studentId':studentId,
        'meetingType': meetingType,

    }, function (data) {
        console.log(data,'dbPassword');
        document.getElementById('worksheetSuccessMessage').innerHTML = "Meeting Saved.";
        document.getElementById('saveworksheets').disabled = true;
        // loadData();
    });
}