var meetingDate = "";

var meetingStartTime = "",
    meetingEndTime = "",
    meetingAgenda = "",
    meetingType = "",
    statement = "";

function onDateChange(id) {
    var dateSplit = document.getElementById(id).value.split('-'),
        date,
        month,
        year;
    date = dateSplit[2];
    month = dateSplit[1];
    year = dateSplit[0];
    meetingDate = date + '-' + month + '-' + year;
}

const oldData = {
    oldMeetingDate: "",
    oldMeetingStartTime: "",
    oldMeetingEndTime: "",
    oldMeetingAgenda: ""
}

function loadOldValues() {
    oldData.oldMeetingDate = document.getElementById('meetingDate').value.trim();
    oldData.oldMeetingStartTime = document.getElementById('meetingStartTime').value.trim();
    oldData.oldMeetingEndTime = document.getElementById('meetingEndTime').value.trim();
    oldData.oldMeetingAgenda = document.getElementById('meetingAgenda').value.trim();
}

function compareNewValuesWithOld() {
    var flagForStatement = 0;

    if (oldData.oldMeetingDate != tempMeetingDate) {
        flagForStatement = 1;
        statement = statement + "Meeting date changed from " + oldData.oldMeetingDate + " to " + tempMeetingDate + "<br>";
    }
    if (oldData.oldMeetingStartTime != meetingStartTime) {
        flagForStatement = 1;
        statement = statement + "Meeting start time changed from " + oldData.oldMeetingStartTime + " to " + meetingStartTime + "<br>";
    }
    if (oldData.oldMeetingEndTime != meetingEndTime) {
        flagForStatement = 1;
        statement = statement + "Meeting end time changed from " + oldData.oldMeetingStartTime + " to " + meetingStartTime + "<br>";
    }
    if (oldData.oldMeetingAgenda != meetingAgenda) {
        flagForStatement = 1;
        statement = statement + "Meeting agenda changed from " + oldData.oldMeetingAgenda + " to " + meetingAgenda + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

function setHeaders() {
    tempMeetingDate = document.getElementById('meetingDate').value.trim();
    meetingStartTime = document.getElementById("meetingStartTime").value.trim();
    meetingEndTime = document.getElementById("meetingEndTime").value.trim();
    meetingAgenda = document.getElementById("meetingAgenda").value.trim();
    meetingType = document.getElementById("MeetingType").value.trim();
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('meetingErrorMessage').innerHTML = message;
}

function formValidation() {
    if (meetingAgenda == "") {
        showError('meetingAgenda', '#ffc2b3', "meetingAgenda cannot be blank");
        return 0;
    } else showError('meetingAgenda', '', "");
}

function submitMeeting(meetingId) {
    var flagForUpdate = true;
    document.getElementById('saveMeeting').disabled = true;

    if (setHeaders() == 0) {
        document.getElementById('saveMeeting').disabled = false;
        return;
    }
    if (formValidation() == 0) {
        document.getElementById('saveMeeting').disabled = false;
        return;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('saveMeeting').disabled = false;
        return;
    }
    else if (meetingAgenda != "") {
        meetingAgenda = escapeSpecialCharacters(meetingAgenda);
        showError('meetingSuccessMessage', '', '');
        document.getElementById("meetingSuccessMessage").innerHTML = "Updating Please Wait....";

        $.post('updateMeeting.php', {
            'studentId': studentId,
            'flagForUpdate': flagForUpdate,
            'statement': statement,
            'meetingDate': meetingDate,
            'meetingStartTime': meetingStartTime,
            'meetingEndTime': meetingEndTime,
            'meetingAgenda': meetingAgenda,
            'meetingType': meetingType,
            'meetingId': meetingId,
        }, function (data) {
            document.getElementById("meetingSuccessMessage").innerHTML = "Saved.";
        });
    }
}