<?php
session_start();
if (isset($_SESSION['lifeCoachLoginSuccessEdj'])) {
    if ($_SESSION['lifeCoachLoginSuccessEdj'] > 0) {
    } else {
        header('Location:../../lifeCoachLogin.php');
        exit;
    }
} else {
    header('Location:../../lifeCoachLogin.php');
    exit;
}

require '../../common/header.php';
require '../../common/navbar.php';
require_once '../../common/connectToDB.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">All Meetings</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="meetingListTable">
                                <thead>
                                    <tr>
                                        <th>
                                            STUDENT ID
                                        </th>
                                        <th>
                                            NAME
                                        </th>
                                        <th>
                                            MEETING DATE
                                        </th>
                                        <th>
                                            MEETING TIME
                                        </th>
                                        <th>
                                            MEETING TYPE
                                        </th>
                                        <th>
                                            AGENDA
                                        </th>
                                        <th>
                                            MEETING STATUS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $studentMeetingDetails=[];
                                    $sql = "SELECT ls.firstname,ls.lastname,ls.studentId,ls.studentCategory,ls.username,ls.initialTestStatus,lm.lifeCoachMeetingStatus,lm.planDate,lm.planStartTime,lm.planEndTime,lm.lifeCoachMeetingType,lm.lifeCoachMeetingMessage,lm.lifeCoachMeetingStatus FROM loginstudents ls INNER JOIN lifecoachmeeting lm ON ls.studentId = lm.studentId WHERE ls.admissionStatus='CONFIRMED' AND ls.initialTestStatus='COMPLETED' ORDER BY lm.lifeCoachMeetingId";
                                    $result = mysqli_query($conn, $sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            array_push($studentMeetingDetails, $row);
                                            $studentName = '';
                                            $statusCss = '';
                                            $meetingTime = '';
                                            $studentName = $row['firstname'] . ' ' . $row['lastname'];
                                            $meetingTime = date('h:i a', strtotime($row['planStartTime'])) . '-' . date('h:i a', strtotime($row['planEndTime']));

                                            if ($row['lifeCoachMeetingStatus'] == 'PENDING') $statusCss = 'badge bg-danger';
                                            if ($row['lifeCoachMeetingStatus'] == 'COMPLETED') $statusCss = 'badge bg-success';
                                            echo "<tr class='tAC'>
                                                <td>" . $row['studentId'] . "</td>
                                                <td>" . $studentName . "</td>
                                                <td>" . $row['planDate'] . "</td>
                                                <td>" . $meetingTime . "</td>
                                                <td>" . $row['lifeCoachMeetingType'] . "</td>
                                                <td>" . $row['lifeCoachMeetingMessage'] . "</td>
                                                <td><span class='" . $statusCss . "'>" . $row['lifeCoachMeetingStatus'] . "</span></td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
    $(function() {
        $(document).ready(function() {
            studentMeetingDetails = <?php echo json_encode($studentMeetingDetails) ?>;
            $("#meetingListTable").DataTable({
                "responsive": true,
                "autoWidth": false,
                "aLengthMenu": [
                    [5, 10, 25, 50, 75, -1],
                    [5, 10, 25, 50, 75, "All"]
                ],
                "pageLength": 20,
                "aaSorting": [],
            });
        });
    });
</script>
<?php require '../../common/footer.php'; ?>