<?php
session_start();
if (isset($_SESSION['lifeCoachLoginSuccessEdj'])) {
    if ($_SESSION['lifeCoachLoginSuccessEdj'] > 0) {
    } else {
        header('Location:../../lifeCoachLogin.php');
        exit;
    }
} else {
    header('Location:../../lifeCoachLogin.php');
    exit;
}

require '../../common/header.php';
require '../../common/navbar.php';
require_once '../../common/connectToDB.php';
?>
<div id="mySidenav" class="sidenav">
    <div class="row">
        <div class="col-12">

            <!-- Bootstrap CSS -->
            <!-- jQuery first, then Bootstrap JS. -->
            <!-- Nav tabs -->

            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active tCW fS18" href="#meeting" role="tab" data-toggle="tab"><i
                            class="fas fa-handshake fS21"></i> Meeting</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tCW fS18" href="#generalTraits" role="tab" data-toggle="tab"><i
                            class="fas fa-sticky-note"></i> General Observation </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link  tCW fS18" href="#note" role="tab" data-toggle="tab"><i
                            class="fas fa-sticky-note"></i> Personality Traits </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tCW fS18" href="#call" role="tab" data-toggle="tab" class="nav-color"><i
                            class="fas fa-sticky-note"></i> Entrepreneur Traits</a>
                </li>
                <a href="#" class="pull-right" id="cancel" style="position: absolute;right: 17px;"
                    onclick="closeNav()"><i class="fas fa-window-close"></i></a>
            </ul>

            <!-- Tab panes -->
            <div class="tab-content">
                <!-- meeting -->
                <div role="tabpanel" class="tab-pane fade show active container" id="meeting">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="mt-5">Date:</label>
                                <input type="date" class="form-control" id="meetingDate"
                                    onChange="onDateChange(this.id)">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="mt-5">Start Time:</label>
                                <input type="time" class="form-control" id="meetingStartTime"
                                    onChange="calculateEndTime(this.id)">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="mt-5">End Time:</label>
                                <!-- <input type="time" class="form-control" id="meetingEndTime" disabled> -->
                                <input type="text" class="form-control" id="meetingEndTime" disabled>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="mt-5">Meeting Type</label>
                                <span class="badge badge-warning fs18" id="MeetingType">Secondary Meeting</span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <label>Agenda:</label>
                            <div class="input-group my-colorpicker2">
                                <textarea class="form-control" rows="3" placeholder="" id="meetingAgenda"></textarea>
                                <div class="input-group-append">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class=" col-md-12">
                            <p id='errorMessage' class="text-center"
                                style="color: red; font-size: 1.2em;   text-align: center;">
                            </p>
                            <p id='successMessage' class="text-center"
                                style="color: #25C032; font-size: 1.2em;   text-align: center;">
                            </p>
                            <span id="utilSuccessDetails">
                            </span>
                        </div>
                    </div>
                    <div class="card-footer tAC">
                        <span id="savedData"></span>
                        <input type="button" class="btn btn-primary" value="Submit" id="saveMeeting"
                            onclick="saveMeeting()" />

                        <div class="card-footer tAC">
                            <p id='meetingErrorMessage' class="text-center"
                                style="color: red; font-size: 1.2em;   text-align: center;">
                            </p>
                            <p id='meetingSuccessMessage' class="text-center"
                                style="color: #25C032; font-size: 1.2em;   text-align: center;">
                            </p>
                        </div>
                    </div>
                </div>
                <!-- meeting end -->
                <!-- general traits -->
                <div role="tabpanel" class="tab-pane fade container" id="generalTraits">
                    <div class="form-group">
                        <label class="mt-5">General Observation:</label>
                        <div class="input-group my-colorpicker2">
                            <textarea class="form-control" rows="3" placeholder="Enter Your Note"
                                id="generalNotes"></textarea>
                        </div>
                    </div>
                    <input type="button" class="btn btn-primary" value="Save" id="saveGeneralNotes"
                        onclick="saveNote(this.id)" />
                    <p id='noteSuccessMessage' class="text-center"
                        style="color: #25C032; font-size: 1.2em;   text-align: center;">
                    </p>
                    <p id='noteErrorMessage' class="text-center"
                        style="color: red; font-size: 1.2em;   text-align: center;">
                    </p>
                </div>
                <!-- general traits end -->
                <!-- notes -->
                <div role="tabpanel" class="tab-pane fade container" id="note">
                    <div class="form-group">
                        <label class="mt-5">Personality Traits:</label>
                        <div class="input-group my-colorpicker2">
                            <textarea class="form-control" rows="3" placeholder="Enter Your Note"
                                id="personalNotes"></textarea>
                        </div>
                    </div>
                    <input type="button" class="btn btn-primary" value="Save" id="savepersonalNotes"
                        onclick="saveNote(this.id)" />
                    <p id='noteSuccessMessage1' class="text-center"
                        style="color: #25C032; font-size: 1.2em;   text-align: center;">
                    </p>
                    <p id='noteErrorMessage1' class="text-center"
                        style="color: red; font-size: 1.2em;   text-align: center;">
                    </p>
                </div>
                <!-- notes end -->
                <!-- Entrepreneur -->
                <div role="tabpanel" class="tab-pane fade container" id="call">
                    <div class="form-group">
                        <label class="mt-5">Entrepreneur Traits:</label>
                        <div class="input-group my-colorpicker2">
                            <textarea class="form-control" rows="3" placeholder="Enter Your Note"
                                id="entrepreneurNotes"></textarea>
                        </div>
                    </div>
                    <input type="button" class="btn btn-primary" value="Save" id="savEentrepreneurNotes"
                        onclick="saveNote(this.id)" />
                    <p id='noteSuccessMessage2' class="text-center"
                        style="color: #25C032; font-size: 1.2em;   text-align: center;">
                    </p>
                    <p id='noteErrorMessage2' class="text-center"
                        style="color: red; font-size: 1.2em;   text-align: center;">
                    </p>
                </div>
                <!-- Entrepreneur end -->

            </div>

        </div>
    </div>
</div>
<!-- meeting end -->
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB" id="pageTitle">Students List</h3>
                            <div class="card-body">
                                <div id='meetingDetails'>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.card -->
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="followUp.js?v=<?php echo $fileVersion; ?>"></script>

<?php require '../../common/footer.php'; ?>

<script>
var userId = '';
/* Simple appearence with animation AN-1*/
function openNav(currentStudentId) {
    studentId = currentStudentId;
    document.getElementById("mySidenav").style.width = "850px";
    document.getElementById('noteSuccessMessage1').innerHTML = "";
    document.getElementById('meetingDate').value = '';
    document.getElementById('meetingStartTime').value = '';
    document.getElementById('meetingEndTime').value = '';
    document.getElementById('meetingAgenda').value = '';
    document.getElementById('meetingSuccessMessage').innerHTML="";
    document.getElementById('saveMeeting').disabled = false;
    meetingDate = '';
}

function closeNav() {
    document.getElementById("mySidenav").style.width = "0";
}

function loadData() {
    $.post('intermediateMeetingDetails.php', {}, function(data) {
        document.getElementById("meetingDetails").innerHTML = data;
    });
}

/* Simple appearence with animation AN-1*/

function showDetails(studentId) {
    window.location.href = 'viewstudentDetails.php?studentId=' + studentId;
}
// $("#mySidenav").mouseleave(function() {
//     closeNav();
// });
$(function() {
    $(document).ready(function() {
        loadData();
        $("#studentListTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": -1,
            'aSorting': []
        });
        //console.log(userId)
    });
});
</script>