
var workSheetFlag='';
var loadFile = function (event, previewId) {
  if (previewId == "worksheetDoc" && event.target.files[0]) {
    var worksheetDocpreview = document.getElementById("worksheetDocPreview");
    worksheetDocpreview.innerHTML = event.target.files[0].name;
  }
};

function showError(id, color, message) {
  if (id != "") document.getElementById(id).style.backgroundColor = color;
  document.getElementById("errorMessage").innerHTML = message;
}

function setHeaders() {
  workSheetId = document.getElementById("workSheetId").value.trim();
  workSheetDate = document.getElementById("workSheetDate").value.trim();
  workSheetTItle = document.getElementById("workSheetTItle").value.trim();
  worksheetDoc = document.getElementById("worksheetDoc");
  type = document.getElementById("type").value.trim();
  linkId = document.getElementById("linkId").value.trim();
  type = document.getElementById("type").value.trim();
  // linkId = document.getElementById("linkId").value.trim();

  return 1;
}

function toggleInputFields() {
  const typeSelect = document.getElementById("type");
  const linkInputDiv = document.getElementById("linkInputDiv");
  const fileInputDiv = document.getElementById("fileInputDiv");

  if (typeSelect.value === "Link") {
    linkInputDiv.classList.remove("hidden");
    fileInputDiv.classList.add("hidden");
  } else if (typeSelect.value === "Document") {
    linkInputDiv.classList.add("hidden");
    fileInputDiv.classList.remove("hidden");
  } else {
    linkInputDiv.classList.add("hidden");
    fileInputDiv.classList.add("hidden");
  }
}

function validation() {
  if (setHeaders() == 0) return 0;

  if (workSheetDate == "") {
    showError("workSheetDate", "#ff6666", "Please Select Date");
    return 0;
  } else showError("workSheetDate", "", "");

  if (workSheetTItle == "") {
    showError("workSheetTItle", "#ff6666", "Please Add Title");
    return 0;
  } else showError("workSheetTItle", "", "");

  if (type == "") {
    showError("type", "#ff6666", "Type cannot be Blank");
    return 0;
  } else showError("type", "", "");

  if (type == "Link" && linkId == "") {
    showError("linkId", "#ff6666", "Please Add Link");
    return 0;
  } else showError("linkId", "", "");

  if (type == "Document" && worksheetDoc.files.length == 0) {
    showError("worksheetButton", "#ff6666", "Please Add Worksheet");
    return 0;
  } else showError("worksheetButton", "", "");

  if (type == "Document" && worksheetDoc.files.length > 0) {
    workSheetFlag = "true";
   
    var imgSize = (
      parseFloat(worksheetDoc.files[0].size / 1024) / 1024
    ).toFixed(2);
    if (imgSize > 2) {
      showError("", "", "Document size should not exceed 2 MB.");
      return 0;
    } else showError("", "", "");
  }
  return 1;
}

function saveWorksheet() {
  if (setHeaders() == 0) return 0;
  if (validation() == 0) return 0;

  var saveFlag = "SAVEWORKSHEET";
  formData = new FormData();
  formData.append("saveFlag", saveFlag);
  formData.append("workSheetId", workSheetId);
  formData.append("workSheetDate", workSheetDate);
  formData.append("workSheetTItle", workSheetTItle);
//   formData.append("workSheet", workSheet/);
  formData.append("workSheetFlag", workSheetFlag);

  formData.append("type", type);

  if (type == 'Document') {
      formData.append('workSheet', worksheetDoc.files[0]);
  } else if (type == 'Link') {
      formData.append('workSheetLink', linkId);
  }

  document.getElementById("successMessage").innerHTML = "Saving Please Wait...";

  $.ajax({
    url: "saveWorksheet.php",
    type: "POST",
    data: formData,
    processData: false,
    contentType: false,
    enctype: "multipart/form-data",
    success: function (data) {
      console.log(data);
      document.getElementById("successMessage").innerHTML =
        "Saved Successfully.";
      document.getElementById("saveButton").disabled = true;
      // location.reload();
    },
  });
}

function deleteWorksheet(workSheetId) {
  console.log(workSheetId);
  var saveFlag = "DELETESHEET";
  formData = new FormData();
  formData.append("saveFlag", saveFlag);
  formData.append("workSheetId", workSheetId);
  if (confirm("Are you sure you want to delete worksheet ??")) {
    $.ajax({
      url: "deleteWorksheet.php",
      type: "POST",
      data: formData,
      processData: false,
      contentType: false,
      enctype: "multipart/form-data",
      success: function (data) {
        console.log(data);
        location.reload();
      },
    });
  }
}
