function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("semester")) {
            options.value = options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function filterOtherDropDown(flag)
{
    tempSemester = getSelectValues('', document.getElementById("semester")).trim();
    tempSubjectName = [];
    if (flag == "semester") {
        loadDataDropdown("subjectName", []);
        for (let i = 0; i < masterSubjectName.length; i++) {
            if (masterSubjectName[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": masterSubjectName[i].subjectId.trim(),
                    "subjectName": masterSubjectName[i].subjectName.trim()
                });
            }
            loadDataDropdown("subjectName", tempSubjectName);
        }
        var table = $('#reviewTable').DataTable();
        table.draw();
    }
    else if(flag == 'subject'){
        var table = $('#reviewTable').DataTable();
        table.draw();
    }
}

function resetReview() {
    noOfRating = 0;
    for (let i = 0; i < 10; i++) {
        document.getElementById("rating" + (i + 1)).className = "btn btn-scale btn-scale-desc-" + (i + 1);
    }
}

function countRating(elementId) {
    var temp = elementId.split("rating");
    resetReview();
    noOfRating = temp[1];
    document.getElementById(elementId).className = "btn btn-scale btn-scale-desc-" + temp[1] + " btn-border";
}

function viewAssignmentReview(assignmentId, reviewId, unitNo, noOfLectures, noOfPenaltyFlag) {
    encodedValue_assignmentId = btoa(assignmentId);
    encodedValue_reviewId = btoa(reviewId);
    encodedValue_unitNo = btoa(unitNo);
    encodedValue_noOfLectures = btoa(noOfLectures);
    encodedValue_noOfPenaltyFlag = btoa(noOfPenaltyFlag);

    encodedKey_aId = btoa('aId');
    encodedKey_rId = btoa('rId');
    encodedKey_uNo = btoa('uNo');
    encodedKey_nOL = btoa('nOL');

    window.location.href = "viewReview.php?" + encodedKey_aId + "=" + encodedValue_assignmentId + "&" + encodedKey_rId + "=" + encodedValue_reviewId + "&" + encodedKey_uNo + "=" + encodedValue_unitNo + "&" + encodedKey_nOL + "=" + encodedValue_noOfLectures + "&nOpf=" + encodedValue_noOfPenaltyFlag;
}