<span id="paeDetails">
    <div class="card-body">
        <table class="table table-striped projects tAC" id="reviewTable">
            <thead>
                <tr>
                    <th>
                        ASSIGNMENT NO
                    </th>
                    <th>
                        UNIT NO
                    </th>
                    <th>
                        BATCH
                    </th>
                    <th>
                        SEMESTER
                    </th>
                    <th>
                        SUBJECT
                    </th>
                    <th>
                        REVIEW DATE
                    </th>
                    <th>
                        TOTAL MINUTES APPROVED
                    </th>
                    <th>
                        NO OF RED FLAGS
                    </th>
                    <th>
                        REVIEW RATING
                    </th>
                    <th>
                        REVIEW STATUS
                    </th>
                    <th>
                        ACTIONS
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                require_once '../../common/connectToDB.php';
                if (isset($_POST['facultyId'])) {
                    $facultyId = $_POST['facultyId'];
                    $filteredSubject = $_POST['filteredSubject'];
                    $filteredSemester = $_POST['filteredSemester'];
                    $filteredBatch = $_POST['filteredBatch'];

                    $sql    = "SELECT a.tableunitno,a.subjectName,a.batchName,re.reviewId,re.assignmentId,re.reviewStatus,re.reviewDate,re.noOfRatings,re.comments,a.semester,a.subjectName,a.facultyName,a.facultyId FROM f_assignment AS a,review AS re WHERE a.assignmentId = re.assignmentId AND a.tableunitno = re.unitNo AND a.facultyId = '" . $facultyId . "' ";

                    if (count($filteredSemester) > 0 && strlen($filteredSemester[0]) != 0) {
                        $sql = $sql . " AND a.semester IN (";
                        for ($i = 0; $i < count($filteredSemester); $i++) {
                            $sql = $sql . "'" . $filteredSemester[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ')';
                    }
                    if (count($filteredSubject) > 0 && strlen($filteredSubject[0]) != 0) {
                        $sql = $sql . " AND a.subjectName IN (";
                        for ($i = 0; $i < count($filteredSubject); $i++) {
                            $sql = $sql . "'" . $filteredSubject[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ')';
                    }
                    $sql = $sql . " AND 1 GROUP BY a.assignmentId,a.tableunitno order by a.assignmentId desc;";
                    $result = $conn->query($sql);
                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            if ($row['reviewStatus'] == 'UNDER REVIEW') $statusCss = 'badge badge-warning';
                            if ($row['reviewStatus'] == 'COMPLETED') $statusCss = 'badge badge-success';

                            $reviewId = '"' . $row['reviewId'] . '"';
                            $tableUnitNo = $row['tableunitno'];
                            $tUnitNo = '"' . $row['tableunitno'] . '"';
                            $id = $row['assignmentId'];

                            $penaltyFlag = '';
                            $noOfLectures = 0;
                            $noOfPenaltyFlags = 0;
                            $approvedExecutionMinutes = '';
                            $noOfRating = '';
                            $reviewStatusCss = '';

                            $noOfRating = $row['noOfRatings'];
                            if ($noOfRating != '') $noOfRating = $noOfRating . '/10';

                            $sql2 = "SELECT GROUP_CONCAT(ae.penaltyFlag) AS penaltyFlagArray, COUNT(ae.lectureSplitId) AS noOfLectures, ac.approvedExecutionMinutes FROM f_assignmentexecution ae LEFT JOIN f_accounts ac ON ae.assignmentId = ac.assignmentId AND ae.tableunitno = ac.unitNo WHERE ae.assignmentId = '" . $id . "' AND ae.tableUnitNo = '" . $tableUnitNo . "' GROUP BY ae.assignmentId,ae.tableUnitNo;";
                            $result2 = $conn->query($sql2);

                            if ($result2->num_rows > 0) {
                                while ($row2 = $result2->fetch_assoc()) {
                                    $penaltyFlag = '';
                                    $noOfLectures = '';
                                    $noOfPenaltyFlags = 0;

                                    $penaltyFlag = $row2['penaltyFlagArray'];
                                    $noOfLectures = $row2['noOfLectures'];
                                    $approvedExecutionMinutes = $row2['approvedExecutionMinutes'];
                                }
                            }
                            $penaltyFlagArray = explode(',', $penaltyFlag);
                            for ($i = 0; $i < count($penaltyFlagArray); $i++) {
                                if ($penaltyFlagArray[$i] == 'true')
                                    $noOfPenaltyFlags += 1;
                            }
                            if ($noOfPenaltyFlags > 0) $flagStatusCss = "badge badge-danger";
                            else $flagStatusCss = "";

                            if ($row["reviewStatus"] == 'PENDING') $reviewStatusCss = 'badge badge-danger';
                            if ($row["reviewStatus"] == 'UNDER REVIEW') $reviewStatusCss = 'badge badge-warning';
                            if ($row["reviewStatus"] == 'COMPLETED') $reviewStatusCss = 'badge badge-success';

                            echo "
                                <tr  class='tAC'>
                                    <td>" . $row["assignmentId"] . "</td>
                                    <td>" . $row["tableunitno"] . "</td>
                                    <td>" . str_replace('|', ',', $row['batchName']) . "</td>
                                    <td>" . $row["semester"] . "</td>
                                    <td>" . $row["subjectName"] . "</td>
                                    <td>" . $row["reviewDate"] . "</td>
                                    <td>" . $approvedExecutionMinutes . "</td>
                                    <td>" . $noOfPenaltyFlags . '/' . $noOfLectures . "</td>
                                    <td>" . $noOfRating . "</td>
                                    <td><span class = '" . $reviewStatusCss . "'>" . $row["reviewStatus"] . "</span></td>";
                                    if($row["reviewStatus"] == 'COMPLETED') {
                                    echo "<td class='project-actions'>
                                        <a class='btn btn-primary btn-sm' href='#' id = " . $id . " onclick='viewAssignmentReview(this.id,$reviewId,$tUnitNo,$noOfLectures,$noOfPenaltyFlags)' title='Click hear to view Assignment review'>
                                            <i class='fas fa-eye'></i>
                                            </i>
                                        </a>
                                    </td>";
                                    } else echo "<td></td>";
                            echo "</tr>";
                        }
                    }
                }
                ?>
            </tbody>
        </table>
    </div>
</span>
<script>
    $(function() {
        $("#reviewTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>