<?php
session_start();
if (isset($_SESSION['facultyLoginSuccessEdj'])) {
    if ($_SESSION['facultyLoginSuccessEdj'] > 0) {
    } else {
        header('Location: ../../facultyLogin.php');
        exit;
    }
} else {
    header('Location: ../../facultyLogin.php');
    exit;
}
require_once '../../common/connectToDB.php';
$facultyId = $_SESSION['facultyId'];

$masterSemester = [];
$sql = "SELECT * FROM semester";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterSemester, $row);
    }
}

$masterSubjectName = [];
$sql2 = "SELECT * FROM subjects ORDER BY subjectName;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSubjectName, $row2);
    }
}

$masterBatchDetails = [];
$sql = "SELECT * FROM batchmaster ORDER BY batchId DESC;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterBatchDetails, $row);
    }
}

require '../../common/header.php';
require '../../common/navbar.php';
?>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Unitwise Review</h3>
                            <br><br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Batch</label>
                                        <select class="select2" multiple="multiple" id="filterBatchCode" style="width: 100%;" onchange="filterOtherDropDown('batch');" data-placeholder="SELECT BATCH">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Semester</label>
                                        <select class="Select2" multiple="multiple" id="semester" style="width: 100%;" onchange="filterOtherDropDown('semester');" data-placeholder="SELECT SEMESTER">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">Filter By Subject Name</label>
                                        <select class="Select2" multiple="multiple" id="subjectName" style="width: 100%;" onchange="filterOtherDropDown('subject');" data-placeholder="SELECT SUBJECT">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-1 tAC">
                                    <div class="form-group">
                                        <input type="button" class="btn btn-primary mT27" value="Get List" id="generateDetails" />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <span id="savedData"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php require 'manageAllAssignmentReviewDetails.php' ?>
                    </div>
                </div>
            </div>
    </section>
</div>

<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageAllAssignmentReview.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var masterSemester = <?php echo json_encode($masterSemester); ?>;
    var masterSubjectName = <?php echo json_encode($masterSubjectName); ?>;
    var masterBatchDetails = <?php echo json_encode($masterBatchDetails) ?>;
    var facultyId = '<?php echo $facultyId; ?>';

    $(function() {
        $('.select2').select2();
        var filteredSemester = '',
            filteredSubject = '',
            filteredBatch = '';

        $("#generateDetails").click(() => {
            filteredSemester = getSelectValues('multiple', document.getElementById("semester")).trim().slice(0, -1);
            filteredSubject = getSelectValues('multiple', document.getElementById("subjectName")).trim().slice(0, -1);
            filteredBatch = getSelectValues('multiple', document.getElementById("filterBatchCode")).trim().slice(0, -1);

            document.getElementById('generateDetails').disabled = true;
            document.getElementById("successMessage").innerHTML = "Please wait while we load the data.";
            $.post('manageAllAssignmentReviewDetails.php', {
                'filteredSemester': filteredSemester.split('|'),
                'filteredSubject': filteredSubject.split('|'),
                'filteredBatch': filteredBatch.split('|'),
                'facultyId': facultyId
            }, function(data) {
                $('#paeDetails').html(data);
                document.getElementById("successMessage").innerHTML = "";
                document.getElementById('generateDetails').disabled = false;
            });
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedSemesterName = getSelectValues('', document.getElementById("semester")).trim();
                selectedSubjectName = getSelectValues('', document.getElementById("subjectName")).trim();
                selectedBatch = getSelectValues('', document.getElementById("filterBatchCode")).trim();

                var rowSemesterName = data[3];
                var rowSubjectName = data[4];
                var rowBatch = data[2];

                if (selectedSemesterName != '') {
                    inSemesterName = (selectedSemesterName.indexOf(rowSemesterName) !== -1) ? rowSemesterName : false;
                } else inSemesterName = true;

                if (selectedSubjectName != '') {
                    inSubjectName = (selectedSubjectName.indexOf(rowSubjectName) !== -1) ? rowSubjectName : false;
                } else inSubjectName = true;

                if (selectedBatch != '') {
                    inBatch = (selectedBatch.indexOf(rowBatch) !== -1) ? rowBatch : false;
                } else inBatch = true;

                return inSemesterName && inSubjectName && inBatch;
            }
        );
        loadDataDropdown("semester", masterSemester);
        loadDataDropdown("filterBatchCode", masterBatchDetails);
    });
</script>
<?php require '../../common/footer.php'; ?>