function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function showIcon() {
    document.getElementById('dateIcon').hidden = true;
    document.getElementById('clearDate').hidden = false;
    document.getElementById('iconBackground').style.backgroundColor = '#ff6666';
}

function clearDate() {
    document.getElementById('assignmentDate').value = '';
    var element = document.getElementById('assignmentDate');
    var event = new Event('change');
    element.dispatchEvent(event);
    document.getElementById('dateIcon').hidden = false;
    document.getElementById('clearDate').hidden = true;
    document.getElementById('iconBackground').style.backgroundColor = '';
}

function showDetails(lecId, id, lecSplitId) {
    encodedValue_id = btoa(id);
    encodedValue_lecId = btoa(lecId);
    encodedValue_lecSplitId = btoa(lecSplitId);

    encodedKey_assignmentId = btoa('assignmentId');

    // window.location.href = 'viewAssignmentExecution.php?assignmentId=' + id + "&lecId=" + lecId + "&lSid=" + lecSplitId;
    window.location.href = 'viewAssignmentExecution.php?' + encodedKey_assignmentId + "=" + encodedValue_id + "&lecId=" + encodedValue_lecId + "&lSid=" + encodedValue_lecSplitId;
}

function editLectureDetails(lecId, id, lecSplitId, unitNo) {
    encodedValue_id = btoa(id);
    encodedValue_lecId = btoa(lecId);
    encodedValue_lecSplitId = btoa(lecSplitId);
    encodedValue_unitNo = btoa(unitNo);
    encodedKey_assignmentId = btoa('assignmentId');

    // window.location.href = 'editLectureDetails.php?assignmentId=' + id + "&lecId=" + lecId + "&lSid=" + lecSplitId + "&uN=" + unitNo;
    window.location.href = 'editLectureDetails.php?' + encodedKey_assignmentId + "=" + encodedValue_id + "&lecId=" + encodedValue_lecId + "&lSid=" + encodedValue_lecSplitId + "&uN=" + encodedValue_unitNo;
}
function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function addVideoLinkDisplay(lecMode) {
    document.getElementById('lecVideoLink').value = '';
    if (lecMode.trim().toUpperCase() == 'ONLINE') {
        document.getElementById('lecVideoLinkLabel').hidden = false;
        document.getElementById('lecVideoLink').hidden = false;
    }
    else if (lecMode.trim().toUpperCase() == 'CLASSROOM') {
        document.getElementById('lecVideoLinkLabel').hidden = true;
        document.getElementById('lecVideoLink').hidden = true;
    }
}
function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");
    else if (selectName == "assignmentIdDrpodown") dummyOptions(theSelect, options, "ASSIGNMENT ID");
    let tempArray = [];

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("assignmentIdDrpodown")) {
            options.value = options.text = results[i].assignmentId.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("filterBatchCode")) {
            options.text = results[i]['batchTitle'];
            options.value = results[i]['batchId'];
            theSelect.add(options);
        }
    }
    return;
}

function filterOtherDropDown(flag) {
    tempSubject = getSelectValues('multiple', document.getElementById("subjectName")).trim();
    tempSubjectArray = tempSubject.split('|');
    tempSubjectName = [];
    tempSessionCodeName = [];
    tempAssignmentId = [];
    newAssignmentIdArray = [];
    if (flag == "subjectName") {
        for (let i = 0; i < masterAssignmentData.length; i++) {
            for (let j = 0; j < tempSubjectArray.length; j++) {
                if (masterAssignmentData[i].subjectName == tempSubjectArray[j]) {
                    newAssignmentIdArray.push(obj = {
                        "assignmentId": masterAssignmentData[i].assignmentId.trim()
                    });
                }
            }
        }
        loadDataDropdown("assignmentIdDrpodown", newAssignmentIdArray);
    }
    var table = $('#example1').DataTable();
    table.draw();
}

function editLectureAssignment(id, lecId, flag, unitNo) {
    encodedValue_id = btoa(id);
    encodedValue_lecId = btoa(lecId);
    encodedValue_flag = btoa(flag);
    encodedValue_unitNo = btoa(unitNo);
    window.location.href = 'editAssignmentExecution.php?aId=' + encodedValue_id + "&lId=" + encodedValue_lecId + "&f=" + encodedValue_flag + "&uN=" + encodedValue_unitNo;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function deleteRow(rows) {
    var _row = rows.parentElement.parentElement.parentElement;
    document.getElementById("tableBody").deleteRow(_row.rowIndex - 1);
    const table = document.getElementById("tableBody");
    for (let i = 0; i < table.rows.length; i++) {
        table.rows[i].cells[0].innerHTML = (i + 1);
        table.rows[i].cells[1].getElementsByTagName("div")[0].getElementsByTagName("div")[0].id = "lectureDate" + i;
        table.rows[i].cells[1].getElementsByTagName("div")[0].getElementsByTagName("div")[0].getElementsByTagName("input")[0].id = "lectureDate" + i;
        table.rows[i].cells[1].getElementsByTagName("div")[0].getElementsByTagName("div")[0].getElementsByTagName("input")[0].dataset.target = "lectureDate" + i;
        table.rows[i].cells[1].getElementsByTagName("div")[0].getElementsByTagName("div")[0].getElementsByTagName("div")[0].dataset.target = "lectureDate" + i;
        table.rows[i].cells[2].getElementsByTagName("input")[0].id = "lectureStartTime" + i;
        table.rows[i].cells[3].getElementsByTagName("input")[0].id = "lectureEndTime" + i;
        table.rows[i].cells[4].getElementsByTagName("input")[0].id = "lectureDuration" + i;
        table.rows[i].cells[5].getElementsByTagName("div")[0].getElementsByTagName("input")[0].id = "addButton" + i;
        if (i > 0)
            table.rows[i].cells[5].getElementsByTagName("div")[0].getElementsByTagName("input")[1].id = "deleteButton" + i;
    }
    calculateDuration();
}

var grandTotalMin = '';
function calculateDuration() {
    if (checkTableContentIsNotEmpty() == 0) return 0;
    grandTotalMin = 0;
    var table = document.getElementById("tableBody");
    for (let i = 0; i < table.rows.length; i++) {
        var totalMin = 0;
        sTime = document.getElementById("lectureStartTime" + i).value;
        eTime = document.getElementById("lectureEndTime" + i).value;

        if (sTime > eTime) {
            showError('lectureStartTime' + i, '#ff6666', "");
            showError('lectureEndTime' + i, '#ff6666', "Start Time cannot be greater than End Time.");
            return 0;
        } else {
            showError('lectureStartTime' + i, '', '');
            showError('lectureEndTime' + i, '', '');
        }

        sTime = sTime.split(':');
        eTime = eTime.split(':');

        var hours1 = parseInt(sTime[0], 10),
            hours2 = parseInt(eTime[0], 10),
            mins1 = parseInt(sTime[1], 10),
            mins2 = parseInt(eTime[1], 10);
        var hours = hours2 - hours1,
            mins = 0;

        // get hours
        if (hours < 0) hours = 24 + hours;

        // get minutes
        if (mins2 >= mins1) {
            mins = mins2 - mins1;
        } else {
            mins = (mins2 + 60) - mins1;
            hours--;
        }

        if (hours > 0) {
            totalMin = 60 * hours;
        }
        totalMin = parseFloat(totalMin) + parseFloat(mins);
        $("#lectureDuration" + i).val(totalMin);
        grandTotalMin = parseFloat(grandTotalMin) + parseFloat(totalMin);
    }
    document.getElementById("totalHrs").innerHTML = grandTotalMin;
}

function resetTableErrors() {
    const table = document.getElementById("tableBody");
    if (table.rows[0].cells[0].className != "dataTables_empty")
        for (let r = 0, n = table.rows.length; r < n; r++) {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        }
}

function checkTableContentIsNotEmpty() {
    resetTableErrors();
    const table = document.getElementById("tableBody");

    if (table.rows[0].cells[0].className != "dataTables_empty") {
        for (let r = 0, n = table.rows.length; r < n; r++) {

            // Lecture Date
            if (table.rows[r].cells[1].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Lecture Date.");
                return 0;
            } else
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

            tempSelectedDate = table.rows[r].cells[1].getElementsByTagName("input")[0].value;
            tempSelectedDateArray = tempSelectedDate.split("/");
            convertedSelectedDate = tempSelectedDateArray[2] + '-' + tempSelectedDateArray[1] + '-' + tempSelectedDateArray[0];
            var currentDate = new Date();
            if (new Date(convertedSelectedDate) > currentDate) {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Lecture Date can not be a future date");
                return 0;
            }
            else {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
            }

            // Lecture Date
            if (table.rows[r].cells[2].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Start Time.");
                return 0;
            } else
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

            // Lecture Date
            if (table.rows[r].cells[3].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter End Time.");
                return 0;
            } else
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        }
    }

    showError('', '', '');
    return 1;
}

function addLectureDetailsRow(result, disFlag) {
    var mytable = document.getElementById("tableBody"),
        newRow,
        newCell;
    mytable.innerHTML = '';

    var currentIndex = 0;
    var currentIndex = mytable.rows.length;
    var newRow = document.createElement("tr");
    mytable.appendChild(newRow);

    if (result.length > 0) {
        lectureDate = result[0]['lectureDate'];
        lectureStartTime = result[0]['startTime'];
        lectureEndTime = result[0]['endTime'];
    }

    // index cell
    newCell = document.createElement("td");
    newCell.style.fontSize = "20px";
    newCell.innerHTML = currentIndex + 1;
    newRow.appendChild(newCell);

    // lecture date cell
    newCell = document.createElement("td");
    // let date = document.createElement("div");
    // date.className = "form-group";
    // let inputDate = document.createElement("input");
    // inputDate.className = "form-control";
    // inputDate.type = 'date';
    // inputDate.id = "lectureDate" + currentIndex;
    // inputDate.setAttribute("placeholder", "Lecture Date*");
    if (result.length > 0) var divMain = cDP(currentIndex, result[0]['lectureDate'], disFlag);
    else var divMain = cDP(currentIndex, '', false);

    newCell.appendChild(divMain);
    newRow.appendChild(newCell);

    // lecture start time cell
    newCell = document.createElement("td");
    let startTime = document.createElement("div");
    startTime.className = "form-group";
    let inputSt = document.createElement("input");
    inputSt.className = "form-control";
    inputSt.type = 'time';
    inputSt.disabled = disFlag;
    inputSt.id = "lectureStartTime" + currentIndex;
    inputSt.setAttribute("placeholder", "Lecture Start Time*");
    startTime.append(inputSt);
    newCell.appendChild(startTime);
    newRow.appendChild(newCell);

    // lecture End time cell
    newCell = document.createElement("td");
    let endTime = document.createElement("div");
    endTime.className = "form-group";
    let inputEt = document.createElement("input");
    inputEt.className = "form-control";
    inputEt.type = 'time';
    inputEt.disabled = disFlag;
    inputEt.id = "lectureEndTime" + currentIndex;
    inputEt.setAttribute("placeholder", "Lecture End Time*");
    endTime.append(inputEt);
    newCell.appendChild(endTime);
    newRow.appendChild(newCell);

    // lectre duration cell
    newCell = document.createElement("td");
    let lDuration = document.createElement("div");
    lDuration.className = "form-group";
    let inputDt = document.createElement("input");
    inputDt.className = "form-control tAC";
    inputDt.id = "lectureDuration" + currentIndex;
    inputDt.setAttribute("placeholder", "Lecture Duration");
    inputDt.disabled = true;
    lDuration.append(inputDt);
    newCell.appendChild(lDuration);
    newRow.appendChild(newCell);

    $('#lectureDate' + currentIndex).datetimepicker({
        format: 'DD/MM/YYYY',
        dateFormat: 'DD/MM/YYYY'
    });
    $('#lectureStartTime' + currentIndex).datetimepicker({
        format: 'H:m a',
        datepicker: false,
    });
    $('#lectureEndTime' + currentIndex).datetimepicker({
        format: 'H:m a',
        datepicker: false,
    });
    $("#lectureStartTime" + currentIndex).on('change keyup paste', function () {
        calculateDuration();
    });

    $("#lectureEndTime" + currentIndex).on('change keyup paste', function () {
        calculateDuration();
    });

    if (result.length > 0) {
        document.getElementById("lectureStartTime" + currentIndex).value = lectureStartTime;
        document.getElementById("lectureEndTime" + currentIndex).value = lectureEndTime;
        calculateDuration();
    }

    resetTableErrors();
}
lectureMode = '';
lectureVideoLink = '';
function setHeaders() {
    suggestedQuestion = '';
    assessmentTechniques = '';
    analysis = '';
    outcome = '';
    lectureStatus = '';
    lectureVideoLink = '';
    lectureMode = '';

    suggestedQuestion = document.getElementById("suggestedQuestion").value.trim();
    assessmentTechniques = document.getElementById("assessmentTechniques").value.trim();
    analysis = document.getElementById("analysis").value.trim();
    outcome = document.getElementById("outcome").value.trim();
    lectureStatus = document.getElementById("assignmentStatus").value.trim();
    lectureVideoLink = document.getElementById("lecVideoLink").value.trim();
    lectureMode = document.getElementById("lectureMode").value.trim();

    return 1;
}

function checkTextFieldIsNotEmpty() {
    if (suggestedQuestion.length <= 0) {
        document.getElementById("suggestedQuestion").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Suggested Questions or Any Reference Book");
        return 0;
    } else {
        document.getElementById("suggestedQuestion").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
    if (suggestedQuestion.length < 40) {
        document.getElementById("suggestedQuestion").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
        return 0;
    } else {
        document.getElementById("suggestedQuestion").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (assessmentTechniques.length <= 0) {
        document.getElementById("assessmentTechniques").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Assessment Techniques");
        return 0;
    } else {
        document.getElementById("assessmentTechniques").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (assessmentTechniques.length < 40) {
        document.getElementById("assessmentTechniques").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
        return 0;
    } else {
        document.getElementById("assessmentTechniques").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (analysis.length <= 0) {
        document.getElementById("analysis").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Activities / Self Analysis");
        return 0;
    } else {
        document.getElementById("analysis").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (analysis.length < 40) {
        document.getElementById("analysis").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
        return 0;
    } else {
        document.getElementById("analysis").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (outcome.length <= 0) {
        document.getElementById("outcome").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Outcome");
        return 0;
    } else {
        document.getElementById("outcome").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (outcome.length < 40) {
        document.getElementById("outcome").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
        return 0;
    } else {
        document.getElementById("outcome").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    showError('', '', '');
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\"");
    return output;
}

function formValidation(flag) {
    if (setHeaders() == 0) return 0;
    if (document.getElementById('totalActualTime').value == 0) {
        if (checkTableContentIsNotEmpty() == 0) return 0;
        if (checkTextFieldIsNotEmpty() == 0) return 0;
    }
    const table = document.getElementById("tableBody");
    if (table.rows[0].cells[0].className != "dataTables_empty") {
        for (let r = 0, n = table.rows.length; r < n; r++) {
            // if (table.rows[r].cells[1].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[2].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[3].getElementsByTagName("input")[0].value != '' || suggestedQuestion.length > 0 || assessmentTechniques.length > 0 || interactiveSession.length > 0 || industryProfile.length > 0 || analysis.length > 0 || outcome.length > 0) {
            if (table.rows[r].cells[1].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[2].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[3].getElementsByTagName("input")[0].value != '' || suggestedQuestion.length > 0 || assessmentTechniques.length > 0 || analysis.length > 0 || outcome.length > 0) {
                if (checkTableContentIsNotEmpty() == 0) return 0;
                if (checkTextFieldIsNotEmpty() == 0) return 0;
                if (document.getElementById('lectureMode').value.trim() == 'SELECT LECTURE MODE') {
                    showError('lectureMode', '#ff6666', "Select lecture mode");
                    return 0;
                }
                else showError('', '', '');
                if (document.getElementById('lecVideoLink').hidden) { }
                else {
                    if (lectureVideoLink == '') {
                        showError('lecVideoLink', '#ff6666', "Add lecture video link");
                        return 0;
                    }
                    else showError('', '', "");
                }
            }
            else if (document.getElementById('assignmentStatus').value.trim() == 'PENDING') {
                showError('', '#ff6666', "Select assignment status");
                return 0;
            }
            else {
                showError('', '', "");
            }
        }
    }
    if (setLectureData() == 0) return 0;
    // if (makeArray() == 0) return 0;
    return 1;
}

function setLectureData() {
    lectureDate = '',
        lectureStartTime = '',
        lectureEndTime = '',
        lectureActualTime = '',
        lectureDuration = grandTotalMin;
    let table = document.getElementById("tableBody");
    for (let i = 0; i < table.rows.length; i++) {
        lectureDate = lectureDate + table.rows[i].cells[1].getElementsByTagName("input")[0].value + "|||";
        lectureStartTime = lectureStartTime + table.rows[i].cells[2].getElementsByTagName("input")[0].value + "|||";
        lectureEndTime = lectureEndTime + table.rows[i].cells[3].getElementsByTagName("input")[0].value + "|||";
        lectureActualTime = lectureActualTime + table.rows[i].cells[4].getElementsByTagName("input")[0].value + "|||";
    }
    lectureDate = lectureDate.slice(0, -3),
        lectureStartTime = lectureStartTime.slice(0, -3),
        lectureEndTime = lectureEndTime.slice(0, -3),
        lectureActualTime = lectureActualTime.slice(0, -3)
    return 1;
}

function makeArray() {
    contentArray = [];
    suggestedQuestion = escapeSpecialCharacters(suggestedQuestion);
    assessmentTechniques = escapeSpecialCharacters(assessmentTechniques);
    analysis = escapeSpecialCharacters(analysis);
    outcome = escapeSpecialCharacters(outcome);

    lectureDuration = Math.floor(lectureDuration / 10) * 10;
    lectureActualTime = Math.floor(lectureActualTime / 10) * 10;

    var obj = {
        'assignmentId': assignmentId,
        'lecId': lecId,
        'unitNo': document.getElementById("unitNo").value.trim(),
        'planDate': document.getElementById("planDate").value.trim(),
        'lectureDate': lectureDate,
        'lectureStartTime': lectureStartTime,
        'lectureEndTime': lectureEndTime,
        'lectureActualTime': lectureActualTime,
        'lectureDuration': lectureDuration,
        'suggestedQuestion': suggestedQuestion,
        'assessmentTechniques': assessmentTechniques,
        'analysis': analysis,
        'outcome': outcome,
        'noOfRows': noOfRows,
        'lectureMode': lectureMode,
        'lectureVideoLink': lectureVideoLink,
        // 'facultyId': facultyId,
        // 'lectureId': lectureId,
        // 'TLPdataEntryDateTimeArray': TLPdataEntryDateTimeArray,
    }
    contentArray.push(obj);
    return 1;
}

function makeEditArray() {
    contentArray = [];
    suggestedQuestion = escapeSpecialCharacters(suggestedQuestion);
    assessmentTechniques = escapeSpecialCharacters(assessmentTechniques);
    analysis = escapeSpecialCharacters(analysis);
    outcome = escapeSpecialCharacters(outcome);

    lectureDuration = Math.floor(lectureDuration / 10) * 10;
    lectureActualTime = Math.floor(lectureActualTime / 10) * 10;

    var obj = {
        'assignmentId': assignmentId,
        'lecId': lecId,
        'unitNo': document.getElementById("unitNo").value.trim(),
        'planDate': document.getElementById("planDate").value.trim(),
        'lectureDate': lectureDate,
        'lectureStartTime': lectureStartTime,
        'lectureEndTime': lectureEndTime,
        'lectureActualTime': lectureActualTime,
        'lectureDuration': lectureDuration,
        'suggestedQuestion': suggestedQuestion,
        'assessmentTechniques': assessmentTechniques,
        'analysis': analysis,
        'outcome': outcome,
        'noOfRows': noOfRows,
        'lectureSplitId': lectureSplitId,
        'lectureMode': lectureMode,
        'lectureVideoLink': lectureVideoLink,
        // 'lectureId': lectureId,
        // 'TLPdataEntryDateTimeArray': TLPdataEntryDateTimeArray,
    }
    contentArray.push(obj);
    return 1;
}

