
function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}
function addVideoLinkDisplay(lecMode) {
    document.getElementById('lecVideoLink').value = '';
    if (lecMode.trim().toUpperCase() == 'ONLINE') {
        document.getElementById('lecVideoLinkLabel').hidden = false;
        document.getElementById('lecVideoLink').hidden = false;
    }
    else if (lecMode.trim().toUpperCase() == 'CLASSROOM') {
        document.getElementById('lecVideoLinkLabel').hidden = true;
        document.getElementById('lecVideoLink').hidden = true;
    }
}
function calculateDuration() {
    if (checkTableContentIsNotEmpty() == 0) return 0;
    grandTotalMin = 0;
    var table = document.getElementById("tableBody");
    for (let i = 0; i < table.rows.length; i++) {
        var totalMin = 0;
        sTime = document.getElementById("lectureStartTime" + i).value;
        eTime = document.getElementById("lectureEndTime" + i).value;

        if (sTime > eTime) {
            showError('lectureStartTime' + i, '#ff6666', "");
            showError('lectureEndTime' + i, '#ff6666', "Start Time cannot be greater than End Time.");
            return 0;
        } else {
            showError('lectureStartTime' + i, '', '');
            showError('lectureEndTime' + i, '', '');
        }

        sTime = sTime.split(':');
        eTime = eTime.split(':');

        var hours1 = parseInt(sTime[0], 10),
            hours2 = parseInt(eTime[0], 10),
            mins1 = parseInt(sTime[1], 10),
            mins2 = parseInt(eTime[1], 10);
        var hours = hours2 - hours1,
            mins = 0;

        // get hours
        if (hours < 0) hours = 24 + hours;

        // get minutes
        if (mins2 >= mins1) {
            mins = mins2 - mins1;
        } else {
            mins = (mins2 + 60) - mins1;
            hours--;
        }

        if (hours > 0) {
            totalMin = 60 * hours;
        }
        totalMin = parseFloat(totalMin) + parseFloat(mins);
        $("#lectureDuration" + i).val(totalMin);
        grandTotalMin = parseFloat(grandTotalMin) + parseFloat(totalMin);
    }
    document.getElementById("totalHrs").innerHTML = grandTotalMin;
}
function resetTableErrors() {
    const table = document.getElementById("tableBody");
    if (table.rows[0].cells[0].className != "dataTables_empty")
        for (let r = 0, n = table.rows.length; r < n; r++) {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        }
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function checkTableContentIsNotEmpty() {
    resetTableErrors();
    const table = document.getElementById("tableBody");

    // Check if the table is empty
    if (table.rows[0].cells[0].className !== "dataTables_empty") {
        // Iterate through each row
        for (let r = 0, n = table.rows.length; r < n; r++) {
            // Validate lecture date
            if (table.rows[r].cells[1].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Lecture Date.");
                return 0;
            } else {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
            }

            // Handle Lecture Date: Convert from DD-MM-YYYY to YYYY-MM-DD
            let tempSelectedDate = table.rows[r].cells[1].getElementsByTagName("input")[0].value;
            let tempSelectedDateArray = tempSelectedDate.split("-");  // DD-MM-YYYY format
            
            // Convert to YYYY-MM-DD format
            let convertedSelectedDate = `${tempSelectedDateArray[2]}-${tempSelectedDateArray[1]}-${tempSelectedDateArray[0]}`;
            
            let currentDate = new Date();
            console.log('Converted Date:', new Date(convertedSelectedDate));  // Debug the converted date
            console.log('Current Date:', currentDate);  // Debug the current date

            // Compare the lecture date with the current date
            if (new Date(convertedSelectedDate) > currentDate) {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";  // Highlight invalid field
                showError('', '#ff6666', "Lecture Date cannot be a future date.");
                return 0;  // Validation failed
            }

            // Validate start time
            if (table.rows[r].cells[2].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Start Time.");
                return 0; // Exit on error
            } else {
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
            }

            // Validate end time
            if (table.rows[r].cells[3].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter End Time.");
                return 0; // Exit on error
            } else {
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
            }
        }
    }

    showError('', '', '');  // Clear any previous errors
    return 1;  // Everything is valid
}



function addLectureDetailsRow(result, disFlag) {
  const mytable = document.getElementById("tableBody");
  mytable.innerHTML = "";

  const currentIndex = mytable.rows.length;
  const newRow = document.createElement("tr");
  mytable.appendChild(newRow);

  let lectureDate = "";
  let lectureStartTime = "";
  let lectureEndTime = "";

  if (result.length > 0) {
    lectureDate = formatLectureDate(result[0]["lectureDate"]); // Convert to DD-MM-YYYY
    lectureStartTime = result[0]["startTime"];
    lectureEndTime = result[0]["endTime"];
  }

  // Index cell
  let newCell = document.createElement("td");
  newCell.style.fontSize = "20px";
  newCell.innerHTML = currentIndex + 1;
  newRow.appendChild(newCell);

  // Lecture date cell
  newCell = document.createElement("td");
  const divMain = cDP(currentIndex, lectureDate || "", true);
  newCell.appendChild(divMain);
  newRow.appendChild(newCell);

  // Lecture start time cell
  newCell = document.createElement("td");
  const startTime = document.createElement("div");
  startTime.className = "form-group";
  const inputSt = document.createElement("input");
  inputSt.className = "form-control";
  inputSt.type = "time";
  inputSt.disabled = disFlag;
  inputSt.id = "lectureStartTime" + currentIndex;
  startTime.append(inputSt);
  newCell.appendChild(startTime);
  newRow.appendChild(newCell);

  // Lecture end time cell
  newCell = document.createElement("td");
  const endTime = document.createElement("div");
  endTime.className = "form-group";
  const inputEt = document.createElement("input");
  inputEt.className = "form-control";
  inputEt.type = "time";
  inputEt.disabled = disFlag;
  inputEt.id = "lectureEndTime" + currentIndex;
  endTime.append(inputEt);
  newCell.appendChild(endTime);
  newRow.appendChild(newCell);

  // Lecture duration cell
  newCell = document.createElement("td");
  const lDuration = document.createElement("div");
  lDuration.className = "form-group";
  const inputDt = document.createElement("input");
  inputDt.className = "form-control tAC";
  inputDt.id = "lectureDuration" + currentIndex;
  inputDt.setAttribute("placeholder", "Lecture Duration");
  inputDt.disabled = true;

  if (lectureStartTime && lectureEndTime) {
    const start = lectureStartTime.split(":");
    const end = lectureEndTime.split(":");
    const startMinutes = parseInt(start[0]) * 60 + parseInt(start[1]);
    const endMinutes = parseInt(end[0]) * 60 + parseInt(end[1]);
    const duration = endMinutes - startMinutes;

    inputDt.value = duration >= 0 ? duration : 0; // Set the calculated duration
  }

  lDuration.append(inputDt);
  newCell.appendChild(lDuration);
  newRow.appendChild(newCell);

  $("#lectureStartTime" + currentIndex).datetimepicker({
    format: "H:m a",
    datepicker: false,
  });
  $("#lectureEndTime" + currentIndex).datetimepicker({
    format: "H:m a",
    datepicker: false,
  });

  $("#lectureStartTime" + currentIndex).on("change keyup paste", function () {
    calculateDuration();
  });

  $("#lectureEndTime" + currentIndex).on("change keyup paste", function () {
    calculateDuration();
  });

  if (result.length > 0) {
    document.getElementById("lectureStartTime" + currentIndex).value =
      lectureStartTime;
    document.getElementById("lectureEndTime" + currentIndex).value =
      lectureEndTime;
    if (lectureStartTime !== "" && lectureEndTime !== "") calculateDuration();
  }
  resetTableErrors();
}


function formatLectureDate(dateString) {
  console.log("Input to formatLectureDate:", dateString);

  // Check if the input is in DD/MM/YYYY format
  const ddmmyyyyPattern = /^\d{2}\/\d{2}\/\d{4}$/;
  if (ddmmyyyyPattern.test(dateString)) {
    // If it's in DD/MM/YYYY format, convert to DD-MM-YYYY
    return dateString.replace(/\//g, "-"); // Replace slashes with dashes
  }

  // Check if the input is in DD-MM-YYYY format
  const ddmmyyyyPatternDash = /^\d{2}-\d{2}-\d{4}$/;
  if (ddmmyyyyPatternDash.test(dateString)) {
    return dateString; // Return as is
  }

  // Otherwise, assume the input is in YYYY-MM-DD format
  const dateParts = dateString.split(" ")[0].split("-"); // Split date and ignore time
  if (dateParts.length !== 3) {
    console.error("Unexpected date format:", dateString);
    return ""; // Return an empty string or handle error as needed
  }
  const year = dateParts[0]; // Year
  const month = dateParts[1]; // Month
  const day = dateParts[2]; // Day
  return `${day}-${month}-${year}`; // Return in DD-MM-YYYY format
}

lectureMode = '';
lectureVideoLink = '';
function setHeaders() {
    suggestedQuestion = '',
        assessmentTechniques = '',
        analysis = '',
        outcome = '';
    lectureStatus = '';
    lectureVideoLink = '';
    lectureMode = '';

    suggestedQuestion = document.getElementById("suggestedQuestion").value.trim();
    assessmentTechniques = document.getElementById("assessmentTechniques").value.trim();
    analysis = document.getElementById("analysis").value.trim();
    outcome = document.getElementById("outcome").value.trim();
    lectureStatus = document.getElementById("assignmentStatus").value.trim();
    lectureVideoLink = document.getElementById("lecVideoLink").value.trim();
    lectureMode = document.getElementById("lectureMode").value.trim();

    return 1;
}

function checkTextFieldIsNotEmpty() {
    if (suggestedQuestion.length <= 0) {
        document.getElementById("suggestedQuestion").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Suggested Questions or Any Reference Book");
        return 0;
    } else {
        document.getElementById("suggestedQuestion").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
    // if (suggestedQuestion.length < 40) {
    //     document.getElementById("suggestedQuestion").style.backgroundColor = "ff6666";
    //     showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
    //     return 0;
    // } else {
    //     document.getElementById("suggestedQuestion").style.backgroundColor = "";
    //     showError('errorMessage', '', '');
    // }

    if (assessmentTechniques.length <= 0) {
        document.getElementById("assessmentTechniques").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Assessment Techniques");
        return 0;
    } else {
        document.getElementById("assessmentTechniques").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // if (assessmentTechniques.length < 40) {
    //     document.getElementById("assessmentTechniques").style.backgroundColor = "ff6666";
    //     showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
    //     return 0;
    // } else {
    //     document.getElementById("assessmentTechniques").style.backgroundColor = "";
    //     showError('errorMessage', '', '');
    // }

    if (analysis.length <= 0) {
        document.getElementById("analysis").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Activities / Self Analysis");
        return 0;
    } else {
        document.getElementById("analysis").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // if (analysis.length < 40) {
    //     document.getElementById("analysis").style.backgroundColor = "ff6666";
    //     showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
    //     return 0;
    // } else {
    //     document.getElementById("analysis").style.backgroundColor = "";
    //     showError('errorMessage', '', '');
    // }

    if (outcome.length <= 0) {
        document.getElementById("outcome").style.backgroundColor = "ff6666";
        showError('', '#ff6666', "Enter Outcome");
        return 0;
    } else {
        document.getElementById("outcome").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // if (outcome.length < 40) {
    //     document.getElementById("outcome").style.backgroundColor = "ff6666";
    //     showError('', '#ff6666', "TLP Data should be of minimum 40 characters");
    //     return 0;
    // } else {
    //     document.getElementById("outcome").style.backgroundColor = "";
    //     showError('errorMessage', '', '');
    // }

    showError('', '', '');
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\"");
    return output;
}

function formValidation(flag) {
    if (setHeaders() == 0) return 0;
    if (document.getElementById('totalActualTime').value == 0) {
        if (checkTableContentIsNotEmpty() == 0) return 0;
        if (checkTextFieldIsNotEmpty() == 0) return 0;
    }
    const table = document.getElementById("tableBody");
    if (table.rows[0].cells[0].className != "dataTables_empty") {
        for (let r = 0, n = table.rows.length; r < n; r++) {
            // if (table.rows[r].cells[1].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[2].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[3].getElementsByTagName("input")[0].value != '' || suggestedQuestion.length > 0 || assessmentTechniques.length > 0 || interactiveSession.length > 0 || industryProfile.length > 0 || analysis.length > 0 || outcome.length > 0) {
            if (table.rows[r].cells[1].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[2].getElementsByTagName("input")[0].value != '' || table.rows[r].cells[3].getElementsByTagName("input")[0].value != '' || suggestedQuestion.length > 0 || assessmentTechniques.length > 0 || analysis.length > 0 || outcome.length > 0) {
                if (checkTableContentIsNotEmpty() == 0) return 0;
                if (checkTextFieldIsNotEmpty() == 0) return 0;
                if (document.getElementById('lectureMode').value.trim() == 'SELECT LECTURE MODE') {
                    showError('lectureMode', '#ff6666', "Select lecture mode");
                    return 0;
                }
                else showError('', '', '');
                if (document.getElementById('lecVideoLink').hidden) { }
                else {
                    if (lectureVideoLink == '') {
                        showError('lecVideoLink', '#ff6666', "Add lecture video link");
                        return 0;
                    }
                    else showError('', '', "");
                }
            }
            else if (document.getElementById('assignmentStatus').value.trim() == 'PENDING') {
                showError('', '#ff6666', "Select assignment status");
                return 0;
            }
            else {
                showError('', '', "");
            }
        }
    }
    if (setLectureData() == 0) return 0;
    // if (makeArray() == 0) return 0;
    return 1;
}
function setLectureData() {
    lectureDate = '',
        lectureStartTime = '',
        lectureEndTime = '',
        lectureActualTime = '',
        lectureDuration = grandTotalMin;
    let table = document.getElementById("tableBody");
    for (let i = 0; i < table.rows.length; i++) {
        lectureDate = lectureDate + table.rows[i].cells[1].getElementsByTagName("input")[0].value + "|||";
        lectureStartTime = lectureStartTime + table.rows[i].cells[2].getElementsByTagName("input")[0].value + "|||";
        lectureEndTime = lectureEndTime + table.rows[i].cells[3].getElementsByTagName("input")[0].value + "|||";
        lectureActualTime = lectureActualTime + table.rows[i].cells[4].getElementsByTagName("input")[0].value + "|||";
    }
    lectureDate = lectureDate.slice(0, -3),
        lectureStartTime = lectureStartTime.slice(0, -3),
        lectureEndTime = lectureEndTime.slice(0, -3),
        lectureActualTime = lectureActualTime.slice(0, -3)
    return 1;
}
function makeEditArray() {
    contentArray = [];
    suggestedQuestion = escapeSpecialCharacters(suggestedQuestion);
    assessmentTechniques = escapeSpecialCharacters(assessmentTechniques);
    analysis = escapeSpecialCharacters(analysis);
    outcome = escapeSpecialCharacters(outcome);

    lectureDuration = Math.floor(lectureDuration / 10) * 10;
    lectureActualTime = Math.floor(lectureActualTime / 10) * 10;

    var obj = {
        'assignmentId': assignmentId,
        'lecId': lecId,
        'unitNo': document.getElementById("unitNo").value.trim(),
        'planDate': document.getElementById("planDate").value.trim(),
        'lectureDate': lectureDate,
        'lectureStartTime': lectureStartTime,
        'lectureEndTime': lectureEndTime,
        'lectureActualTime': lectureActualTime,
        'lectureDuration': lectureDuration,
        'suggestedQuestion': suggestedQuestion,
        'assessmentTechniques': assessmentTechniques,
        'analysis': analysis,
        'outcome': outcome,
        'noOfRows': noOfRows,
        'lectureSplitId': lectureSplitId,
        'lectureMode': lectureMode,
        'lectureVideoLink': lectureVideoLink,
      
    }
    contentArray.push(obj);
    return 1;
}

function editLecture(flag) {
    console.log(flag);
    var saveFlag = "SAVEFLAG";
    if (formValidation(flag) == 0) return;
    if (makeEditArray() == 0) return;
    if (checkOnline() == false) return;
    else {
        if (confirm("Are you sure you want to Update Lecture??? ")) {
            document.getElementById('successMessage').innerHTML = 'Updating Lecture. Please wait...';
            document.getElementById("saveButton").disabled = true;
            $.post('updateAssignmentExecution.php', {
                'saveFlag': saveFlag,
                'tableFlag': flag,
                'contentArray': contentArray,
                'lectureStatus': lectureStatus,
                'masterExecutionList': masterExecutionList
            }, function (data) {
                document.getElementById('successMessage').innerHTML = 'Lecture Updated Successfully.';
            });
        }
    }
}