<?php
session_start();
if (isset($_SESSION['facultyLoginSuccessEdj'])) {
    if ($_SESSION['facultyLoginSuccessEdj'] > 0) {
    } else {
        header('Location: ../../facultyLogin.php');
        exit;
    }
} else {
    header('Location: ../../facultyLogin.php');
    exit;
}
require_once '../../common/connectToDB.php';
$facultyId = $_SESSION['facultyId'];

require '../../common/header.php';
require '../../common/navbar.php';

$masterBatchDetails = [];
$sql = "SELECT * FROM batchmaster ORDER BY batchId DESC;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterBatchDetails, $row);
    }
}

$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}

$subjectNames = [];
$sql3 = "SELECT * FROM subjects ORDER BY subjectName;";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($subjectNames, $row3);
    }
}
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">All Assignments</h3>
                            <br>
                            <br>
                            <div class='row'>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY BATCH CODE</label>
                                        <select class="select2" multiple="multiple" id="filterBatchCode" data-placeholder="SELECT BATCH CODE" style="width: 100%;" onchange="filterTable('batch')" ;>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                        <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterTable('studAyear')" ;>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY SUBJECTS</label>
                                        <select class="select2" multiple="multiple" id="filterSubject" data-placeholder="SELECT SUBJECT" style="width: 100%;" onchange="filterTable('subject')" ;>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="example1">
                                <thead>
                                    <tr>
                                        <th class='col-md-1'>
                                            ASSIGNMENT ID
                                        </th>
                                        <th class='col-md-2'>
                                            BATCH
                                        </th>
                                        <th class='col-md-1'>
                                            ACADEMIC YEAR
                                        </th>
                                        <th class='col-md-2'>
                                            SEMESTER
                                        </th>
                                        <th class='col-md-2'>
                                            SUBJECT
                                        </th>
                                        <th class='col-md-2'>
                                            ASSIGNMENT ACCEPTANCE STATUS
                                        </th>
                                        <th class = 'col-md-1'>
                                            ASSIGNMENT COMPLETION
                                        </th>
                                        <th class='col-md-1'>
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $statusCss = '';
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT fa.assignmentId,fa.semester,fa.academicYear,fa.subjectName,fa.batchName,fa.sessionPlanId,GROUP_CONCAT(lectureId) AS totalLecture,GROUP_CONCAT(assignmentStatus) AS lectureStatus,r.facultyId,r.assignmentId,r.facultyacceptance from f_assignment AS fa,remuneration AS r where fa.facultyId like '%" . $_SESSION['facultyId'] . "%' AND fa.facultyId = r.facultyId AND fa.assignmentId = r.assignmentId AND  1  group by fa.assignmentId order by fa.assignmentId desc;";
                                    $result = $conn->query($sql);
                                    // echo $result->num_rows;
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = $row["assignmentId"];
                                            $statusCss = '';
                                            $noOfCompletedLectures = 0;

                                            if ($row['facultyacceptance'] == 'PENDING') $statusCss = 'badge badge-danger';
                                            else if ($row['facultyacceptance'] == 'ACCEPTED') $statusCss = 'badge badge-success';

                                            $lectureArray = explode(",", $row['totalLecture']);
                                            $lectureStatusArray = explode(",", $row['lectureStatus']);

                                            $noOfLecture = count($lectureArray);
                                            for ($i = 0; $i < count($lectureStatusArray); $i++) {
                                                if ($lectureStatusArray[$i] == 'COMPLETED') $noOfCompletedLectures += 1;
                                                if ($lectureStatusArray[$i] == 'UNDELIVERED') $noOfCompletedLectures += 1;
                                            }
                                            $assignmentCompletionPercent = round(($noOfCompletedLectures / $noOfLecture) * 100, 0);
                                            if ($assignmentCompletionPercent >= 0 && $assignmentCompletionPercent <= 33) $percentCss = 'badge badge-danger';
                                            else if ($assignmentCompletionPercent > 33 && $assignmentCompletionPercent <= 66) $percentCss = 'badge badge-warning';
                                            else if ($assignmentCompletionPercent > 66 && $assignmentCompletionPercent <= 99) $percentCss = 'badge badge-primary';
                                            else if ($assignmentCompletionPercent = 100) $percentCss = 'badge badge-success';
                                            echo "
                                                <tr  class='tAC'>
                                                    <td>" . $id . "</td>
                                                    <td>" . str_replace('|', ',', $row['batchName']) . "</td>
                                                    <td>" . $row["academicYear"] . "</td>
                                                    <td>" . $row["semester"] . "</td> 
                                                    <td>" . $row["subjectName"] . "</td>
                                                    <td><span class = '" . $statusCss . "'>" . $row["facultyacceptance"] . "</span></td>
                                                    <td><span class = '" . $percentCss . "'>" . $assignmentCompletionPercent . ' %' . "</span></td>
                                                    <td class='project-actions'>
                                                        <a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id)' id = " . $id . " title='click hear to view Assignment Details'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                    </td>
                                                </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<!-- <script src="masterAssignment.js?v=<?php echo $fileVersion; ?>"></script> -->
<script src="manageAssignment.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var masterBatchDetails = <?php echo json_encode($masterBatchDetails) ?>;
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    var subjectNames = <?php echo json_encode($subjectNames); ?>;
    $(function() {
        $('.select2').select2();

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedBatch = getSelectValues('', document.getElementById("filterBatchCode")).trim();
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();
                selectedSubject = getSelectValues('', document.getElementById("filterSubject")).trim();

                var rowBatch = data[1].trim();
                var rowAcademicYear = data[2].trim();
                var rowSubject = data[4].trim();

                if (selectedBatch != '') {
                    inBatch = (selectedBatch.indexOf(rowBatch) !== -1) ? rowBatch : false;
                } else inBatch = true;

                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;

                if (selectedSubject != '') {
                    inSubject = (selectedSubject.indexOf(rowSubject) != -1) ? rowSubject : false;
                } else inSubject = true;
                return inBatch && inStudAcademicYear && inSubject;
            }
        );

        $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        loadDataDropdown("filterBatchCode", masterBatchDetails);
        loadDataDropdown("filterAyear", academicYearList);
        loadDataDropdown("filterSubject", subjectNames);
    });
</script>

<?php require '../../common/footer.php'; ?>