<?php
session_start();
if (isset($_SESSION['facultyLoginSuccessEdj'])) {
    if ($_SESSION['facultyLoginSuccessEdj'] > 0) {
    } else {
        header('Location: ../../facultyLogin.php');
        exit;
    }
} else {
    header('Location: ../../facultyLogin.php');
    exit;
}
$facultyId = $_SESSION['facultyId'];
$facultyDetails = [];


require '../../common/header.php';
require '../../common/navbar.php';
require_once '../../common/connectToDB.php';

$pendingInvoices = '';
$sql = "SELECT count( ac.accountsId) as pendingInvoices,ac.accountsId,ac.assignmentId,ac.approvedExecutionMinutes,a.semester,a.subjectName,a.facultyName,ac.unitNo,ac.totalAmount,ac.penaltyAmount,ac.invoice,re.assignmentId,re.perhrs,re.totalMins,ac.approvedExecutionMinutes,a.tableunitno,r.reviewStatus,(SELECT GROUP_CONCAT(a.totalMinutes) GROUP BY a.tableunitno)as totalMinutes,(SELECT GROUP_CONCAT(a.totalActualTime) GROUP BY a.tableunitno)as actualTime FROM f_accounts as ac ,f_assignment as a,review AS r,remuneration as re where a.assignmentId=ac.assignmentId AND ac.assignmentId = r.assignmentId AND a.assignmentId = re.assignmentId AND a.tableunitno = ac.unitNo AND ac.unitNo = r.unitNo AND r.reviewStatus = 'COMPLETED'AND ac.invoice='PENDING' AND a.facultyId='$facultyId' GROUP BY a.assignmentId,ac.unitno,re.assignmentId ORDER BY ac.accountsId DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row9 = $result->fetch_assoc()) {
        $pendingInvoices = $row9['pendingInvoices'];
    }
}

// payable
$pendingpaymentsArray = [];
$AmountArray = [];
$toatalAmount = '';
$sql7 = "SELECT ac.accountsId,ac.assignmentId,ac.pendingPayment,ac.totalAmount,a.semester,a.subjectName,a.facultyId,a.facultyName,a.batchName,ac.unitNo,ac.totalAmount,ac.penaltyAmount,ac.invoice,ac.approvedExecutionMinutes,a.tableunitno FROM f_accounts as ac ,f_assignment as a,f_assignmentexecution AS ae where a.assignmentId=ac.assignmentId AND a.assignmentId = ae.assignmentId AND a.tableunitno = ac.unitNo AND a.tableunitno = ae.tableUnitno AND ac.flag = 'PENDING' AND ac.invoice != 'PENDING' AND facultyId = '$facultyId' GROUP BY a.assignmentId,a.tableunitno ORDER BY ac.accountsId DESC";
$result7 = $conn->query($sql7);
if ($result7->num_rows > 0) {
    while ($row7 = $result7->fetch_assoc()) {
        $amountPaid = $row7['totalAmount'] - $row7['pendingPayment'];
        array_push($pendingpaymentsArray, $row7['assignmentId']);
        array_push($AmountArray, $row7['totalAmount']);
    }
}

// GST
$pendingGSTpaymentsArray = [];
$gstAmountArray = [];
$sql8 = "SELECT fgp.accountsId,fgp.assignmentId,fgp.unitNo,fgp.pendingTaxAmount,fgp.totalTaxAmount,fgp.flag,fa.semester,fa.subjectName,fa.facultyName,fa.facultyId FROM f_gst_payment fgp,f_assignment fa WHERE fa.assignmentId = fgp.assignmentId AND fa.tableunitno = fgp.unitNo AND fgp.flag = 'PENDING' AND fa.facultyId='$facultyId' GROUP BY fa.assignmentId, fa.tableunitno";
$result8 = $conn->query($sql8);
if ($result8->num_rows > 0) {
    while ($row8 = $result8->fetch_assoc()) {
        array_push($pendingGSTpaymentsArray, $row8['assignmentId']);
        array_push($gstAmountArray, $row8['pendingTaxAmount']);
    }
}

// today Missed
$studentArray = [];
$missedAgenda = [];
$TodayAgenda = [];
$pageLinkToRedirectMissed = '';
$statementMissed = '';
$statusMissed = '';
$currentDate = date("Y-m-d");
$sqlAEXe = "SELECT fa.assignmentId,fa.tableunitno,fa.planDate,fa.batchName,fa.semester,fa.subjectName,fa.facultyName,fa.tableTopicCovered,fa.rowId,fa.lectureId,r.assignmentId,r.facultyacceptance FROM f_assignment AS fa,remuneration AS r WHERE fa.assignmentStatus='PENDING' AND fa.facultyName NOT IN ('Not Selected') AND fa.facultyId = $facultyId AND fa.assignmentId = r.assignmentId AND fa.facultyId = r.facultyId AND r.facultyacceptance != 'PENDING' AND STR_TO_DATE(fa.planDate, '%d/%m/%Y')=curdate();";
$resultAEXe = $conn->query($sqlAEXe);
if ($resultAEXe->num_rows > 0) {
    while ($rowAEXe = $resultAEXe->fetch_assoc()) {
        $assignmentId = $rowAEXe['assignmentId'];
        $planDate = $rowAEXe['planDate'];
        $tableunitno = $rowAEXe['tableunitno'];
        $facultyName = $rowAEXe['facultyName'];


        $pageLinkToRedirect = '../assignmentExecution/pendingAssignmentExecution.php';
        $statement = "#" . $assignmentId . " - " . " Assignment Execution of " . $tableunitno . " is Pending";
        $status = '#dc3545';
        $array1 = array(
            "pageLinkToRedirect"    => $pageLinkToRedirect,
            "statement"  => $statement,
            "color"  => $status,


        );
        array_push($TodayAgenda, $array1);
    }
}
$sqlAEXe = "SELECT fa.assignmentId,fa.tableunitno,fa.planDate,fa.batchName,fa.semester,fa.subjectName,fa.facultyName,fa.tableTopicCovered,fa.rowId,fa.lectureId,r.assignmentId,r.facultyacceptance FROM f_assignment AS fa,remuneration AS r WHERE fa.assignmentStatus='PENDING' AND fa.facultyName NOT IN ('Not Selected') AND fa.facultyId = $facultyId AND fa.assignmentId = r.assignmentId AND fa.facultyId = r.facultyId AND r.facultyacceptance != 'PENDING' AND STR_TO_DATE(fa.planDate, '%d/%m/%Y')< curdate();";
$resultAEXe = $conn->query($sqlAEXe);
if ($resultAEXe->num_rows > 0) {
    while ($rowAEXe = $resultAEXe->fetch_assoc()) {
        $assignmentId = $rowAEXe['assignmentId'];
        $planDate = $rowAEXe['planDate'];
        $tableunitno = $rowAEXe['tableunitno'];
        $facultyName = $rowAEXe['facultyName'];
        $pageLinkToRedirectMissed = '../assignmentExecution/pendingAssignmentExecution.php';
        $statementMissed = "#" . $assignmentId . " -  Assignment Execution of " . $tableunitno . " is Pending";
        $statusMissed = '#ffa500';
        $array = array(
            "pageLinkToRedirectMissed"    => $pageLinkToRedirectMissed,
            "statementMissed"  => $statementMissed,
            "colorMissed"  => $statusMissed,

        );
        array_push($missedAgenda, $array);
    }
}
$today = count($TodayAgenda);
$missed = count($missedAgenda);
if ($missed == 0 && $today == 0) {
    $height = '0px';
} 

// this month this year life time
$sqlGraph = "SELECT * FROM(SELECT DISTINCT sum(p.amountPaid) as thisMonth FROM f_payment AS p,f_assignment AS fa WHERE p.assignmentId = fa.assignmentId AND p.unitNo = fa.tableunitno AND fa.facultyId = '$facultyId'AND month(STR_TO_DATE(paymentDate, '%d/%m/%Y'))=month(Now()) AND paymentType='PAYABLE'   ORDER BY p.paymentId DESC) as thismonthPayablePayments,
(SELECT DISTINCT sum(p.amountPaid) as thisYear FROM f_payment AS p,f_assignment AS fa WHERE p.assignmentId = fa.assignmentId AND p.unitNo = fa.tableunitno AND fa.facultyId = '$facultyId'AND year(STR_TO_DATE(paymentDate, '%d/%m/%Y'))=year(Now()) AND paymentType='PAYABLE' ORDER BY p.paymentId DESC) as thisYearPayments,
(SELECT DISTINCT sum(p.amountPaid) as  lifeTime FROM f_payment AS p,f_assignment AS fa WHERE p.assignmentId = fa.assignmentId AND p.unitNo = fa.tableunitno AND fa.facultyId = '$facultyId'AND STR_TO_DATE(paymentDate, '%d/%m/%Y')< curdate() AND paymentType='PAYABLE' ORDER BY p.paymentId DESC)  as lifeTimePayments,
(SELECT DISTINCT sum(p.amountPaid) as thisMonthGST FROM f_payment AS p,f_assignment AS fa WHERE p.assignmentId = fa.assignmentId AND p.unitNo = fa.tableunitno AND fa.facultyId = '$facultyId'AND month(STR_TO_DATE(paymentDate, '%d/%m/%Y'))=month(Now()) AND paymentType='GST'   ORDER BY p.paymentId DESC) as thismonthGSTPayments,
(SELECT DISTINCT sum(p.amountPaid) as thisYearGST FROM f_payment AS p,f_assignment AS fa WHERE p.assignmentId = fa.assignmentId AND p.unitNo = fa.tableunitno AND fa.facultyId = '$facultyId'AND year(STR_TO_DATE(paymentDate, '%d/%m/%Y'))=year(Now()) AND paymentType='GST' ORDER BY p.paymentId DESC) as thisYearGSTPayments,
(SELECT DISTINCT sum(p.amountPaid) as  lifeTimeGST FROM f_payment AS p,f_assignment AS fa WHERE p.assignmentId = fa.assignmentId AND p.unitNo = fa.tableunitno AND fa.facultyId = '$facultyId'AND STR_TO_DATE(paymentDate, '%d/%m/%Y') < curdate() AND paymentType='GST' ORDER BY p.paymentId DESC)  as lifeTimeGSTPayments;";
$resultGraph = $conn->query($sqlGraph);
if ($resultGraph->num_rows > 0) {
    while ($rowGraph = $resultGraph->fetch_assoc()) {
        $thisMonth = $rowGraph['thisMonth'];
        $thisYear = $rowGraph['thisYear'];
        $lifeTime = $rowGraph['lifeTime'];
        $thisMonthGST = $rowGraph['thisMonthGST'];
        $thisYearGST = $rowGraph['thisYearGST'];
        $lifeTimeGST = $rowGraph['lifeTimeGST'];
    }
}

?>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <!-- <h1 class="m-0 text-light fSB">DASHBOARD</h1> -->
                </div>
                <!-- profile completion status -->
                <div class="col-md-4" id='profileCompletionDiv' style='margin-left:209px;'>
                    <div class="card text-center">
                        <div class="card-header">
                            Profile Completing Status <br>
                            <div class="progress mt-2">
                                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" id="progressBar" aria-valuemax="100">25%
                                </div>
                            </div>
                        </div>
                        <?php
                        $sql2    = "SELECT * from faculty WHERE facultyId = '$facultyId'; ";
                        $result = $conn->query($sql2);
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                array_push($facultyDetails, $row);
                                $invoiceType = $row['invoiceType'];
                                $averageRating = $row['averageRating'];
                                $height='';
                                if ($invoiceType == 'GST') {
                                  
                                    $height='1490px';
                                }
                                else if ($invoiceType == 'NON-GST') {
                               
                                    $height = '1253px';
                                }
                            }
                        }
                        ?>

                    </div>
                </div>
                <!-- profile end -->
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class='row'>
                <div class='col-md-9'>
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header" style="background: #ffffff;color: black;">
                                    <p class="card-title fSB">Assignment Summary
                                    </p>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool mt-1" style='color:black' data-card-widget="collapse"><i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">

                                    <?php
                                    $unitArray = [];
                                    $MinutesArray = [];
                                    $sql = "SELECT ac.accountsId,ac.assignmentId,ac.approvedExecutionMinutes,a.semester,a.subjectName,a.facultyName,ac.unitNo,ac.totalAmount,ac.penaltyAmount,ac.invoice,re.assignmentId,re.perhrs,re.totalMins,ac.approvedExecutionMinutes,a.tableunitno,r.reviewStatus,(SELECT GROUP_CONCAT(a.totalMinutes) GROUP BY a.tableunitno)as totalMinutes,(SELECT GROUP_CONCAT(a.totalActualTime) GROUP BY a.tableunitno)as actualTime FROM f_accounts as ac ,f_assignment as a,review AS r,remuneration as re where a.assignmentId=ac.assignmentId AND ac.assignmentId = r.assignmentId AND a.assignmentId = re.assignmentId AND a.tableunitno = ac.unitNo AND ac.unitNo = r.unitNo AND r.reviewStatus = 'COMPLETED' AND a.facultyId='$facultyId' GROUP BY a.assignmentId,ac.unitno,re.assignmentId ORDER BY ac.accountsId DESC;";

                                    $result2 = $conn->query($sql);
                                    if ($result2->num_rows > 0) {
                                        while ($row2 = $result2->fetch_assoc()) {
                                            array_push($unitArray, $row2['tableunitno']);
                                            $totalNumberOfUnits = count($unitArray);
                                            $assignmentId = $row2['assignmentId'];
                                            $tableunitno = $row2['tableunitno'];
                                            $approvedExecutionMinutes = $row2['approvedExecutionMinutes'];
                                            array_push($MinutesArray, $approvedExecutionMinutes);
                                            array_sum($MinutesArray);
                                            $totalMins = array_sum($MinutesArray);
                                            $totalHrs = $totalMins / 60;
                                        }
                                    }
                                    ?>
                                    <div class="row mT15 mB20">

                                        <div class="col-6 col-md-4">
                                            <a href="../assignmentExecution/manageAllAssignmentExecution.php" target='_blank'>
                                                <div class="info-box" style="border-radius: 34px;">
                                                    <span class="info-box-icon elevation-1 bg-gradient-success" style="color: white;border-radius: 40px;height: 90px;width: 87px;"><img src='../../../dist/img/unitImage.png' style="height: 52px;width: 60px;margin-top: -2px;"></span>
                                                    <div class="info-box-content">
                                                        <span class="fSB">Total No. Of Units Completed</span>
                                                        <span class="info-box-number">
                                                            <?php echo sprintf("%02d", $totalNumberOfUnits) ?>

                                                        </span>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-md-4">
                                            <a href="../assignmentExecution/manageAllAssignmentExecution.php" target='_blank'>
                                                <div class="info-box" style="border-radius: 34px;">
                                                    <span class="info-box-icon elevation-1 bg-gradient-info" style="border-radius: 40px;height: 90px;width: 87px;background-color: #8CE68C;"><i class='far fa-clock' style="font-size: 44px;"></i></span>
                                                    <div class="info-box-content">
                                                        <span class="fSB">Total No.Of Hours Delivered</span>
                                                        <span class="info-box-number">
                                                            <?php echo sprintf("%02d", $totalHrs) ?>

                                                        </span>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-md-4">
                                            <a href="../review/manageAllAssignmentReview.php" target='_blank'>
                                                <div class="info-box" style="border-radius: 34px;">
                                                    <span class="info-box-icon elevation-1 bg-gradient-warning" style="border-radius: 40px;height: 90px;width: 87px;color: white;"><i class='far fa-star' style="font-size: 44px;"></i></span>
                                                    <div class="info-box-content">
                                                        <span class="fSB">Average Rating</span>
                                                        <span class="info-box-number">
                                                            <?php echo  $averageRating ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </a>

                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="info-box" style='height:158px'>
                                <span class="info-box-icon elevation-1 bg-gradient-danger"><i class="far fa-clipboard" style="width: 100px;color:white;font-size: 50px;"></i></span>

                                <div class="info-box-content">
                                    <a href="../assignment/manageAssignment.php" target="_blank">
                                        <span class="info-box-text fSB tAC">Ongoing Assignment<br>Progress</span>
                                        <span class="info-box-number tAC" id="assignment">
                                            <?php
                                            $sqlA    = "SELECT DISTINCT assignmentId,semester,tableunitno,subjectName,CAST(SUM(totalMinutes) AS DECIMAL (10 , 2 )) AS totalMinutes,CAST(SUM(IF(assignmentStatus IN ('COMPLETED','UNDELIVERED'),totalMinutes,0)) AS DECIMAL (10 , 2 )) AS complete FROM f_assignment WHERE facultyId  IN ('" . $facultyId . "')  GROUP BY assignmentId;";
                                            ?>

                                        </span>
                                    </a>
                                </div>

                                <div class="w100" style="margin-left: -16px;">
                                    <div class="card-body p0">
                                        <div class="direct-chat-messages  pTB0" style='height:139px'>
                                            <table class="table table-bordered">
                                                <thead>
                                                    <thead>
                                                        <tr>
                                                            <th class="tAC">#</th>
                                                            <th class="tAC">Assignment ID</th>
                                                            <th class="p510 tAC">Semester</th>
                                                            <th class="tAC">Subject</th>
                                                            <th class="tAC">Progress</th>
                                                            <th class="tAC">%</th>
                                                        </tr>
                                                    </thead>

                                                <tbody>
                                                    <?php
                                                    $assignmentRowId = 0;
                                                    $resultA = $conn->query($sqlA);
                                                    if ($resultA->num_rows > 0) {
                                                        $rowId = 1;
                                                        // output data of each row
                                                        $studentsMasterList = [];
                                                        while ($row = $resultA->fetch_assoc()) {
                                                            $percent = round(($row["complete"] / $row["totalMinutes"]) * 100, 2);
                                                            if ($percent < 5) {
                                                                $scoreVal = 10;
                                                                $barCss = 'progress-bar bg-danger progress-bar-striped';
                                                                $barLabel = 'badge bg-danger';
                                                                $barData = $percent;
                                                            } else {
                                                                $barData = $scoreVal = $percent;
                                                                $barCss = 'progress-bar bg-success progress-bar-striped';
                                                                $barLabel = 'badge bg-success';
                                                            }
                                                            if ($barData < 100) {
                                                                echo "
                                                            <tr  class='tAC'>
                                                                <td class='p510'>" . $rowId . "</td>  
                                                                <td class='p510'>" . $row["assignmentId"] . "</td>  
                                                                <td class='p510'>" . $row["semester"] . "</td>
                                                                <td class='p510'>" . $row["subjectName"] . "</td>  
                                                                <td>
                                                                    <div class='progress progress-xs'>
                                                                        <div class= '" . $barCss . "'
                                                                            role='progressbar' aria-valuenow='. $scoreVal . ' aria-valuemin='0'
                                                                            aria-valuemax='" . $row["totalMinutes"] . "' style='width: " . $scoreVal . "%'>
                                                                            <span class='sr-only'>" . $scoreVal . "% Complete</span>
                                                                        </div>
                                                                    </div>
                                                                </td> 
                                                                <td class='p510'> <span class='" . $barLabel . "'>$barData%</span> </td>
                                                            </tr>
                                                            ";
                                                                $rowId += 1;
                                                                $assignmentRowId += 1;
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="info-box" style='height:158px'>
                                <span class="info-box-icon elevation-1 bg-gradient-primary"><i class="fas fa-chalkboard-teacher" style="width: 100px;color:white;font-size: 40px;"></i></span>

                                <div class="info-box-content">
                                    <a href="../assignmentExecution/pendingAssignmentExecution.php" target="_blank">
                                        <span class="info-box-text fSB tAC">Pending Lectures</span>
                                        <span class="info-box-number tAC" id="pendingLectures">
                                            <?php
                                            $sqlE = "SELECT fa.assignmentId,fa.tableunitno,fa.planDate,fa.batchName,fa.semester,fa.subjectName,fa.facultyName,fa.tableTopicCovered,fa.rowId,fa.lectureId,r.assignmentId,r.facultyacceptance FROM f_assignment AS fa,remuneration AS r WHERE fa.assignmentStatus='PENDING' AND fa.facultyName NOT IN ('Not Selected') AND fa.facultyId = $facultyId AND fa.assignmentId = r.assignmentId AND fa.facultyId = r.facultyId AND r.facultyacceptance != 'PENDING'";
                                            $sqlE = $sqlE . " AND 1 ORDER BY fa.assignmentId desc;";
                                            ?>

                                        </span>
                                    </a>
                                </div>

                                <div class="w100" style="margin-left: -16px;">
                                    <div class="card-body p0">
                                        <div class="direct-chat-messages w100 pTB0" style='height:139px'>
                                            <table class="table table-bordered">
                                                <thead>
                                                    <thead>
                                                        <tr>
                                                            <th class="tAC">#</th>
                                                            <th class="tAC">Assignment ID</th>
                                                            <th class="tAC">Plan Date</th>
                                                            <th class="p510 tAC">Semester</th>
                                                            <th class="tAC">Subject</th>
                                                            <th class="tAC">Unit No</th>
                                                        </tr>
                                                    </thead>

                                                <tbody>
                                                    <?php
                                                    $assignmentRowId2 = 0;
                                                    $resultE = $conn->query($sqlE);
                                                    if ($resultE->num_rows > 0) {
                                                        $rowId2 = 1;
                                                        // output data of each row
                                                        $studentsMasterList = [];
                                                        while ($row = $resultE->fetch_assoc()) {

                                                            $id = $row["assignmentId"];
                                                            $rowID = $row['rowId'];
                                                            $lectureId = $row['lectureId'];
                                                            $flag = '"PENDING"';
                                                            $unitNo = '"' . $row["tableunitno"] . '"';

                                                            echo "
                                                                    <tr  class='tAC'>
                                                                    <td>" . $rowId2 . "</td>
                                                                        <td>" . $id . "</td>
                                                                        <td>" . $row["planDate"] . "</td>
                                                                        <td>" . $row["semester"] . "</td>
                                                                        <td>" . $row["subjectName"] . "</td>
                                                                        <td>" .  $row["tableunitno"] . "</td>
                                                                       
                                                                    </tr>
                                                                    ";
                                                            $rowId2 += 1;
                                                            $assignmentRowId2 += 1;
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="info-box" style='height:158px'>
                                <span class="info-box-icon elevation-1 bg-gradient-warning"><i class="far fa-star" style="width: 100px;color:white;font-size: 45px;"></i></span>

                                <div class="info-box-content">
                                    <a href="../review/manageAllAssignmentReview.php" target="_blank">
                                        <span class="info-box-text fSB">Pending Review</span>
                                        <span class="info-box-number tAC" id="review">
                                            <?php
                                            $sql    = "SELECT DISTINCT a.tableunitno,a.subjectName,a.batchName,re.reviewId,re.assignmentId,re.reviewStatus,re.reviewDate,re.noOfRatings,re.comments,a.semester,a.subjectName,a.facultyName,a.facultyId FROM f_assignment AS a,review AS re WHERE a.assignmentId = re.assignmentId AND a.tableunitno = re.unitNo AND a.facultyId = '" . $facultyId . "' AND re.reviewStatus IN ('PENDING','UNDER REVIEW') ";
                                            ?>
                                        </span>
                                    </a>
                                </div>

                                <div class="w100" style="margin-left: -16px;">
                                    <div class="card-body p0">
                                        <div class="direct-chat-messages  pTB0" style='height:139px'>
                                            <table class="table table-bordered">
                                                <thead>
                                                    <thead>
                                                        <tr>
                                                            <th class="tAC">#</th>
                                                            <th class="tAC">Assignment ID</th>
                                                            <th class="p510 tAC">Semester</th>
                                                            <th class="tAC">Subject</th>
                                                            <th class="tAC">Unit No.</th>
                                                            <th class="tAC">No. Of Red Flags</th>
                                                            <th class="tAC">Status</th>
                                                        </tr>
                                                    </thead>
                                                <tbody>
                                                    <?php
                                                    $reviewRowId = 0;
                                                    $result = $conn->query($sql);
                                                    $rowId1 = 1;
                                                    if ($result->num_rows > 0) {
                                                        while ($row = $result->fetch_assoc()) {
                                                            $noOfRating = '';

                                                            $reviewId = '"' . $row['reviewId'] . '"';
                                                            $tableUnitNo = $row['tableunitno'];
                                                            $tUnitNo = '"' . $row['tableunitno'] . '"';
                                                            $id = $row['assignmentId'];
                                                            $noOfRating = $row['noOfRatings'];
                                                            if ($noOfRating != '') $noOfRating = $noOfRating . '/10';

                                                            $sql2 = "SELECT GROUP_CONCAT(ae.penaltyFlag) AS penaltyFlagArray, COUNT(ae.lectureSplitId) AS noOfLectures, ac.approvedExecutionMinutes FROM f_assignmentexecution ae LEFT JOIN f_accounts ac ON ae.assignmentId = ac.assignmentId AND ae.tableunitno = ac.unitNo WHERE ae.assignmentId = '" . $id . "' AND ae.tableUnitNo = '" . $tableUnitNo . "' GROUP BY ae.assignmentId,ae.tableUnitNo;";
                                                            $result2 = $conn->query($sql2);

                                                            if ($result2->num_rows > 0) {
                                                                while ($row2 = $result2->fetch_assoc()) {
                                                                    $penaltyFlag = '';
                                                                    $noOfLectures = '';
                                                                    $noOfPenaltyFlags = 0;

                                                                    $penaltyFlag = $row2['penaltyFlagArray'];
                                                                    $noOfLectures = $row2['noOfLectures'];
                                                                    $approvedExecutionMinutes = $row2['approvedExecutionMinutes'];
                                                                }
                                                            }
                                                            $penaltyFlagArray = explode(',', $penaltyFlag);
                                                            for ($i = 0; $i < count($penaltyFlagArray); $i++) {
                                                                if ($penaltyFlagArray[$i] == 'true')
                                                                    $noOfPenaltyFlags += 1;
                                                            }
                                                            if ($noOfPenaltyFlags > 0) $flagStatusCss = "badge badge-danger";
                                                            else $flagStatusCss = "";

                                                            if ($row["reviewStatus"] == 'PENDING') $reviewStatusCss = 'badge badge-danger';
                                                            if ($row["reviewStatus"] == 'UNDER REVIEW') $reviewStatusCss = 'badge badge-warning';
                                                            if ($row["reviewStatus"] == 'COMPLETED') $reviewStatusCss = 'badge badge-success';
                                                            echo "
                                                        <tr  class='tAC'>
                                                            <td>" . $rowId1 . "</td>
                                                            <td>" . $row["assignmentId"] . "</td>
                                                            <td>" . $row["semester"] . "</td>
                                                            <td>" . $row["subjectName"] . "</td>
                                                            <td>" . $row["tableunitno"] . "</td>
                                                            <td><span class = '" . $flagStatusCss . "'>" . $noOfPenaltyFlags . '/' . $noOfLectures . "</td>
                                                            <td><span class = '" . $reviewStatusCss . "'>" . $row["reviewStatus"] . "</span></td>";

                                                            echo "</tr>";
                                                            $rowId1 += 1;
                                                            $reviewRowId += 1;
                                                        }
                                                    }
                                                    ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="info-box" style='height:158px'>
                                <span class="info-box-icon elevation-1 bg-gradient-info"><i class="fas fa-file-invoice" style="width: 100px;font-size: 50px;color:white;"></i></span>

                                <div class="info-box-content">
                                    <a href="../payment/addInvoice.php" target="_blank">
                                        <span class="info-box-text fSB">Pending Invoices</span>
                                        <span class="info-box-number tAC" id="Invoices">
                                            <?php
                                            $sqlP = "SELECT count( ac.accountsId) as pendingInvoices,ac.accountsId,ac.assignmentId,ac.approvedExecutionMinutes,a.semester,a.subjectName,a.facultyName,ac.unitNo,ac.totalAmount,ac.penaltyAmount,ac.invoice,re.assignmentId,re.perhrs,re.totalMins,ac.approvedExecutionMinutes,a.tableunitno,r.reviewStatus,(SELECT GROUP_CONCAT(a.totalMinutes) GROUP BY a.tableunitno)as totalMinutes,(SELECT GROUP_CONCAT(a.totalActualTime) GROUP BY a.tableunitno)as actualTime FROM f_accounts as ac ,f_assignment as a,review AS r,remuneration as re where a.assignmentId=ac.assignmentId AND ac.assignmentId = r.assignmentId AND a.assignmentId = re.assignmentId AND a.tableunitno = ac.unitNo AND ac.unitNo = r.unitNo AND r.reviewStatus = 'COMPLETED'AND ac.invoice='PENDING' AND a.facultyId='$facultyId' GROUP BY a.assignmentId,ac.unitno,re.assignmentId ORDER BY ac.accountsId DESC;";
                                            ?>
                                        </span>
                                    </a>
                                </div>

                                <div class="w100" style="margin-left: -16px;">
                                    <div class="card-body p0">
                                        <div class="direct-chat-messages  pTB0" style='height:139px'>
                                            <table class="table table-bordered">
                                                <thead>
                                                    <thead>
                                                        <tr>
                                                            <th class="tAC">#</th>
                                                            <th class="tAC">Assignment ID</th>
                                                            <th class="tAC">Unit No.</th>
                                                            <th class="p510 tAC">Semester</th>
                                                            <th class="tAC">Subject</th>
                                                            <th class="tAC">Approve Execution Time</th>
                                                            <th class="tAC">Amount</th>
                                                        </tr>
                                                    </thead>
                                                <tbody>
                                                    <?php
                                                    $invoiceRowId = 0;
                                                    $resultp = $conn->query($sqlP);
                                                    $rowIdP = 1;
                                                    if ($resultp->num_rows > 0) {
                                                        while ($row = $resultp->fetch_assoc()) {
                                                            $noOfRating = '';
                                                            $tempPendingAmount = $row['totalAmount'];
                                                            $tempPenaltyAmount = $row['penaltyAmount'];
                                                            $approvedTime = $row['approvedExecutionMinutes'];
                                                            $invoice = $row['invoice'];
                                                            $amountperHr1 = $approvedTime / 60;
                                                            $amountperHr = (int)$tempPendingAmount / (int)$amountperHr1;
                                                            $finalAmount = (int)$tempPendingAmount - (int)$tempPenaltyAmount;
                                                            if ($row['invoice'] != 'PENDING') {
                                                                $invoiceFile = $invoice;
                                                                $invoice = "CREATED";
                                                                $invoiceCss = "badge badge-success fS13";
                                                            } else $invoiceCss = "badge badge-danger fS13";
                                                            echo "
                                                <tr  class='tAC'>
                                                    <td>" . $rowIdP . "</td>
                                                    <td>" . $assignmentId . "</td>
                                                    <td>" . $row["unitNo"] . "</td>
                                                    <td>" . $row["semester"] . "</td>
                                                    <td>" . $row["subjectName"] . "</td>
                                                    <td>" . $row['approvedExecutionMinutes'] . "</td>
                                                    <td>" . $finalAmount . "</td>";
                                                            $rowIdP += 1;
                                                            $invoiceRowId += 1;
                                                        }
                                                    }
                                                    ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="row" id="payablePayments">
                        <div class="col-12">
                            <div class="info-box" style="height: 210px;">
                                <div style="margin-left: 22px;">
                                    <a href="../payment/pendingPayment.php">
                                        <input class="knob" data-thickness="0.2" data-angleArc="250" data-angleOffset="-125" value="<?php echo count($pendingpaymentsArray) ?>" data-width="120" data-height="120" data-fgColor="purple" data-readonly="true" disabled>
                                        <div class="knob-label fSB" style="margin-left: -6px;margin-top: -10px;">Pending Payment</div>
                                        <div class=' description-block' style="margin-left: -12px;background-color: rgba(0, 0, 0, .03);">
                                            <div class=''><?php echo number_format(array_sum($AmountArray)) ?></div>
                                            <div class='footer tAC fSB'>TOTAL AMOUNT</div>
                                        </div>


                                    </a>
                                </div>
                                <div class="info-box-content">
                                </div>

                                <div class="w100" style="margin-left: -16px;">
                                    <div class="card-body p0">
                                        <div class="direct-chat-messages  pTB0" style="height:190px;">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <thead>
                                                        <tr>
                                                            <th class="tAC">#</th>
                                                            <th class="tAC">Assignment ID</th>
                                                            <th class="tAC">Unit No.</th>
                                                            <th class="p510 tAC">Semester</th>
                                                            <th class="tAC">Subject</th>
                                                            <th class="tAC">Total Amount</th>
                                                            <th class="tAC">Balance Amount</th>
                                                        </tr>
                                                    </thead>
                                                <tbody>
                                                    <?php
                                                    $sqlPayments = "SELECT ac.accountsId,ac.assignmentId,ac.pendingPayment,ac.totalAmount,a.semester,a.subjectName,a.facultyId,a.facultyName,a.batchName,ac.unitNo,ac.totalAmount,ac.penaltyAmount,ac.invoice,ac.approvedExecutionMinutes,a.tableunitno FROM f_accounts as ac ,f_assignment as a,f_assignmentexecution AS ae where a.assignmentId=ac.assignmentId AND a.assignmentId = ae.assignmentId AND a.tableunitno = ac.unitNo AND a.tableunitno = ae.tableUnitno AND ac.flag = 'PENDING' AND ac.invoice != 'PENDING' AND facultyId = '" . $facultyId . "' GROUP BY a.assignmentId,a.tableunitno ORDER BY ac.accountsId DESC;";
                                                    $PaymentsRowId = 0;
                                                    $resultPayments = $conn->query($sqlPayments);
                                                    $rowIdPayments = 1;
                                                    if ($resultPayments->num_rows > 0) {
                                                        while ($row = $resultPayments->fetch_assoc()) {
                                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $rowIdPayments . "</td>
                                                <td>" . $row['assignmentId'] . "</td>
                                                <td>" . $row["unitNo"] . "</td>
                                                <td>" . $row["subjectName"] . "</td>
                                                <td>" . $row["semester"] . "</td>
                                                <td>" . $row['totalAmount'] . "</td>
                                                <td>" . intVal($row["pendingPayment"]) . "</td>
                                            </tr>";
                                                            $rowIdPayments += 1;
                                                            $PaymentsRowId += 1;
                                                        }
                                                    }
                                                    ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="row" id="gstPayments">
                        <div class="col-12">
                            <div class="info-box" style='height:220px'>
                                <div style="margin-left: 22px;">
                                    <a href="../payment/pendingGSTpayment.php">
                                        <input class="knob" data-thickness="0.2" data-angleArc="250" data-angleOffset="-125" value="<?php echo count($pendingGSTpaymentsArray) ?>" data-width="120" data-height="120" data-fgColor="red" data-readonly="true" disabled>
                                        <div class="knob-label fSB" style="margin-left: 15px;margin-top: -10px;">GST Payment</div>
                                        <div class='description-block' style="margin-left: -12px;background-color: rgba(0, 0, 0, .03);">
                                            <div class=''><?php echo number_format(array_sum($gstAmountArray)) ?></div>
                                            <div class='footer tAC fSB'>TOTAL AMOUNT</div>
                                        </div>
                                    </a>

                                </div>
                                <div class="info-box-content">

                                </div>

                                <div class="w100" style="margin-left: -16px;">
                                    <div class="card-body p0">
                                        <div class="direct-chat-messages  pTB0" style="height:190px;">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <thead>
                                                        <tr>
                                                            <th class="tAC">#</th>
                                                            <th class="tAC">Assignment ID</th>
                                                            <th class="tAC">Unit No.</th>
                                                            <th class="p510 tAC">Semester</th>
                                                            <th class="tAC">Subject</th>
                                                            <th class="tAC">Total Amount</th>
                                                            <th class="tAC">Balance Amount</th>
                                                        </tr>
                                                    </thead>
                                                <tbody>
                                                    <?php
                                                    $sql8 = "SELECT fgp.accountsId,fgp.assignmentId,fgp.unitNo,fgp.pendingTaxAmount,fgp.totalTaxAmount,fgp.flag,fa.semester,fa.subjectName,fa.facultyName,fa.facultyId FROM f_gst_payment fgp,f_assignment fa WHERE fa.assignmentId = fgp.assignmentId AND fa.tableunitno = fgp.unitNo AND fgp.flag = 'PENDING' AND fa.facultyId='$facultyId' GROUP BY fa.assignmentId, fa.tableunitno";
                                                    $result8 = $conn->query($sql8);
                                                    if ($result8->num_rows > 0) {
                                                        while ($row8 = $result8->fetch_assoc()) {
                                                            $rowIdGST = 1;

                                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $rowIdGST . "</td>
                                                <td>" . $row8['assignmentId'] . "</td>
                                                <td>" . $row8["unitNo"] . "</td>
                                                <td>" . $row8["subjectName"] . "</td>
                                                <td>" . $row8["semester"] . "</td>
                                                <td>" . $row8['totalTaxAmount'] . "</td>
                                                <td>" . intVal($row8["pendingTaxAmount"]) . "</td>
                                            </tr>";
                                                            $rowIdGST += 1;
                                                        }
                                                    }
                                                    ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-7">
                            <div class="card">
                                <div class="card-header border-0">
                                    <div class="d-flex justify-content-between">
                                        <h3 class="card-title">Payment History</h3>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="chart" id='bardata'>
                                        <canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                    </div>
                                    <div class="chart" id='stackbar'>
                                        <canvas id="stackedBarChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>

                <div class='col-md-3'>
                    <div class='row'>
                        <div class="col-md-12">
                            <div class="card card-info">
                                <div class="card-header" style="background: #ffffff;color: black;">
                                    <p class="card-title fSB">Today's Agenda
                                    </p>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool mt-1" style='color:black' data-card-widget="collapse"><i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class='row'>
                                        <div class="col-md-6">
                                            <div class="small-box ">
                                                <div class="inner" style="background-color:orange">
                                                    <h3 class='tAC'><?php echo $missed ?></h3>
                                                    <p class='tAC'>MISSED</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="small-box bg-danger">
                                                <div class="inner">
                                                    <h3 class='tAC'><?php echo $today ?></h3>
                                                    <p class='tAC'>TODAY</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class='row'>
                                        <div class="col-md-12">
                                            <div class="card-body">
                                                <div class="direct-chat-messages" style="width: 134%;margin-left: -38px;margin-top: 5px;height:<?php echo $height ?>;">
                                                    <table class="table table-striped">
                                                        <tbody>
                                                            <?php
                                                            for ($i = 0; $i < count($TodayAgenda); $i++) {
                                                                $color = '';

                                                                echo "<tr>
                                                                    <td style='border-left: 5px solid " . $TodayAgenda[$i]['color'] . ";border-top: 8px solid #fff;' ><a href=" . $TodayAgenda[$i]['pageLinkToRedirect'] . " target='_blank'>" . $TodayAgenda[$i]['statement'] . "</a></td>
                                                                    </tr>";
                                                            }
                                                            for ($i = 0; $i < count($missedAgenda); $i++) {
                                                                $color = '';

                                                                echo "<tr>
                                                                    <td style='border-left: 5px solid " . $missedAgenda[$i]['colorMissed'] . ";border-top: 8px solid #fff;' ><a href=" . $missedAgenda[$i]['pageLinkToRedirectMissed'] . " target='_blank'>" . $missedAgenda[$i]['statementMissed'] . "</a></td>
                                                                    </tr>";
                                                            }

                                                            ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/jquery-knob/jquery.knob.min.js"> </script>
<script src="../../../plugins/chart.js/Chart.min.js"> </script>

<script src="index.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var facultyDetails = '';
    facultyDetails = <?php echo json_encode($facultyDetails) ?>;
    document.getElementById("assignment").innerHTML = <?php echo json_encode($assignmentRowId); ?>;
    document.getElementById("pendingLectures").innerHTML = <?php echo json_encode($assignmentRowId2); ?>;
    document.getElementById("review").innerHTML = <?php echo json_encode($reviewRowId); ?>;
    document.getElementById("Invoices").innerHTML = <?php echo json_encode($invoiceRowId); ?>;

    invoiceType = '<?php echo $invoiceType ?>';
    thisMonth = '<?php echo $thisMonth ?>';
    thisYear = '<?php echo $thisYear ?>';
    lifeTime = '<?php echo $lifeTime ?>';

    thisMonthGST = '<?php echo $thisMonthGST ?>';
    thisYearGST = '<?php echo $thisYearGST ?>';
    lifeTimeGST = '<?php echo $lifeTimeGST ?>';
    getStatus();

    if (invoiceType == 'GST') {
        document.getElementById('gstPayments').hidden = false;
    } else if (invoiceType == 'NON-GST') {
        document.getElementById('gstPayments').hidden = true;
    }
    if (invoiceType == 'GST') {
        document.getElementById('stackbar').hidden = 'true';
        var areaChartData = {
            labels: ['This Month', 'This Year', 'Life Time'],
            datasets: [{
                    label: 'Payable Payments',
                    backgroundColor: 'rgba(60,141,188,0.9)',
                    borderColor: 'rgba(60,141,188,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(60,141,188,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(60,141,188,1)',
                    data: [thisMonth, thisYear, lifeTime]
                },
                {
                    label: 'GST Payments',
                    backgroundColor: 'rgba(210, 214, 222, 1)',
                    borderColor: 'rgba(210, 214, 222, 1)',
                    pointRadius: false,
                    pointColor: 'rgba(210, 214, 222, 1)',
                    pointStrokeColor: '#c1c7d1',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(220,220,220,1)',
                    data: [thisMonthGST, thisYearGST, lifeTimeGST]
                },
            ]
        }

        //- BAR CHART -
        //-------------
        var barChartCanvas = $('#barChart').get(0).getContext('2d')
        var barChartData = jQuery.extend(true, {}, areaChartData)
        var temp0 = areaChartData.datasets[0]
        var temp1 = areaChartData.datasets[1]
        barChartData.datasets[0] = temp1
        barChartData.datasets[1] = temp0

        var barChartOptions = {
            responsive: true,
            maintainAspectRatio: false,
            datasetFill: false
        }

        var barChart = new Chart(barChartCanvas, {
            type: 'bar',
            data: barChartData,
            options: barChartOptions
        })
    }
    if (invoiceType == 'NON-GST') {
        document.getElementById('bardata').hidden = 'true';


        var areaChartData = {
            labels: ['This Month', 'This Year', 'Life Time'],
            datasets: [{
                    label: 'Payable Payments',
                    backgroundColor: 'rgba(60,141,188,0.9)',
                    borderColor: 'rgba(60,141,188,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(60,141,188,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(60,141,188,1)',
                    data: [thisMonth, thisYear, lifeTime]
                }

            ]
        }
        var stackedBarChartCanvas = $('#stackedBarChart').get(0).getContext('2d')
        var stackedBarChartData = jQuery.extend(true, {}, areaChartData)

        var stackedBarChartOptions = {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    stacked: true,
                }],
                yAxes: [{
                    stacked: true
                }]
            }
        }

        var stackedBarChart = new Chart(stackedBarChartCanvas, {
            type: 'bar',
            data: stackedBarChartData,
            options: stackedBarChartOptions
        })
    }

</script>
<?php require  '../../common/footer.php'; ?>