var userType = '',
    userFirstName = '',
    userLastName = '',
    userLoginId = '',
    userPassword = '',
    primaryNumber = '',
    ctc = '',
    flagForDuplicateEmail = false;

function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function checkForDuplicateEmail(userEmail) {
    flagForDuplicateEmail = false;
    for (i = 0; i < masterUserList.length; i++) {
        if (userEmail.trim().toLowerCase() == masterUserList[i].username.trim().toLowerCase()) {
            flagForDuplicateEmail = true;
            showError('loginID', '#ff6666', "Duplicate Email ID found. Please change it.");
            document.getElementById('saveButton').disabled = false;
        }
        else showError('', '', '');
    }
}

function setHeaders() {
    userType = '';
    userFirstName = '';
    userLastName = '';
    userLoginId = '';
    userPassword = '';
    primaryNumber = '';
    ctc = '';

    userType = document.getElementById('userTypeDropdown').value.trim().toUpperCase();
    userFirstName = document.getElementById('firstName').value.trim().toUpperCase();
    userLastName = document.getElementById('lastName').value.trim().toUpperCase();
    primaryNumber = document.getElementById('phoneNumber').value.trim();
    ctc = document.getElementById('ctc').value.trim();
    userLoginId = document.getElementById('loginID').value.trim();
    userPassword = document.getElementById('password').value.trim();
}

function formValidation() {
    if (userType == 'SELECT USER TYPE') {
        showError('userTypeDropdown', '#ff6666', "Select Access Privileges.");
        return 0;
    } else showError('userTypeDropdown', '', '');
    if (userFirstName == '') {
        showError('firstName', '#ff6666', "First Name cannot be Blank.");
        return 0;
    } else showError('firstName', '', '');

    if (userLastName == '') {
        showError('lastName', '#ff6666', "Last Name cannot be Blank.");
        return 0;
    } else showError('lastName', '', '');
    if (primaryNumber == "") {
        showError('phoneNumber', '#ff6666', "Primary number can not be blank.");
        return 0;
    } else showError('phoneNumber', '', '');
    if (primaryNumber.length != 10) {
        showError('phoneNumber', '#ff6666', "Phone number should be of 10 digit only.");
        return 0;
    } else showError('phoneNumber', '', '');
    if (ctc == '') {
        showError('ctc', '#ff6666', "Enter CTC.");
        return 0;
    } else showError('ctc', '', '');
    if (ctc < 0) {
        showError('ctc', '#ff6666', "CTC can not be negative.");
        return 0;
    } else showError('ctc', '', '');
    if (userLoginId == '') {
        showError('loginID', '#ff6666', "Login ID cannot be Blank.");
        return 0;
    } else showError('loginID', '', '');
    if (!validateEmail(userLoginId)) {
        showError('loginID', '#ff6666', "Login ID is not in correct format. Please correct it.");
        return 0;
    } else showError('loginID', '', '');
    if (userPassword == '') {
        showError('password', '#ff6666', "Password cannot be Blank.");
        return 0;
    } else showError('password', '', '');
    checkForDuplicateEmail(userLoginId);
    if (flagForDuplicateEmail) {
        showError('loginID', '#ff6666', "Duplicate Login Id found. Please change it.");
        return 0;
    } else showError('loginID', '', '');

    return 1;
}

function saveUser() {
    var saveFlag = 'addUser';
    document.getElementById('saveButton').disabled = true;
    if (setHeaders() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (formValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (checkOnline() == false) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    else {
        if (true) {
            if ("Are you sure you want to save user?") {
                document.getElementById('saveButton').disabled = true;
                document.getElementById('successMessage').innerHTML = 'Adding User.. Please Wait....';
                $.post('saveUser.php', {
                    'userFirstName': userFirstName,
                    'userLastName': userLastName,
                    'primaryNumber': primaryNumber,
                    'ctc': ctc,
                    'userLoginId': userLoginId,
                    'userPassword': userPassword,
                    'userType': userType,
                    'saveFlag': saveFlag
                }, function (data) {
                    document.getElementById('successMessage').innerHTML = 'Saved successfully. Please wait. Page will get auto-refresh.';
                    location.reload();
                });
            }
            else document.getElementById('saveButton').disabled = false;
        }
    }
}

function showDetails(userId, userType) {
    if (userType == 'COUNSELOR') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewCouncelorProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'ACADEMIC EXECUTIVE') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewAcademicProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'ACCOUNTS EXECUTIVE') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewAccountantsProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'BUSINESS DEVELOPMENT EXECUTIVE') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewBDEprofile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'Center Manager') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "../UT/companyMaster.php";
    }
}

function userEdit(userId) {
    encodedKey_userId = btoa('userId');
    encodedValue_userId = btoa(userId);
    window.location.href = 'editUserDetails.php?' + encodedKey_userId + "=" + encodedValue_userId;
}