<span id="paeDetails">
    <div class="card-body">
        <table class="table table-striped projects tAC" id="example1">
            <thead>
                <tr>
                    <th>
                        BATCH
                    </th>
                    <th>
                        FACULTY NAME
                    </th>
                    <th>
                        SUBJECT
                    </th>
                    <th>
                        ASSIGNMENT ID
                    </th>
                    <th>
                        UNIT NO
                    </th>
                    <th>
                        RATINGS
                    </th>
                    <th>
                        TOTAL RED FLAGS
                    </th>
                    <th>
                        APPROVED EXECUTION MINUTES
                    </th>
                    <th>
                        REVIEW STATUS
                    </th>
                    <th>
                        ACTIONS
                    </th>
                </tr>
            </thead>
            <tbody id="tableBody">
                <?php
                $filteredSubject = '';
                $batchNameFilter = '';
                $facultyNameFilter = '';
                $assignmentIdFilter = '';
                $penaltyFlagCount = 0;
                if (isset($_POST['flag'])) {
                    $filteredSubject = $_POST['filteredSubject'];
                    $batchNameFilter = $_POST['batchNameFilter'];
                    $facultyNameFilter = $_POST['facultyNameFilter'];
                    $assignmentIdFilter = $_POST['filteredAssignmentId'];
                    require_once '../../common/connectToDB.php';

                    $sql = "SELECT a.tableunitno,re.reviewId,re.noOfRatings,re.assignmentId,re.reviewStatus,a.batchName,a.semester,a.subjectName,a.facultyName,a.facultyId,ac.invoice,ac.approvedExecutionMinutes FROM f_assignment AS a,review AS re,f_assignmentexecution AS ae,f_accounts AS ac WHERE a.assignmentId = re.assignmentId AND ae.assignmentId = re.assignmentId AND ac.assignmentId = re.assignmentId AND ac.assignmentId = a.assignmentId AND a.tableunitno = ae.tableunitno AND a.tableunitno = re.unitNo AND a.tableunitno = ac.unitNo AND ae.tableunitno = re.unitNo AND ae.tableunitno = ac.unitNo AND re.reviewStatus != 'PENDING' ";

                    if (count($filteredSubject) > 0 && strlen($filteredSubject[0]) != 0) {
                        $sql = $sql . " AND a.subjectName IN (";
                        for ($i = 0; $i < count($filteredSubject); $i++) {
                            $sql = $sql . "'" . $filteredSubject[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ')';
                    }
                    if (count($batchNameFilter) > 0 && strlen($batchNameFilter[0]) != 0) {
                        $sql = $sql . " AND a.batchName IN (";
                        for ($i = 0; $i < count($batchNameFilter); $i++) {
                            $sql = $sql . "'" . $batchNameFilter[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ')';
                    }
                    if (count($facultyNameFilter) > 0 && strlen($facultyNameFilter[0]) != 0) {
                        $sql = $sql . " AND a.facultyName IN (";
                        for ($i = 0; $i < count($facultyNameFilter); $i++) {
                            $sql = $sql . "'" . $facultyNameFilter[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ')';
                    }
                    if (count($assignmentIdFilter) > 0 && strlen($assignmentIdFilter[0]) != 0) {
                        $sql = $sql . " AND a.assignmentId IN (";
                        for ($i = 0; $i < count($assignmentIdFilter); $i++) {
                            $sql = $sql . "'" . $assignmentIdFilter[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ')';
                    }
                    $sql = $sql . " AND 1 GROUP BY ae.assignmentId,ae.tableunitno order by a.assignmentId desc;";

                    $result = $conn->query($sql);
                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            $id = $row["assignmentId"];
                            $reviewId = '"' . $row['reviewId'] . '"';
                            $facultyName = '"' . $row['facultyName'] . '"';
                            $tableUnitNo = $row["tableunitno"];
                            $tUnitNo = '"' . $row['tableunitno'] . '"';
                            $flagStatusCss = '';
                            $statusCss = '';
                            $editButtonCss = '';

                            if ($row['invoice'] != 'PENDING') $editButtonCss = 'disabled';
                            else $editButtonCss = '';

                            if ($row['reviewStatus'] == 'UNDER REVIEW') $statusCss = 'badge badge-warning';
                            if ($row['reviewStatus'] == 'COMPLETED') $statusCss = 'badge badge-success';

                            $sql2 = "SELECT GROUP_CONCAT(penaltyFlag) AS penaltyFlagArray, COUNT(lectureSplitId) AS noOfLectures FROM f_assignmentexecution WHERE assignmentId = '" . $id . "' AND tableUnitNo = '" . $tableUnitNo . "' GROUP BY assignmentId,tableUnitNo;";
                            $result2 = $conn->query($sql2);
                            if ($result2->num_rows > 0) {
                                while ($row2 = $result2->fetch_assoc()) {
                                    $penaltyFlag = '';
                                    $noOfLectures = '';
                                    $noOfPenaltyFlags = 0;

                                    $penaltyFlag = $row2['penaltyFlagArray'];
                                    $noOfLectures = $row2['noOfLectures'];
                                }
                            }
                            $penaltyFlagArray = explode(',', $penaltyFlag);
                            for ($i = 0; $i < count($penaltyFlagArray); $i++) {
                                if ($penaltyFlagArray[$i] == 'true')
                                    $noOfPenaltyFlags += 1;
                            }
                            if ($noOfPenaltyFlags > 0) $flagStatusCss = "badge badge-danger";
                            else $flagStatusCss = "";

                            echo "
                                <tr  class='tAC'>
                                    <td>" . str_replace('|', ',', $row['batchName']) . "</td>
                                    <td>" . $row["facultyName"] . "</td>
                                    <td>" . $row["subjectName"] . "</td>
                                    <td>" . $id . "</td>
                                    <td>" . $row["tableunitno"] . "</td>
                                    <td>" . $row['noOfRatings'] . "</td>
                                    <td><span class='" . $flagStatusCss . "'>" . $noOfPenaltyFlags . '/' . $noOfLectures . "</span></td>
                                    <td>" . $row['approvedExecutionMinutes'] . "</td>
                                    <td><span class = '" . $statusCss . "'>" . $row["reviewStatus"] . "</span></td>
                                    <td class='project-actions'>
                                        <a class='btn btn-primary btn-sm' href='#' id = " . $id . " onclick='viewAssignmentReview(this.id,$reviewId,$tUnitNo,$noOfLectures,$noOfPenaltyFlags)' title='Click hear to view Assignment review'>
                                            <i class='fas fa-eye'></i>
                                            </i>
                                        </a>
                                        <a class='btn btn-secondary btn-sm $editButtonCss' href='#' id = " . $id . " onclick='editAssignmentReview(this.id,$reviewId,$tUnitNo,$noOfLectures,$noOfPenaltyFlags)' title='Click hear to edit Assignment review'>
                                            <i class='fas fa-user-edit'></i>
                                            </i>
                                        </a>
                                    </td>
                                    </tr>
                                ";
                        }
                    }
                }
                ?>
            </tbody>
        </table>
    </div>
</span>
<script>
    $(document).ready(function() {
        var table = $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 30,
            "aaSorting": [],
        });
    });
</script>