<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';

$masterBatchDetails = [];
$sql = "SELECT * FROM batchmaster;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterBatchDetails, $row);
    }
}

$masterSubjectName = [];
$sql2 = "SELECT * FROM subjects ORDER BY subjectName;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSubjectName, $row2);
    }
}

$masterAssignmentData = [];
$sql3 = "SELECT DISTINCT assignmentId,semester,subjectName FROM f_assignment WHERE facultyName NOT IN ('Not Selected')  ORDER BY assignmentId DESC;";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($masterAssignmentData, $row3);
    }
}

$masterFacultyName = [];
$sql4 = "SELECT facultyId,firstName,middleName,lastName,facultySubject FROM faculty where formStatus = 'APPROVED' order by facultyId desc;";
$result4 = $conn->query($sql4);
if ($result4->num_rows > 0) {
    while ($row4 = $result4->fetch_assoc()) {
        array_push($masterFacultyName, $row4);
    }
}
require '../../common/navbar.php';
?>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/moment/moment.min.js"></script>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Assignment Review List</h3>
                            <br><br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Batch</label>
                                        <select class="select2" multiple="multiple" id="filterBatchCode" style="width: 100%;" onchange="filterOtherDropDown('batch');" data-placeholder="SELECT BATCH">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Subject Name</label>
                                        <select class="Select2" multiple="multiple" id="subjectName" style="width: 100%;" onchange="filterOtherDropDown('subject');" data-placeholder="SELECT SUBJECT">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Faculty Name</label>
                                        <select class="Select2" multiple="multiple" id="facultyNameDropdown" style="width: 100%;" onchange="filterOtherDropDown('faculty');" data-placeholder="FACULTY NAME">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Assignment Id</label>
                                        <select class="Select2" multiple="multiple" id="assignmentIdDrpodown" style="width: 100%;" onchange="filterOtherDropDown('assignment');" data-placeholder="ASSIGNMENT ID">
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <span id="savedData"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 tAC">
                                    <div class="form-group">
                                        <input type="button" class="btn btn-primary mT27" value="Get List" id="generateDetails" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php require 'manageAllAssignmentReviewDetails.php' ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageAllAssignmentReview.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var masterSubjectName = <?php echo json_encode($masterSubjectName); ?>;
    var masterAssignmentData = <?php echo json_encode($masterAssignmentData); ?>;
    var masterFacultyName = <?php echo json_encode($masterFacultyName); ?>;
    var masterBatchDetails = <?php echo json_encode($masterBatchDetails) ?>;

    $(function() {
        $('.select2').select2();

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedSubjectName = getSelectValues('', document.getElementById("subjectName")).trim();
                selectedAssignmentID = getSelectValues('', document.getElementById("assignmentIdDrpodown")).trim();
                selectedFacultyName = getSelectValues('', document.getElementById("facultyNameDropdown")).trim();
                selectedBatch = getSelectValues('', document.getElementById("filterBatchCode")).trim();

                var rowSubjectName = data[2];
                var rowAssignmentID = data[3];
                var rowFacultyName = data[1];
                var rowBatch = data[0];

                if (selectedSubjectName != '') {
                    inSubjectName = (selectedSubjectName.indexOf(rowSubjectName) !== -1) ? rowSubjectName : false;
                } else inSubjectName = true;

                if (selectedFacultyName != '') {
                    inFacultyName = (selectedFacultyName.indexOf(rowFacultyName) !== -1) ? rowFacultyName : false;
                } else inFacultyName = true;

                if (selectedAssignmentID != '') {
                    inAssignmentId = (selectedAssignmentID.indexOf(rowAssignmentID) !== -1) ? rowAssignmentID : false;
                } else inAssignmentId = true;

                if (selectedBatch != '') {
                    inBatch = (selectedBatch.indexOf(rowBatch) !== -1) ? rowBatch : false;
                } else inBatch = true;

                return inSubjectName && inAssignmentId && inFacultyName && inBatch;
            }
        );
        loadDataDropdown("subjectName", masterSubjectName);
        loadDataDropdown("filterBatchCode", masterBatchDetails);
    });
</script>
<?php require '../../common/footer.php'; ?>