var reviewDate = '',

    commentsOfLecture = '',

    penaltyAmount = '',

    approvedExecutionTime = '',

    noOfRating = 0,

    contentArray = [];

var assignmentId = '',

    reviewId = '',

    facultyName = '',

    payableAmount = '';



function amountToPay(approvedMins) {

    var tempLumpsumAmountPerMinute = parseFloat(remunerationData[0]['totalamount']) / parseInt(remunerationData[0]['totalMins']);

    document.getElementById('amountToPay').value = Math.round(parseFloat(tempLumpsumAmountPerMinute) * parseInt(approvedMins));

}



function showError(id, color, message) {

    if (id != '')

        document.getElementById(id).style.backgroundColor = color;

    document.getElementById('errorMessage').innerHTML = message;

}



function escapeSpecialCharacters(input) {

    var output = input.replace(/\+/g, "\+")

        .replace(/\'/g, "\\\'")

        .replace(/\"/g, "\\\"");

    return output;

}



function countRating(elementId) {

    var temp = elementId.split("rating");

    resetReview();

    noOfRating = temp[1];

    document.getElementById(elementId).className = "btn btn-scale btn-scale-desc-" + temp[1] + " btn-border";

}



function resetReview() {

    noOfRating = 0;

    for (let i = 0; i < 10; i++) {

        document.getElementById("rating" + (i + 1)).className = "btn btn-scale btn-scale-desc-" + (i + 1);

    }

}



function makeArray() {

    contentArray = [];

    var obj = {

        'assignmentId': assignmentId,

        'reviewId': reviewId,

        'unitNo': unitNo,

        "facultyId": facultyId,

        'facultyName': facultyName,

        'reviewDate': reviewDate,

        'noOfRating': noOfRating,

        'comments': commentsOfLecture,

        'penaltyAmount': penaltyAmount,

        'approvedExecutionTime': approvedExecutionTime,

    }

    contentArray.push(obj);

}



function setHeaders() {

    reviewDate = '';

    commentsOfLecture = '';

    penaltyAmount = '';

    approvedExecutionTime = '';

    payableAmount = '';



    reviewDate = $("#reviewDateAndTime").find("input").val();

    commentsOfLecture = document.getElementById("commentText").value.trim();

    commentsOfLecture = escapeSpecialCharacters(commentsOfLecture);

    commentsOfLecture = commentsOfLecture.replace("\n", " ");

    penaltyAmount = document.getElementById("penaltyAmount").value;

    approvedExecutionTime = document.getElementById("approvedExecutionTime").value.trim();



    assignmentId = document.getElementById('asssignmentId').value.trim();

    reviewId = document.getElementById('reviewId').value.trim();

    unitNo = document.getElementById('unitNo').value.trim();

    facultyName = document.getElementById('facultyName').value.trim();

    payableAmount = document.getElementById('amountToPay').value.trim();

    return 1;

}



function formValidation() {

    if (setHeaders() == 0) return 0;



    if (approvedExecutionTime == '') {

        showError('approvedExecutionTime', '#ff6666', "Please enter approved execution time.");

        return 0;

    } else showError('approvedExecutionTime', '', '');



    if (approvedExecutionTime < 0) {

        showError('approvedExecutionTime', '#ff6666', "Time can not be negative.");

        return 0;

    } else showError('approvedExecutionTime', '', '');



    if (approvedExecutionTime == 0) {

        showError('approvedExecutionTime', '#ff6666', "Approved Time can not be zero.");

        return 0;

    } else showError('approvedExecutionTime', '', '');



    if (reviewDate == '') {

        showError('reviewDateAndTime', '#ff6666', "Review Date cannot be Blank.");

        return 0;

    } else showError('reviewDateAndTime', '', '');



    if (noOfRating == 0) {

        showError('', '#ff6666', "Please Select Rating of Unit.");

        return 0;

    } else showError('', '', '');



    if (penaltyAmount < 0) {

        showError('', '#ff6666', "Penalty Amount Cannot be negative.");

        return 0;

    } else showError('', '', '');



    if (penaltyAmount == '') {

        penaltyAmount = '0';

    }



    if (makeArray() == 0) return 0;

    return 1;

}



function saveReview(id) {

    document.getElementById('saveReview').disabled = true;

    var saveFlag = "SAVEFLAG";

    if (id == 'saveReview') reviewStatus = 'UNDER REVIEW';

    else reviewStatus = 'COMPLETED';

    if (formValidation() == 0) {

        document.getElementById('saveReview').disabled = false;

        return;

    }

    else {

        if (confirm("Are you sure you want to save Unit Review??? ")) {

            document.getElementById('successMessage').innerHTML = 'Saving Lecture Review. Please wait...';

            document.getElementById('saveReview').disabled = true;

            $.post('saveAssignmentReview.php', {

                'saveFlag': saveFlag,

                'reviewStatus': reviewStatus,

                'contentArray': contentArray,

                'payableAmount': payableAmount,

                'typeOfPayment': remunerationData[0]['typeofpayment']

            }, function (data) {

                console.log(data);

                document.getElementById('successMessage').innerHTML = 'Lecture Review Saved Successfully';

            });

        }

        else document.getElementById('saveReview').disabled = false;

    }

}