var userType = '',
    userFirstName = '',
    userLastName = '',
    userLoginId = '',
    userPassword = '',
    flagForDuplicateEmail = false,
    statement = '',
    flagForStatement = 0;

const oldData = {
    oldUserId: "",
    oldUserType: "",
    oldUserFirstName: "",
    oldUserLastName: "",
    oldUserLoginId: ""
}

function loadOldValues() {
    oldData.oldUserId = userId;
    oldData.oldUserType = document.getElementById('userTypeDropdown').value.trim().toUpperCase();
    oldData.oldUserFirstName = document.getElementById('firstName').value.trim().toUpperCase();
    oldData.oldUserLastName = document.getElementById('lastName').value.trim().toUpperCase();
    oldData.oldUserLoginId = document.getElementById('loginID').value.trim();
}

function compareNewValuesWithOld() {
    statement = "UPDATE done in " + oldData.oldUserType + " details. Name- " + oldData.oldUserFirstName + " " + oldData.oldUserLastName + ". ";
    var flagForStatement = 0;

    if (oldData.oldUserType != userType) {
        flagForStatement = 1;
        statement = statement + "User type changed from " + oldData.oldUserType + " to " + userType + "<br>";
    }
    if (oldData.oldUserFirstName != userFirstName) {
        flagForStatement = 1;
        statement = statement + "First name changed from " + oldData.oldUserFirstName + " to " + userFirstName + "<br>";
    }
    if (oldData.oldUserLastName != userLastName) {
        flagForStatement = 1;
        statement = statement + "Last name changed from " + oldData.oldUserLastName + " to " + userLastName + "<br>";
    }
    if (oldData.oldUserLoginId != userLoginId) {
        flagForStatement = 1;
        statement = statement + "Login ID changed from " + oldData.oldUserLoginId + " to " + userLoginId + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    } else showError('', '', '');
    return 1;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function checkForDuplicateEmail(userEmail) {
    flagForDuplicateEmail = false;
    if (oldData.oldUserLoginId != userEmail) {
        for (i = 0; i < masterUserList.length; i++) {
            if (userEmail.trim().toLowerCase() == masterUserList[i].username.trim().toLowerCase()) {
                flagForDuplicateEmail = true;
                showError('loginID', '#ff6666', "Duplicate Email ID found. Please change it.");
                document.getElementById('editButton').disabled = false;
            }
            else showError('', '', '');
        }
    }
}

function setHeaders() {
    userType = '';
    userFirstName = '';
    userLastName = '';
    userLoginId = '';
    userPassword = '';

    userType = document.getElementById('userTypeDropdown').value.trim().toUpperCase();
    userFirstName = document.getElementById('firstName').value.trim().toUpperCase();
    userLastName = document.getElementById('lastName').value.trim().toUpperCase();
    userLoginId = document.getElementById('loginID').value.trim();
    userPassword = document.getElementById('password').value.trim();
}

function formValidation() {
    if (userType == 'SELECT USER TYPE') {
        showError('userTypeDropdown', '#ff6666', "Select Access Privileges.");
        return 0;
    } else showError('userTypeDropdown', '', '');
    if (userFirstName == '') {
        showError('firstName', '#ff6666', "First Name cannot be Blank.");
        return 0;
    } else showError('firstName', '', '');

    if (userLastName == '') {
        showError('lastName', '#ff6666', "Last Name cannot be Blank.");
        return 0;
    } else showError('lastName', '', '');
    if (userLoginId == '') {
        showError('loginID', '#ff6666', "Login ID cannot be Blank.");
        return 0;
    } else showError('loginID', '', '');
    if (!validateEmail(userLoginId)) {
        showError('loginID', '#ff6666', "Login ID is not in correct format. Please correct it.");
        return 0;
    } else showError('loginID', '', '');
    if (userPassword == '') {
        showError('password', '#ff6666', "Password cannot be Blank.");
        return 0;
    } else showError('password', '', '');
    checkForDuplicateEmail(userLoginId);
    if (flagForDuplicateEmail) {
        showError('loginID', '#ff6666', "Duplicate Login Id found. Please change it.");
        return 0;
    } else showError('loginID', '', '');
    return 1;
}

function updateUserDetails(userId) {
    var saveFlag = 'updateUser';
    document.getElementById("editButton").disabled = true;
    if (setHeaders() == 0) {
        document.getElementById("editButton").disabled = false;
        return;
    }
    if (formValidation() == 0) {
        document.getElementById("editButton").disabled = false;
        return;
    }
    if (checkOnline() == false) {
        document.getElementById("editButton").disabled = true;
        return;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('editButton').disabled = false;
        return;
    }
    else {
        if (confirm('Are you sure you want to update user details ?')) {
            document.getElementById('successMessage').innerHTML = 'Updating User Details.. Please Wait....';
            document.getElementById("editButton").disabled = true;
            $.post('updateUser.php', {
                'firstName': userFirstName,
                'lastName': userLastName,
                'password': userPassword,
                'userRightsDropdown': userType,
                'loginID': userLoginId,
                'userId': userId,
                'logStatement': statement,
                'saveFlag': saveFlag
            }, function (data) {
                document.getElementById('successMessage').innerHTML = 'User Details Successfully Updated.. Please Wait Page Will Be Refresh Automatically....';
                document.getElementById("editButton").disabled = false;
                location.reload();
            });
        }
        else document.getElementById("editButton").disabled = true;
    }
}