var userType = '',
    userFirstName = '',
    userLastName = '',
    userLoginId = '',
    userPassword = '',
    flagForDuplicateEmail = false;

function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function checkForDuplicateEmail(userEmail) {
    flagForDuplicateEmail = false;
    for (i = 0; i < masterUserList.length; i++) {
        if (userEmail.trim().toLowerCase() == masterUserList[i].username.trim().toLowerCase()) {
            flagForDuplicateEmail = true;
            showError('loginID', '#ff6666', "Duplicate Email ID found. Please change it.");
            document.getElementById('saveButton').disabled = false;
        }
        else showError('', '', '');
    }
}

function setHeaders() {
    userType = '';
    userFirstName = '';
    userLastName = '';
    userLoginId = '';
    userPassword = '';

    userType = document.getElementById('userTypeDropdown').value.trim().toUpperCase();
    userFirstName = document.getElementById('firstName').value.trim().toUpperCase();
    userLastName = document.getElementById('lastName').value.trim().toUpperCase();
    userLoginId = document.getElementById('loginID').value.trim();
    userPassword = document.getElementById('password').value.trim();
}

function formValidation() {
    if (userType == 'SELECT USER TYPE') {
        showError('userTypeDropdown', '#ff6666', "Select Access Privileges.");
        return 0;
    } else showError('userTypeDropdown', '', '');
    if (userFirstName == '') {
        showError('firstName', '#ff6666', "First Name cannot be Blank.");
        return 0;
    } else showError('firstName', '', '');

    if (userLastName == '') {
        showError('lastName', '#ff6666', "Last Name cannot be Blank.");
        return 0;
    } else showError('lastName', '', '');
    if (userLoginId == '') {
        showError('loginID', '#ff6666', "Login ID cannot be Blank.");
        return 0;
    } else showError('loginID', '', '');
    if (!validateEmail(userLoginId)) {
        showError('loginID', '#ff6666', "Login ID is not in correct format. Please correct it.");
        return 0;
    } else showError('loginID', '', '');
    if (userPassword == '') {
        showError('password', '#ff6666', "Password cannot be Blank.");
        return 0;
    } else showError('password', '', '');
    checkForDuplicateEmail(userLoginId);
    if (flagForDuplicateEmail) {
        showError('loginID', '#ff6666', "Duplicate Login Id found. Please change it.");
        return 0;
    } else showError('loginID', '', '');

    return 1;
}

function saveUser() {
    var saveFlag = 'addUser';
    document.getElementById('saveButton').disabled = true;
    if (setHeaders() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (formValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (checkOnline() == false) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    else {
        if (true) {
            if ("Are you sure you want to save user?") {
                document.getElementById('saveButton').disabled = true;
                document.getElementById('successMessage').innerHTML = 'Adding User.. Please Wait....';
                $.post('saveUser.php', {
                    'userFirstName': userFirstName,
                    'userLastName': userLastName,
                    'userLoginId': userLoginId,
                    'userPassword': userPassword,
                    'userType': userType,
                    'saveFlag': saveFlag
                }, function (data) {
                    document.getElementById('successMessage').innerHTML = 'Saved successfully. Please wait. Page will get auto-refresh.';
                    location.reload();
                });
            }
            else document.getElementById('saveButton').disabled = false;
        }
    }
}