const subjectScoreDetails = {
    CE1TotalMarks: "",
    CE1PassingMarks: "",
    CE2TotalMarks: "",
    CE2PassingMarks: "",
    attendanceTotalMarks: "",
    attendancePassingMarks: "",
    semExamTotalMarks: "",
    semExamPassingMarks: "",
    internalExamPassingMarks: 0
}

function addTableHeader() {
    var mytableHeader = document.getElementById("scoreTableHeader"),
        newRow,
        newCell;

    var newRow = document.createElement("tr");
    mytableHeader.appendChild(newRow);

    // 7%+24%+12%+12%+14%+14%+7%+7%+7%
    // roll no cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'ROLL NO';
    newCell.setAttribute("width", "7%");
    newRow.appendChild(newCell);

    // student Name name cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'STUDENT NAME';
    newCell.setAttribute("width", '24%');
    newRow.appendChild(newCell);

    // CE1 cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'CE1' + ' (OUT OF ' + subjectScoreDetails.CE1TotalMarks + ' )';
    newCell.setAttribute("width", '12%');
    newRow.appendChild(newCell);

    // CE2 cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'CE2' + ' (OUT OF ' + subjectScoreDetails.CE2TotalMarks + ' )';
    newCell.setAttribute("width", '12%');
    newRow.appendChild(newCell);

    // Attendance marks cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'ATTENDANCE MARKS' + ' (OUT OF ' + subjectScoreDetails.attendanceTotalMarks + ' )';
    newCell.setAttribute("width", '14%');
    newRow.appendChild(newCell);

    // Sem exam marks cell
    newCell = document.createElement("th");
    newCell.innerHTML = 'SEMESTER EXAM MARKS' + ' (OUT OF ' + subjectScoreDetails.semExamTotalMarks + ' )';
    newCell.setAttribute("width", '14%');
    newRow.appendChild(newCell);

    // Internal exam Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'INTERNAL EXAM STATUS';
    newCell.setAttribute("width", '7%');
    newRow.appendChild(newCell);

    // Semester exam Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'SEMESTER EXAM STATUS';
    newCell.setAttribute("width", '7%');
    newRow.appendChild(newCell);

    // Overall Status
    newCell = document.createElement("th");
    newCell.innerHTML = 'OVERALL STATUS';
    newCell.setAttribute("width", '7%');
    newRow.appendChild(newCell);
}

function generateList() {
    document.getElementById('generateSuccessMessage').innerHTML = 'Please Wait while we generate List';
    $.post('viewScoreDetails.php', {
        'examScoreMasterId': examScoreMasterId,
        'subjectScoreDetails': subjectScoreDetails,
    }, function (data) {
        $('#detailsTable').html(data);
        addTableHeader();
        document.getElementById('generateSuccessMessage').innerHTML = '';
    });
}

function getSubjectScoreDetails() {
    var tempExamTypeList = subjectDetails[0]['examType'].split("::");
    var tempExamTotalMarksList = subjectDetails[0]['examTotalMarks'].split("::");
    var tempExamPassingMarksList = subjectDetails[0]['examPassingMarks'].split("::");
    var tempInternalExamPassingMarks = 0;

    for (i = 0; i < tempExamTypeList.length; i++) {
        if (tempExamTypeList[i].trim().toUpperCase() == 'CE-1') {
            subjectScoreDetails.CE1TotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.CE1PassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = parseInt(tempInternalExamPassingMarks) + subjectScoreDetails.CE1PassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'CE-2') {
            subjectScoreDetails.CE2TotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.CE2PassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = parseInt(tempInternalExamPassingMarks) + subjectScoreDetails.CE2PassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'ATTENDANCE MARKS') {
            subjectScoreDetails.attendanceTotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.attendancePassingMarks = parseInt(tempExamPassingMarksList[i].trim());
            tempInternalExamPassingMarks = tempInternalExamPassingMarks + subjectScoreDetails.attendancePassingMarks;
        } else if (tempExamTypeList[i].trim().toUpperCase() == 'SEMESTER EXAM') {
            subjectScoreDetails.semExamTotalMarks = parseInt(tempExamTotalMarksList[i].trim());
            subjectScoreDetails.semExamPassingMarks = parseInt(tempExamPassingMarksList[i].trim());
        }
    }
    subjectScoreDetails.internalExamPassingMarks = parseInt(tempInternalExamPassingMarks);
}