var reminderDate = '';
reminderTime = '';
reminderAgenda = '';

function setHeaders() {
    reminderDate = '';
    reminderTime = '';
    reminderAgenda = '';

    reminderDate = document.getElementById("reminderDate").value;
    reminderTime = document.getElementById("reminderTime").value;
    reminderAgenda = document.getElementById("reminderAgenda").value;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function reminderValidation() {
    if (reminderDate == '') {
        document.getElementById("reminderDate").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', "", "Select Date");
        return 0;
    } else {
        document.getElementById("reminderDate").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (reminderTime == '') {
        document.getElementById("reminderTime").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', "", "Select Time");
        return 0;
    } else {
        document.getElementById("reminderTime").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (reminderAgenda == '') {
        document.getElementById("reminderAgenda").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', "", "Enter Agenda");
        return 0;
    } else {
        document.getElementById("reminderAgenda").style.backgroundColor = "";
        showError('errorMessage', '', '');

    }

    if (charLimitExceed == 'true') {
        document.getElementById("reminderAgenda").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', "", "Character limit exceeded");
        return 0;
    } else {
        document.getElementById("reminderAgenda").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
}

function saveReminder() {
    var saveFlag = 'saveReminder';

    document.getElementById("saveButton").disabled = true;
    if (setHeaders() == 0) return;
    if (reminderValidation() == 0) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    agenda = escapeSpecialCharacters(reminderAgenda);
    document.getElementById('successMessage').innerHTML = 'Saving.Please wait...';
    $.post('saveReminder.php', {
        'saveFlag': saveFlag,
        'BDEId': BDEId,
        'reminderDate': reminderDate,
        'reminderTime': reminderTime,
        'agenda': agenda
    }, function (data) {
        document.getElementById('successMessage').innerHTML = 'Saved successfully';
        document.getElementById("saveButton").disabled = false;
        location.reload();
    });
}

function confirmReminder(reminderId) {
    var saveFlag = 'confirmReminder';
    $.post('saveReminder.php', {
        'saveFlag': saveFlag,
        'reminderId': reminderId,
    }, function (data) {
        console.log(data)
        document.getElementById("saveButton").disabled = false;
        location.reload();
    });
}

function deleteReminder(reminderId) {
    var saveFlag = 'deleteReminder';
    $.post('saveReminder.php', {
        'saveFlag': saveFlag,
        'reminderId': reminderId,
    }, function (data) {
        document.getElementById("saveButton").disabled = false;
        location.reload();
    });
}

function confirmNotification(notificationId) {
    var saveFlag = 'confirmNotification';
    $.post('saveReminder.php', {
        'saveFlag': saveFlag,
        'notificationId': notificationId,
    }, function (data) {
        loadMore(end);
    });
}

function editRemainder(id){
        var remainderId = id;
        encodedValue_remainderId = btoa(remainderId);
        window.location.href = "editReminder.php?rId=" + encodedValue_remainderId ;
    }