<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../../loginPage.php');
    exit;
}

require_once '../../../common/connectToDB.php';
require '../../../common/header.php';
require '../../../common/navbar.php';
$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">UPCOMING PAYMENTS</h3>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group" style="margin-left: 21px;">
                                    <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                    <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterOtherDropDown('studAyear')" ;>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="upcomingPaymentTable">
                                <thead>
                                    <tr>
                                        <th width='5%'>STUDENT ID</th>
                                        <th width='20%'>NAME</th>
                                        <th width='15%'>DUE DATE</th>
                                        <th width='15%'>PAYMENT TYPE</th>
                                        <th width='15%'>ACADEMIC YEAR</th>
                                        <th width='15%'>STATUS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../../common/connectToDB.php';
                                    $sql = "SELECT * from studentfeestructure WHERE paymentStatus != 'APPROVED' AND amount != '0' ORDER BY STR_TO_DATE(installmentDate, '%d/%m/%Y');";
                                    $result = $conn->query($sql);
                                    $statusCss = '';
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $studentId = $row['studentId'];
                                            $studentName = $row['studentFirstName'] . ' ' . $row['studentLastName'];
                                            $paymentDate = $row['installmentDate'];
                                            $paymentType = '"' . $row['paymentType'] . '"';
                                            $amount = '"' . $row['amount'] . '"';
                                            $feeStructureRowId = '"' . $row['feeStructureRowId'] . '"';

                                            if ($row['paymentStatus'] == 'PENDING') $statusCss = 'badge badge-danger';
                                            if ($row['paymentStatus'] == 'ACCOUNTS APPROVAL PENDING') $statusCss = 'badge badge-warning';

                                            echo "
                                                <tr  class='tAC'>
                                                    <td id = " . $studentId . "> " . $studentId  . "</td>                                                       
                                                    <td>" . $studentName . "</td>                                                       
                                                    <td>" . $paymentDate . "</td>                                                       
                                                    <td>" . $row['paymentType'] . "</td>                                                                                                              
                                                    <td>" . $row['academicYear'] . "</td>                                                                                                              
                                                    <td><span class = '$statusCss'>" . $row['paymentStatus']  . "</span></td>                                                                                                             
                                                </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    $(function() {
        $('.select2').select2();
        loadDataDropdown("filterAyear", academicYearList);
        selectDropdownValue("filterAyear", academicYearList);
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();

                var rowAcademicYear = data[4].trim();

                

                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;

                
                return inStudAcademicYear;
            }
        );

        $("#upcomingPaymentTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });

    function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function loadDataDropdown(selectName, results, centerId) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("filterAyear")) {
            academicYear1 = results[i].firstAcademicYear.split("-");
            academicYear2 = results[i].thirdAcademicYear.split("-");
            academicYear = academicYear1[0] + '-' + academicYear2[1];
            options.value = options.text = academicYear;
            theSelect.add(options);
        } else if (selectName.includes("fiterLeadOwner")) {
            options.value = results[i].userid;
            options.text = results[i].firstname + " " + results[i].lastname.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function filterOtherDropDown(flag) {
    var table = $('#upcomingPaymentTable').DataTable();
    table.draw();
}

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;

        for (var i = 0; i < val.length; i++) {
            academicYear1 = val[0].firstAcademicYear.split("-");
            academicYear2 = val[0].thirdAcademicYear.split("-");
            academicYear = academicYear1[0] + '-' + academicYear2[1];
            if (optVal == academicYear) {
                theSelect.options[j].selected = true;
                selectedAcademicYear1 = academicYear;

            }

        }
    }
    return;
}
</script>

<?php require '../../../common/footer.php'; ?>