<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';

$masterFacultyList = [];
$sql = "SELECT * FROM faculty";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterFacultyList,$row);
    }
}

require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB" id="pageTitle">ADD NEW FACULTY</h3>
                            <br>
                            <br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>First Name <span class="star">*</span></label>
                                        <input type="text" class="form-control" id="facultyFirstName"
                                            placeholder='Enter First Name'>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Last Name <span class="star">*</span></label>
                                        <input type="text" class="form-control" id="facultyLastName"
                                            placeholder='Enter Last Name'>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Login Id <span class="star">*</span></label>
                                        <input type="email" class="form-control" id="facultyLoginId"
                                            onchange="checkForDuplicate(this.value)" placeholder='Enter Login Id'>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Password</label>
                                        <input type="text" value="" class="form-control" id="facultyPassword"
                                            placeholder='Enter Password' disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer tAC">
                                <p id='errorMessage' class="text-center"
                                    style="color: red; font-size: 1.2em;   text-align: center;">
                                </p>
                                <p id='successMessage' class="text-center"
                                    style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                </p>
                                <input type="button" class="btn btn-primary" value="Add" id="saveButton"
                                    onclick="addFaculty()" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="addFaculty.js?v=<?php echo $fileVersion; ?>"></script>
<script>
var masterFacultyList = <?php echo json_encode($masterFacultyList); ?>;
document.getElementById('facultyPassword').value = randomString(10, '#a!');
</script>

<?php require '../../common/footer.php'; ?>