var facultyFirstName = '',
    facultyLastName = '',
    facultyLoginId = '',
    facultyPassword = '';

function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function checkForDuplicate(userEmail) {
    flagForDuplicate = false;
    for (i = 0; i < masterFacultyList.length; i++) {
        if (userEmail.trim().toLowerCase() == masterFacultyList[i].emailId.trim().toLowerCase()) flagForDuplicate = true;
    }
}

function facultyValidation() {
    facultyFirstName = '';
    facultyLastName = '';
    facultyLoginId = '';
    facultyPassword = '';

    facultyFirstName = document.getElementById('facultyFirstName').value.trim().toUpperCase();
    facultyLastName = document.getElementById('facultyLastName').value.trim().toUpperCase();
    facultyLoginId = document.getElementById('facultyLoginId').value.trim();
    facultyPassword = document.getElementById('facultyPassword').value.trim();

    if (facultyFirstName == '') {
        showError('facultyFirstName', '#ff6666', "First name cannot be blank.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyFirstName', '', '');

    if (facultyLastName == '') {
        showError('facultyLastName', '#ff6666', "Last name cannot be blank.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyLastName', '', '');

    if (facultyLoginId == '') {
        showError('facultyLoginId', '#ff6666', "Login Id cannot be blank.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyLoginId', '', '');

    if (!validateEmail(facultyLoginId)) {
        document.getElementById("facultyLoginId").style.backgroundColor = "#ffc2b3";
        showError('facultyLoginId', '', "Login Id is not in correct format.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else {
        document.getElementById("facultyLoginId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
    checkForDuplicate(facultyLoginId);
    if (flagForDuplicate) {
        document.getElementById("saveButton").disabled = false;
        showError('facultyLoginId', '#ff6666', "Duplicate Login Id found. Please change it.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyLoginId', '', '');
    return 1;
}

function addFaculty() {
    document.getElementById("saveButton").disabled = true;
    if (facultyValidation() == 0) return;
    var saveFlag = 'saveFaculty';
    if (confirm("Are you sure you want to add faculty?")) {
        document.getElementById("saveButton").disabled = true;
        document.getElementById('successMessage').innerHTML = 'Adding Faculty Please Wait...';
        $.post('saveFaculty.php', {
            'saveFlag': saveFlag,
            'facultyFirstName': facultyFirstName,
            'facultyLastName': facultyLastName,
            'facultyLoginId': facultyLoginId,
            'facultyPassword': facultyPassword
        }, function (data) {
            document.getElementById('successMessage').innerHTML = 'Faculty added successfully. Please wait. The page will get auto-refresh...';
            document.getElementById("saveButton").disabled = false;
            location.reload();
        });
    }
    else document.getElementById("saveButton").disabled = false;
}