<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">PENDING FACULTY</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingFacultyTable">
                                <thead>
                                    <tr>
                                        <th class="col-md-1">
                                            SR NO
                                        </th>
                                        <th class="col-md-1">
                                            FACULTY NAME
                                        </th>
                                        <!-- <th class="col-md-1">
                                            PRIMARY NO.
                                        </th> -->
                                        <th class="col-md-2">
                                            FACULTY EMAIL
                                        </th>
                                        <th class="col-md-2">
                                            SUBJECT ALLOCATED
                                        </th>
                                        <th class="col-md-1">
                                            APPROVAL PENDING
                                        </th>
                                        <th class="col-md-4">
                                            PROFILE COMPLETION STATUS
                                        </th>
                                        <th class="col-md-1">
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * FROM faculty WHERE formStatus = 'PENDING' ORDER BY facultyId desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        $rowId = 1;
                                        while ($row = $result->fetch_assoc()) {
                                            $facultyName = '';
                                            $academicApproval = '';
                                            $centerManagerApproval = '';
                                            $badgeCss = '';
                                            $personalInformation = 0;
                                            $enrollmentDetails = 0;
                                            $bankDetails = 0;
                                            $legalDocumentation = 0;
                                            $agreementAcceptance = 0;
                                            $flag = '"' . 'PendingFacultyFlag' . '"';
                                            $statusCss1 = '';
                                            $statusCss2 = '';
                                            $statusCss3 = '';
                                            $statusCss4 = '';
                                            $statusCss5 = '';

                                            $facultyName = $row['firstName'] . ' ' . $row['lastName'];
                                            $id = $row["facultyId"];
                                            if ($row['academicApproval'] != "APPROVED")
                                                $academicApproval = "<span class='badge badge-info'>ACADEMIC</span>";
                                            if ($row['centerManagerApproval'] != "APPROVED")
                                                $centerManagerApproval = "<span class='badge badge-success'>CENTER MANAGER</span>";

                                            if (strlen($row['firstName']) > 0) $personalInformation += 2;
                                            if (strlen($row['lastName']) > 0) $personalInformation += 2;
                                            if (strlen($row['pass']) > 0) $personalInformation += 2;
                                            if (strlen($row['primeryNo']) > 0) $personalInformation += 3;
                                            if (strlen($row['whatsAppNo']) > 0) $personalInformation += 3;
                                            if (strlen($row['facultyPanCard']) > 0) $personalInformation += 3;
                                            if (strlen($row['facultyAddress']) > 0) $personalInformation += 3;
                                            if (strlen($row['facultyPhoto']) > 0) $personalInformation += 2;
                                            if ($personalInformation <= 0) $statusCss1 = "badge badge-danger";
                                            if ($personalInformation > 0) $statusCss1 = "badge badge-success";

                                            if (strlen($row['facultyType']) > 0) $enrollmentDetails += 6;
                                            if (strlen($row['commencementDate']) > 0) $enrollmentDetails += 7;
                                            if (strlen($row['facultySubject']) > 0) $enrollmentDetails += 7;
                                            if ($enrollmentDetails <= 0) $statusCss2 = "badge badge-danger";
                                            if ($enrollmentDetails > 0) $statusCss2 = "badge badge-success";

                                            if (strlen($row['bankName']) > 0) $bankDetails += 3;
                                            if (strlen($row['accountHolderName']) > 0) $bankDetails += 3;
                                            if (strlen($row['ifscCode']) > 0) $bankDetails += 3;
                                            if (strlen($row['accountType']) > 0) $bankDetails += 3;
                                            if (strlen($row['accountNo']) > 0) $bankDetails += 3;
                                            if (strlen($row['branch']) > 0) $bankDetails += 3;
                                            if (strlen($row['cancelledCheque']) > 0) $bankDetails += 2;
                                            if ($bankDetails <= 0) $statusCss3 = "badge badge-danger";
                                            if ($bankDetails > 0) $statusCss3 = "badge badge-success";

                                            if (strlen($row['addressProof']) > 0) $legalDocumentation += 5;
                                            if (strlen($row['idProof']) > 0) $legalDocumentation += 5;
                                            if (strlen($row['facultyResumeDoc']) > 0) $legalDocumentation += 5;
                                            if (strlen($row['academicCertificate']) > 0) $legalDocumentation += 5;
                                            if ($legalDocumentation <= 0) $statusCss4 = "badge badge-danger";
                                            if ($legalDocumentation > 0) $statusCss4 = "badge badge-success";

                                            if (strlen($row['formDAT']) > 0) $agreementAcceptance += 20;
                                            if ($agreementAcceptance <= 0) $statusCss5 = "badge badge-danger";
                                            if ($agreementAcceptance > 0) $statusCss5 = "badge badge-success";

                                            $profilePercentage = $personalInformation + $enrollmentDetails + $bankDetails + $legalDocumentation + $agreementAcceptance;

                                            if ($profilePercentage <= 20) $badgeCss = "badge badge-danger";
                                            if ($profilePercentage > 20 && $profilePercentage <= 40) $badgeCss = "badge badge-warning";
                                            if ($profilePercentage > 40 && $profilePercentage <= 60) $badgeCss = "badge badge-primary";
                                            if ($profilePercentage > 60 && $profilePercentage <= 80) $badgeCss = "badge badge-primary";
                                            if ($profilePercentage > 80) $badgeCss = "badge badge-success";

                                            echo "
                                                <tr  class='tAC'>
                                                    <td>" . $rowId . "</td> 
                                                    <td>" . $facultyName . "</td>  
                                                    <td>" . $row["emailId"] . "</td>
                                                    <td>" . str_replace("|", ",", $row["facultySubject"]) . "</td>
                                                    <td>" . $centerManagerApproval  . " " . $academicApproval . "</td>
                                                    <td><span class='" . $badgeCss . "'>
                                                    <table>
                                                        <thead>
                                                            <th style='font-size: 10px;'> 
                                                            SEC A
                                                            </th>
                                                            <th style='font-size: 10px;'>
                                                            SEC B
                                                            </th>
                                                            <th style='font-size: 10px;'>
                                                            SEC C
                                                            </th>
                                                            <th style='font-size: 10px;'>
                                                            SEC D
                                                            </th>
                                                            <th style='font-size: 10px;'>
                                                            SEC E
                                                            </th>
                                                            <th style='font-size: 10px;'>
                                                            Overall Status
                                                            </th>
                                                        </thead>
                                                        <tbody>
                                                        <td><span class='" . $statusCss1 . "'>" . $personalInformation . '%' . "</span></td>
                                                        <td><span class='" . $statusCss2 . "'>" . $enrollmentDetails . '%' . "</span></td>
                                                        <td><span class='" . $statusCss3 . "'>" . $bankDetails . '%' . "</span></td>
                                                        <td><span class='" . $statusCss4 . "'>" . $legalDocumentation . '%' . "</span></td>
                                                        <td><span class='" . $statusCss5 . "'>" . $agreementAcceptance . '%' . "</span></td>
                                                        <td><span class='" . $badgeCss . "'>" . $profilePercentage . '%' . "</span></td>
                                                        </tbody>
                                                    </table>
                                                    </span></td>
                                                    <td><a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id," . $flag . ")' id = " . $id . " title='click hear to view Faculty Details'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                    </td>
                                                </tr>";
                                            $rowId += 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
    function showDetails(id, flag) {
        encodedValue_id = btoa(id);
        encodedKey_facultyId = btoa('facultyId');
        encodedValue_flag = btoa(flag);
        window.location.href = 'viewFacultyDetails.php?' + encodedKey_facultyId + "=" + encodedValue_id + "&flag=" + encodedValue_flag;
    }
    $(function() {
        $("#pendingFacultyTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 5,
        });
    });
</script>
<?php require '../../common/footer.php'; ?>