<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">MANAGE ALL FACULTY</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="AllFacultyTable">
                                <thead>
                                    <tr>
                                        <th class="col-md-1">
                                            SR NO
                                        </th>
                                        <th class="col-md-2">
                                            FACULTY NAME
                                        </th>
                                        <th class="col-md-2">
                                            PRIMARY NO.
                                        </th>
                                        <th class="col-md-2">
                                            FACULTY EMAIL
                                        </th>
                                        <th class="col-md-1">
                                            PASSWORD
                                        </th>
                                        <th class="col-md-2">
                                            SUBJECT ALLOCATED
                                        </th>
                                        <th class="col-md-1">
                                           AVERAGE RATING
                                        </th>
                                        <th class="col-md-1">
                                            FACULTY STATUS
                                        </th>
                                        <th class="col-md-1">
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * FROM faculty WHERE formStatus = 'APPROVED' ORDER BY facultyId desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        $rowId = 1;
                                        while ($row = $result->fetch_assoc()) {
                                            $facultyName = '';
                                            $facultyName = $row['firstName'] . ' ' . $row['lastName'];
                                            $id = $row["facultyId"];
                                            $averageRating = $row["averageRating"];
                                            $statusCSS = '';
                                            $flag = '"' . 'AllFacultyFlag' . '"';

                                            if ($row['formStatus'] == "PENDING") $statusCSS = "badge badge-danger";
                                            else if ($row['formStatus'] == "APPROVED") $statusCSS = "badge badge-success";
                                            echo "
                                                <tr  class='tAC'>
                                                    <td>" . $rowId . "</td> 
                                                    <td>" . $facultyName . "</td>  
                                                    <td>" . $row["primeryNo"] . "</td>
                                                    <td>" . $row["emailId"] . "</td>
                                                    <td>" . $row["pass"] . "</td>
                                                    <td>" . str_replace("|", ",", $row["facultySubject"]) . "</td>
                                                    <td>" . $averageRating.'/10' . "</td>
                                                    <td><span class = '$statusCSS'>" . $row["formStatus"] . "</span></td>
                                                    <td><a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id," . $flag . ")' id = " . $id . " title='click hear to view Faculty Details'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                    </td>
                                                </tr>";
                                            $rowId += 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
    function showDetails(id, flag) {
        encodedValue_id = btoa(id);
        encodedKey_facultyId = btoa('facultyId');
        encodedValue_flag = btoa(flag);
        window.location.href = 'viewFacultyDetails.php?' + encodedKey_facultyId + "=" + encodedValue_id + "&flag=" + encodedValue_flag;
    }
    $(function() {
        $("#AllFacultyTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 5,
        });
    });
</script>
<?php require '../../common/footer.php'; ?>