var batchId = '',
    academicYear = '',
    titleName = '',
    batchStatus = '',
    capacity = '',
    statement = '',
    flagForStatement = 0;
var duplicatetitleName = false;

const oldData = {
    batchId: "",
    batchAcademicYear: "",
    batchTitle: "",
    batchCapacity: "",
    batchStatus: ""
}

function loadOldValues() {
    oldData.batchId = document.getElementById('batchId').value.trim();
    oldData.batchAcademicYear = document.getElementById('academicYear').value.trim();
    oldData.batchTitle = document.getElementById('titleName').value.trim().toUpperCase();
    oldData.batchCapacity = document.getElementById('capacity').value.trim();
    oldData.batchStatus = document.getElementById('batchStatus').value.trim().toUpperCase();
}

function compareNewValuesWithOld() {
    statement = "UPDATE done in Batch with batch ID- " + oldData.batchId + ". ";
    var flagForStatement = 0;

    if (oldData.batchAcademicYear != academicYear) {
        flagForStatement = 1;
        statement = statement + "Academic year changed from " + oldData.batchAcademicYear + " to " + academicYear + "<br>";
    }
    if (oldData.batchTitle != titleName) {
        flagForStatement = 1;
        statement = statement + "Batch title changed from " + oldData.batchTitle + " to " + titleName + "<br>";
    }
    if (oldData.batchCapacity != capacity) {
        flagForStatement = 1;
        statement = statement + "Batch capacity changed from " + oldData.batchCapacity + " to " + capacity + "<br>";
    }
    if (oldData.batchStatus != batchStatus) {
        flagForStatement = 1;
        statement = statement + "Batch status changed from " + oldData.batchStatus + " to " + batchStatus + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";
    options.disabled = false;
    options.selected = true;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    if (selectName == "academicYear") dummyOptions(theSelect, options, "ACADEMIC YEAR");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("academicYear")) {
            academicYear1 = results[i].firstAcademicYear.split("-");
            academicYear2 = results[i].thirdAcademicYear.split("-");
            academicYear = academicYear1[0] + '-' + academicYear2[1];
            options.value = options.text = academicYear;
            theSelect.add(options);
        }
    }
}

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function checkDuplicate() {
    var saveFlag = 'checkDuplicate';
    academicYear = document.getElementById('academicYear').value.trim();
    titleName = document.getElementById('titleName').value.trim();
    if (oldAcademicYear == academicYear && oldBatchTitle == titleName) return;
    $.post('saveBatch.php', {
        'saveFlag': saveFlag,
        'titleName': titleName,
        'academicYear': academicYear
    },
        function (data) {
            if (data == 1) {
                showError('errorMessage', '', 'Batch Already Exist In Selected Year');
                document.getElementById("titleName").style.backgroundColor = "#ffc2b3";
                duplicatetitleName = true;
                return 0;
            } else {
                showError('', '', '');
                duplicatetitleName = false;
            }
        }
    );
}

function batchValidation() {
    batchId = '';
    academicYear = '';
    titleName = '';
    capacity = '';
    batchStatus = '';

    batchId = document.getElementById('batchId').value.trim();
    academicYear = document.getElementById('academicYear').value.trim();
    titleName = document.getElementById('titleName').value.trim().toUpperCase();
    capacity = document.getElementById('capacity').value.trim();
    batchStatus = document.getElementById('batchStatus').value.trim().toUpperCase();

    if (academicYear == 0) {
        showError('academicYear', '#ff6666', "Please select academic year");
        console.log('dfghj');
        return 0;
    } else showError('academicYear', '', " ");

    if (titleName == 0) {
        showError('titleName', '#ff6666', "Enter batch title");;
        return 0;
    } else showError('titleName', '', " ");

    if (capacity == 0) {
        showError('capacity', '#ff6666', "Enter batch capacity");
        return 0;
    } else showError('capacity', '', " ");

    if (capacity < 0) {
        showError('capacity', '#ff6666', "Batch capacity cannot be negative.");
        return 0;
    } else showError('capacity', '', " ");

    if (parseInt(capacity) > 60) {
        showError('capacity', '#ff6666', "Batch capacity should not be greater than 60");
        return 0;
    } else showError('capacity', '', " ");

    if (batchStatus == 'SELECT BATCH STATUS') {
        showError('batchStatus', '#ff6666', "Select batch status");
        document.getElementById('editButton').disabled = false;
        return 0;
    } else {
        showError('batchStatus', '', " ");
    }
    if (parseInt(capacity) < parseInt(noOfStudentsEnrolled)) {
        showError('', '#ff6666', noOfStudentsEnrolled + " students has already enrolled in this batch. Capacity can not be less than that.");
        document.getElementById('editButton').disabled = false;
        return 0;
    } else {
        showError('', '', " ");
    }

    if (duplicatetitleName == true) {
        showError('titleName', '#ff6666', "Batch Already Exist In Selected Year");
        return 0;
    } else showError('titleName', '', " ");
}

function editBatchDetails() {
    document.getElementById('editButton').disabled = true;
    var saveFlag = 'editBatch';
    if (batchValidation() == 0) {
        document.getElementById('editButton').disabled = false;
        return 0;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('editButton').disabled = false;
        return;
    }

    document.getElementById('successMessage').innerHTML = 'saving Batch. Please wait...';
    $.post('updateBatch.php', {
        'saveFlag': saveFlag,
        'batchId': batchId,
        'academicYear': academicYear,
        'titleName': titleName,
        'capacity': capacity,
        'batchStatus': batchStatus,
        'logStatement': statement
    },
        function (data) {
            document.getElementById('successMessage').innerHTML = 'Batch Successfuly Updated';
            // loadBatchDetails();
            // document.getElementById('successMessage').innerHTML = '';
            // document.getAnimations('academicYear').value = '';
            location.reload();
        })
}