<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';

$sql = "SELECT * FROM seriesnumber where seriesName = 'batchId';";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $batchId = $row['seriesValue'];
    }
}

$academicYearList = [];
$sql2 = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($academicYearList, $row2);
    }
}

require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <h3 class="card-title">CREATE BATCH</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Batch Id <span class="star">*</span></label>
                                        <input type="number" class="form-control" id="batchId" value="<?php echo $batchId; ?>" placeholder="batch Id" disabled>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label>Academic Year <span class="star">*</span></label>
                                    <select class="form-control custom-select" id="academicYear" onchange="checkDuplicate()">
                                    </select>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label>Title <span class="star">*</span></label>
                                        <input type="text" class="form-control" id="titleName" placeholder="Enter the title" onchange="checkDuplicate()"></input>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Capacity <span class="star">*</span></label>
                                        <input type="number" class="form-control" id="capacity" placeholder="Capacity"></input>
                                    </div>
                                </div>
                                <!-- <div class="col-md-2">
                                    <label>Batch Status <span class="star">*</span></label>
                                    <select class="form-control custom-select" id="batchStatus">
                                        <option value="SELECT BATCH STATUS">SELECT BATCH STATUS</option>
                                        <option value="PENDING" selected>PENDING</option>
                                        <option value="COMPLETED">COMPLETED</option>
                                    </select>
                                </div> -->
                            </div>
                            <div class="card-footer tAC">
                                <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                </p>
                                <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                </p>
                                <span id="savedData"></span>
                                <input type="button" class="btn btn-primary" value="Save Batch" onclick="saveBatch()" id="saveButton" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card card-info mT10">
                        <!-- show traits data -->
                        <!-- <div id="showBatchDetails">
                        </div> -->
                        <!--  -->
                        <div class="card-header">
                            <h3 class="tAC fSB">Batch Details</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <!-- <div class="col-md-12 mb-2 mt-2">
                                        <h3 class="tAC fSB">Batch Details</h3>
                                    </div> -->
                                    <table class="table table-striped projects tAC" id="manageBatch">
                                        <thead>
                                            <tr>
                                                <th class="col-md-1">
                                                    BATCH ID
                                                </th>
                                                <th class="col-md-2">
                                                    ACADEMIC YEAR
                                                </th>
                                                <th class="col-md-2">
                                                    BATCH TITLE
                                                </th>
                                                <th class="col-md-2">
                                                    CAPACITY
                                                </th>
                                                <th class="col-md-2">
                                                    NO OF STUDENTS IN BATCH
                                                </th>
                                                <th class="col-md-2">
                                                    BATCH STATUS
                                                </th>
                                                <th class="col-md-1">
                                                    ACTION
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            require_once '../../common/connectToDB.php';
                                            $sql = "SELECT * FROM batchmaster ORDER BY batchId DESC;";
                                            $result = $conn->query($sql);
                                            if ($result->num_rows > 0) {
                                                while ($row = $result->fetch_assoc()) {
                                                    $statusCss = '';
                                                    $batchStatus = $row['batchStatus'];
                                                    $batchId = $row['batchId'];
                                                    if ($batchStatus == 'PENDING') $statusCss = 'badge badge-danger';
                                                    if ($batchStatus == 'COMPLETED') $statusCss = 'badge badge-success';

                                                    echo "<tr  class='tAC'>                                                                                                     
                                                    <td>" . $row['batchId'] . "</td> 
                                                    <td>" . $row['academicYear'] . "</td> 
                                                    <td>" . $row['batchTitle'] . "</td> 
                                                    <td>" . $row['capacity'] . "</td>
                                                    <td>" . $row['noOfStudents'] . "</td>
                                                    <td><span class = '" . $statusCss . "'>" . $batchStatus . "</span></td>
                                                    <td class='project-actions'>
                                                        <a class='btn btn-primary btn-sm' href='#' onclick='showBatch(this.id)' id = " . $batchId . " title='click here to view batch Details'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                        <a class='btn btn-warning btn-sm' href='#' onclick='editBatch(this.id)' id = " . $batchId . " title='click here to edit batch Details'>
                                                            <i class='fas fa-user-edit'>
                                                            </i>
                                                        </a>
                                                    </td>
                                                </tr>  ";
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="createBatch.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    var oldAcademicYear = '';
    var oldBatchTitle = '';
    $(function() {
        // loadBatchDetails();
        $("#manageBatch").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        loadDataDropdown("academicYear", academicYearList);
    });
</script>
<?php require '../../common/footer.php'; ?>