<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
echo 'hiiiiiiii';
$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}

$masterBatchDetails = [];
$sql = "SELECT * FROM batchmaster ORDER BY batchId DESC;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterBatchDetails, $row);
    }
}

$masterSemester = [];
$sql2 = "SELECT * FROM semester;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSemester, $row2);
    }
}
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">SUBJECTWISE ATTENDANCE </h3>
                            <br>
                            <br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                        <select class="select2" multiple="multiple" id="filterAyear" data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;" onchange="filterTable('studAyear')" ;>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY BATCH</label>
                                        <select class="select2" multiple="multiple" id="filterBatchCode" style="width: 100%;" onchange="filterTable('batch');" data-placeholder="SELECT BATCH">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY SEMESTER NO.</label>
                                        <select class="select2" multiple="multiple" id="semDropdown" style="width: 100%;" onchange="filterTable('semester');" data-placeholder="SELECT SEMESTER">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="subjectsTable">
                                <thead>
                                    <tr>
                                        <th width='15%'>BATCH NAME</th>
                                        <th width='15%'>ACADEMIC YEAR</th>
                                        <th width='15%'>SEMESTER</th>
                                        <th width='35%'>SUBJECT NAME</th>
                                        <th width='10%'>ATTENDANCE(%)</th>
                                        <th width='10%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';

                                    // $sql = " SELECT batchName,subjectName,academicYear,semester from timetable where lectureStatus='COMPLETED' group by subjectName,batchName  ORDER BY semester DESC ;";
                                    $sql = "SELECT batchName,subjectName,count(subjectName) AS totalLectures, academicYear,semester,count(if(attendanceStatus='P',1,null)) as presentCount FROM studentattendance GROUP BY subjectName,batchName ORDER BY semester DESC ;";
                                    // echo $sql;
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $subjectName = $row['subjectName'];
                                            $semester = $row['semester'];
                                            $academicYear = $row['academicYear'];
                                            $batchName = $row['batchName'];
                                            $batchName1 = '"' . $row['batchName'] . '"';
                                            $attendancePercentage = '';
                                            $percentCss = '';
                                            $attendancePercentage = round(($row['presentCount'] / $row['totalLectures']) * 100);

                                            if ($attendancePercentage >= 0 && $attendancePercentage <= 25) $percentCss = 'badge badge-danger';
                                            if ($attendancePercentage > 25 && $attendancePercentage <= 50) $percentCss = 'badge badge-warning';
                                            if ($attendancePercentage > 50 && $attendancePercentage <= 75) $percentCss = 'badge badge-primary';
                                            if ($attendancePercentage > 75 && $attendancePercentage <= 100) $percentCss = 'badge badge-success';
                                            echo "
                                                <tr class='tAC'>
                                                    <td>" . $batchName . "</td>
                                                    <td>" . $academicYear . "</td>
                                                    <td>" . $semester . "</td>
                                                    <td>" . $subjectName . "</td>
                                                    <td><span class = '" . $percentCss . "'>" . $attendancePercentage . "</span></td>
                                                    <td class='project-actions'>
                                                        <a class='btn btn-primary btn-sm' href='#' onclick='showAttendance(this.id,$batchName1,$attendancePercentage)' id = '" . $subjectName . "' title='click hear to view attendance'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                    </td>
                                                </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="studentAttendance.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    var masterBatchDetails = <?php echo json_encode($masterBatchDetails) ?>;
    var masterSemester = <?php echo json_encode($masterSemester); ?>;

    $(function() {
        $('.select2').select2();

        $("#subjectsTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedSemester = getSelectValues('', document.getElementById("semDropdown")).trim();
                selectedBatch = getSelectValues('', document.getElementById("filterBatchCode")).trim();
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();

                var rowSemester = data[2].trim();
                var rowBatch = data[0].trim();
                var rowAcademicYear = data[1].trim();

                if (selectedSemester != '') {
                    inSemester = (selectedSemester.indexOf(rowSemester) !== -1) ? rowSemester : false;
                } else inSemester = true;

                if (selectedBatch != '') {
                    inBatch = (selectedBatch.indexOf(rowBatch) !== -1) ? rowBatch : false;
                } else inBatch = true;

                if (selectedAcademicYear != '') {
                    inAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) !== -1) ? rowAcademicYear : false;
                } else inAcademicYear = true;
                return inSemester && inAcademicYear && inBatch;
            }
        );

        loadDataDropdown("filterAyear", academicYearList);
        loadDataDropdown("filterBatchCode", masterBatchDetails);
        loadDataDropdown("semDropdown", masterSemester);
    });
</script>
<?php require '../../common/footer.php'; ?>