function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) result += opt.text;
        }
        if (flag == "multiple") {
            if (opt.selected) result += opt.text + "|";
        }
    }
    return result.trim();
}

function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");
    if (selectName == "assignmentIdDrpodown") dummyOptions(theSelect, options, "ASSIGNMENT ID");
    if (selectName == "facultyNameDropdown") dummyOptions(theSelect, options, "FACULTY NAME");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("semester")) {
            options.value = options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("assignmentIdDrpodown")) {
            options.value = options.text = results[i].assignmentId.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("facultyNameDropdown")) {
            facultyName = results[i].firstName + ' ' + results[i].lastName;
            options.value = options.text = facultyName.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function filterOtherDropDown(flag) {
    tempSemester = getSelectValues('', document.getElementById("semester")).trim();
    tempSubject = getSelectValues('', document.getElementById("subjectName")).trim();
    tempSubjectName = [];
    tempFacultyName = [];
    tempAssignmentId = [];
    newAssignmentIdArray = [];
    if (flag == "semester") {
        loadDataDropdown("subjectName", []);
        loadDataDropdown("assignmentIdDrpodown", []);
        loadDataDropdown("facultyNameDropdown", []);
        for (let i = 0; i < masterSubjectName.length; i++) {
            if (masterSubjectName[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": masterSubjectName[i].subjectId.trim(),
                    "subjectName": masterSubjectName[i].subjectName.trim()
                });
            }
            loadDataDropdown("subjectName", tempSubjectName);
        }
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester) {
                tempAssignmentId.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", tempAssignmentId);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "subject") {
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester && masterAssignmentData[i].subjectName == tempSubject) {
                newAssignmentIdArray.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", newAssignmentIdArray);
        }
        for (let i = 0; i < masterFacultyName.length; i++) {
            tempSubjectList = masterFacultyName[i].facultySubject.split("|");
            for (j = 0; j < tempSubjectList.length; j++) {
                if (tempSubjectList[j] == tempSubject) {
                    tempFacultyName.push(obj = {
                        "firstName": masterFacultyName[i].firstName.trim().toUpperCase(),
                        "lastName": masterFacultyName[i].lastName.trim().toUpperCase()
                    });
                }
            }
            loadDataDropdown("facultyNameDropdown", tempFacultyName);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "assignment") {
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == 'faculty') {
        var table = $('#example1').DataTable();
        table.draw();
    }
}

function addReview(assignmentId, reviewId, unitNo, noOfLectures, noOfPenaltyFlag) {
    encodedValue_assignmentId = btoa(assignmentId);
    encodedValue_reviewId = btoa(reviewId);
    encodedValue_unitNo = btoa(unitNo);
    encodedValue_noOfLectures = btoa(noOfLectures);
    encodedValue_noOfPenaltyFlag = btoa(noOfPenaltyFlag);

    encodedKey_aId = btoa('aId');
    encodedKey_rId = btoa('rId');
    encodedKey_uNo = btoa('uNo');
    encodedKey_nOL = btoa('nOL');
    
    window.location.href = "addReview.php?" + encodedKey_aId + "=" + encodedValue_assignmentId + "&" + encodedKey_rId + "=" + encodedValue_reviewId + "&" + encodedKey_uNo + "=" + encodedValue_unitNo + "&" + encodedKey_nOL + "=" + encodedValue_noOfLectures + "&nOpf=" + encodedValue_noOfPenaltyFlag;
}