var reviewDate = '',
    commentsOfLecture = '',
    penaltyAmount = '',
    approvedExecutionTime = '',
    noOfRating = 0,
    contentArray = [];

var assignmentId = '',
    reviewId = '',
    facultyName = '',
    statement = '',
    flagForStatement = 0,
    payableAmount = '';

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

const oldData = {
    unitNo: "",
    assignmentNo: "",
    approvedExecutionTime: "",
    penaltyAmount: "",
    reviewDate: "",
    oldRating: "",
    reviewNote: ""
}

function loadOldValues() {
    oldData.assignmentNo = document.getElementById('asssignmentId').value.trim();
    oldData.unitNo = document.getElementById('unitNo').value.trim();
    oldData.approvedExecutionTime = document.getElementById('approvedExecutionTime').value.trim();
    oldData.penaltyAmount = document.getElementById("penaltyAmount").value.trim();
    oldData.reviewDate = $("#reviewDateAndTime").find("input").val();
    oldData.oldRating = assignmentRating;
    oldData.reviewNote = document.getElementById("commentText").value.trim();
}

function compareOldValuesWithOld() {
    statement = "UPDATE done in assignment review of " + oldData.unitNo + " of assignment with assignment ID- (" + oldData.assignmentNo + ")." + "<br>";
    var flagForStatement = 0;

    if (oldData.approvedExecutionTime != approvedExecutionTime) {
        flagForStatement = 1;
        statement = statement + "Approved execution time changed from " + oldData.approvedExecutionTime + " min to " + approvedExecutionTime + " min<br>";
    }
    if (oldData.penaltyAmount != penaltyAmount) {
        flagForStatement = 1;
        statement = statement + "Penalty amount changed from " + oldData.penaltyAmount + " to " + penaltyAmount + "<br>";
    }
    if (oldData.reviewDate != reviewDate) {
        flagForStatement = 1;
        statement = statement + "Review date changed from " + oldData.reviewDate + " to " + reviewDate + "<br>";
    }
    if (oldData.oldRating != noOfRating) {
        flagForStatement = 1;
        statement = statement + "Rating changed from " + oldData.oldRating + " to " + noOfRating + "<br>";
    }
    if (oldData.reviewNote != commentsOfLecture) {
        flagForStatement = 1;
        statement = statement + "Review note changed from " + oldData.reviewNote + " to " + commentsOfLecture + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

function amountToPay(approvedMins) {
    approvedMins = document.getElementById('approvedExecutionTime').value.trim();
    var tempLumpsumAmountPerMinute = parseFloat(remunerationData[0]['totalamount']) / parseInt(remunerationData[0]['totalMins']);
    document.getElementById('amountToPay').value = Math.round(parseFloat(tempLumpsumAmountPerMinute) * parseInt(approvedMins));
}

function resetReview() {
    noOfRating = 0;
    for (let i = 0; i < 10; i++) {
        document.getElementById("rating" + (i + 1)).className = "btn btn-scale btn-scale-desc-" + (i + 1);
    }
}

function countRating(elementId) {
    var temp = elementId.split("rating");
    resetReview();
    noOfRating = temp[1];
    document.getElementById(elementId).className = "btn btn-scale btn-scale-desc-" + temp[1] + " btn-border";
}

function setHeaders() {
    reviewDate = '';
    commentsOfLecture = '';
    penaltyAmount = '';
    approvedExecutionTime = '';
    payableAmount = '';

    reviewDate = $("#reviewDateAndTime").find("input").val();
    commentsOfLecture = document.getElementById("commentText").value.trim();
    penaltyAmount = document.getElementById("penaltyAmount").value.trim();
    approvedExecutionTime = document.getElementById("approvedExecutionTime").value.trim();

    assignmentId = document.getElementById('asssignmentId').value.trim();
    reviewId = document.getElementById('reviewId').value.trim();
    unitNo = document.getElementById('unitNo').value.trim();
    facultyName = document.getElementById('facultyName').value.trim();
    payableAmount = document.getElementById('amountToPay').value.trim();
    return 1;
}

function formValidation() {
    if (setHeaders() == 0) return 0;

    if (approvedExecutionTime == '') {
        showError('approvedExecutionTime', '#ff6666', "Please enter approved execution time.");
        return 0;
    } else showError('approvedExecutionTime', '', '');

    if (approvedExecutionTime < 0) {
        showError('approvedExecutionTime', '#ff6666', "Time can not be negative.");
        return 0;
    } else showError('approvedExecutionTime', '', '');

    // if (approvedExecutionTime == 0) {
    //     showError('approvedExecutionTime', '#ff6666', "Approved Time can not be zero.");
    //     return 0;
    // } else showError('approvedExecutionTime', '', '');

    if (reviewDate == '') {
        showError('reviewDateAndTime', '#ff6666', "Review Date cannot be Blank.");
        return 0;
    } else showError('reviewDateAndTime', '', '');

    if (noOfRating == 0) {
        showError('', '#ff6666', "Please Select Rating of Unit.");
        return 0;
    } else showError('', '', '');

    if (penaltyAmount < 0) {
        showError('', '#ff6666', "Penalty Amount Cannot be negative.");
        return 0;
    } else showError('', '', '');

    if (penaltyAmount == '') {
        penaltyAmount = '0';
    }
    return 1;
}

function makeArray() {
    commentsOfLecture = escapeSpecialCharacters(commentsOfLecture);
    commentsOfLecture = commentsOfLecture.replace("\n", " ");
    contentArray = [];
    var obj = {
        'assignmentId': assignmentId,
        'reviewId': reviewId,
        'unitNo': unitNo,
        "facultyId": facultyId,
        'facultyName': facultyName,
        'reviewDate': reviewDate,
        'noOfRating': noOfRating,
        'comments': commentsOfLecture,
        'penaltyAmount': penaltyAmount,
        'approvedExecutionTime': approvedExecutionTime,
        'payableAmount': payableAmount,
        'typeOfPayment': remunerationData[0]['typeofpayment']
    }
    contentArray.push(obj);
}

function updateReview(id) {
    document.getElementById('saveReview').disabled = true;
    // document.getElementById('saveAndPublishReview').disabled = true;
    var saveFlag = "editReview";
    if (id == 'saveReview') reviewStatus = 'UNDER REVIEW';
    else reviewStatus = 'COMPLETED';
    if (formValidation() == 0) {
        document.getElementById('saveReview').disabled = false;
        // document.getElementById('saveAndPublishReview').disabled = false;
        return;
    }
    if (compareOldValuesWithOld() == 0) {
        document.getElementById('saveReview').disabled = false;
        return;
    }
    if (makeArray() == 0) {
        document.getElementById('saveReview').disabled = false;
        return 0;
    }
    else {
        if (confirm("Are you sure you want to save Unit Review??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Lecture Review. Please wait...';
            document.getElementById('saveReview').disabled = true;
            // document.getElementById('saveAndPublishReview').disabled = true;
            $.post('updateAssignmentReview.php', {
                'saveFlag': saveFlag,
                'reviewStatus': reviewStatus,
                'contentArray': contentArray,
                'logStatement': statement
            }, function (data) {
                document.getElementById('successMessage').innerHTML = 'Lecture Review Saved Successfully.';
                if (data == 'ADD') alert("Review can't be updated.");
                // console.log(data);
            });
        }
        else {
            document.getElementById('saveReview').disabled = false;
            // document.getElementById('saveAndPublishReview').disabled = false;
        }
    }
}