<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';

$masterSemester = [];
$sql = "SELECT * FROM semester;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterSemester, $row);
    }
}

$masterSubjectName = [];
$sql2 = "SELECT * FROM subjects;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSubjectName, $row2);
    }
}

$masterAssignmentData = [];
$sql3 = "SELECT DISTINCT assignmentId,semester,subjectName FROM f_assignment WHERE assignmentStatus='PENDING'  AND facultyName NOT IN ('Not Selected')  ORDER BY assignmentId DESC;";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($masterAssignmentData, $row3);
    }
}

require '../../common/header.php';
require '../../common/navbar.php';
?>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/moment/moment.min.js"></script>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Pending Assignment Execution List</h3>
                            <br><br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Plan From To Date:</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control " id="assignmentDate" placeholder="Plan From To Date" onchange="filterOtherDropDown('assignmentDate');" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#assignmentDate">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Semester</label>
                                        <select class="form-control custom-select" id="semester" style="width: 100%;" onchange="filterOtherDropDown('semester');">
                                            <option disabled selected>SELECT SEMESTER</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Subject Name</label>
                                        <select class="form-control custom-select" id="subjectName" style="width: 100%;" onchange="filterOtherDropDown('subjectName');">
                                            <option disabled selected>SELECT SUBJECT</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Assignment Id</label>
                                        <select class="form-control custom-select" id="assignmentIdDrpodown" style="width: 100%;" onchange="filterOtherDropDown('assignment');">
                                            <option selected>SELECT ASSIGNMENT ID</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <input type="button" class="btn btn-primary mT27" value="Get List" id="generateDetails" />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <span id="savedData"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php require 'pendingAssignmentExecutionDetails.php' ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="pendingAssignmentExecution.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var masterSemester = <?php echo json_encode($masterSemester); ?>;
    var masterSubjectName = <?php echo json_encode($masterSubjectName); ?>;
    var masterAssignmentData = <?php echo json_encode($masterAssignmentData); ?>;
    $(function() {
        $('#assignmentDate').daterangepicker({
            autoApply: true,
            "alwaysShowCalendars": true,
            locale: {
                format: 'DD/MM/YYYY',
            },
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                    .endOf('month')
                ]
            },
        });
        $('#assignmentDate').val("");

        loadDataDropdown("semester", masterSemester);
        // loadDataDropdown("subjectName", masterSubjectName);
        // loadDataDropdown("assignmentIdDrpodown", masterAssignmentData);

        var startDateEndDate = '',
            tempSemester = '',
            tempSubjectName = '';

        $("#generateDetails").click(() => {
            startDateEndDate = document.getElementById("assignmentDate").value;
            tempSemester = getDropdownValue("semester").trim();
            tempSubjectName = getDropdownValue("subjectName").trim();

            document.getElementById('generateDetails').disabled = true
            document.getElementById("successMessage").innerHTML = "Please wait while we load the data....";
            $.post('pendingAssignmentExecutionDetails.php', {
                'startDateEndDate': startDateEndDate.split(" - "),
                'semester': tempSemester.trim(),
                'subjectName': tempSubjectName.trim(),
            }, function(data) {
                $('#paeDetails').html(data);
                document.getElementById("successMessage").innerHTML = "";
                document.getElementById('generateDetails').disabled = false;
            });
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("assignmentDate").value;
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[1]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                }

                selectedSemesterName = getSelectValues('', document.getElementById("semester")).trim();
                var rowSemesterName = data[2];

                if (selectedSemesterName != 'SELECT SEMESTER') {
                    inSemesterName = (selectedSemesterName.indexOf(rowSemesterName) !== -1) ? rowSemesterName :
                        false;
                } else inSemesterName = true;

                selectedSubjectName = getSelectValues('', document.getElementById("subjectName")).trim();
                var rowSubjectName = data[3];

                if (selectedSubjectName != 'SELECT SUBJECT') {
                    inSubjectName = (selectedSubjectName.indexOf(rowSubjectName) !== -1) ? rowSubjectName :
                        false;
                } else inSubjectName = true;

                selectedAssignmentID = getSelectValues('', document.getElementById("assignmentIdDrpodown"))
                    .trim();
                var rowAssignmentID = data[0];

                if (selectedAssignmentID != 'SELECT ASSIGNMENT ID') {
                    inAssignmentId = (selectedAssignmentID.indexOf(rowAssignmentID) !== -1) ? rowAssignmentID :
                        false;
                } else inAssignmentId = true;

                return inEmpStartingDateRange && inSemesterName && inSubjectName && inAssignmentId;

            }
        );
    });
</script>
<?php require '../../common/footer.php'; ?>