function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) result += opt.text;
        }
        if (flag == "multiple") {
            if (opt.selected) result += opt.text + "|";
        }
    }
    return result.trim();
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");
    else if (selectName == "assignmentIdDrpodown") dummyOptions(theSelect, options, "ASSIGNMENT ID");
    else if (selectName == "filterBatchCode") dummyOptions(theSelect, options, "BATCH");
    let tempArray = [];

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("assignmentIdDrpodown")) {
            options.value = options.text = results[i].assignmentId.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("filterBatchCode")) {
            options.text = results[i]['batchTitle'];
            options.value = results[i]['batchId'];
            theSelect.add(options);
        }
    }
    return;
}

function filterOtherDropDown(flag) {
    tempSubject = getSelectValues('multiple', document.getElementById("subjectName")).trim();
    tempSubjectArray = tempSubject.split('|');
    tempSubjectName = [];
    tempSessionCodeName = [];
    tempAssignmentId = [];
    newAssignmentIdArray = [];
    if (flag == "subjectName") {
        for (let i = 0; i < masterAssignmentData.length; i++) {
            for (let j = 0; j < tempSubjectArray.length; j++) {
                if (masterAssignmentData[i].subjectName == tempSubjectArray[j]) {
                    newAssignmentIdArray.push(obj = {
                        "assignmentId": masterAssignmentData[i].assignmentId.trim()
                    });
                }
            }
        }
        loadDataDropdown("assignmentIdDrpodown", newAssignmentIdArray);
    }
    var table = $('#example1').DataTable();
    table.draw();
}

function showIcon() {
    document.getElementById('dateIcon').hidden = true;
    document.getElementById('clearDate').hidden = false;
    document.getElementById('iconBackground').style.backgroundColor = '#ff6666';
}

function clearDate() {
    document.getElementById('assignmentDate').value = '';
    var element = document.getElementById('assignmentDate');
    var event = new Event('change');
    element.dispatchEvent(event);
    document.getElementById('dateIcon').hidden = false;
    document.getElementById('clearDate').hidden = true;
    document.getElementById('iconBackground').style.backgroundColor = '';
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

var startDateEndDate = '',
    tempSubjectName = '',
    tempBatchName = '',
    assignmentIdFilter = '';

$("#generateDetails").click(() => {
    startDateEndDate = document.getElementById("assignmentDate").value;
    tempSubjectName = getSelectValues('multiple', document.getElementById("subjectName")).trim().slice(0, -1);
    tempBatchName = getSelectValues('multiple', document.getElementById("filterBatchCode")).trim().slice(0, -1);
    assignmentIdFilter = getSelectValues('multiple', document.getElementById("assignmentIdDrpodown")).trim().slice(0, -1);
    flag = 'showDetails';

    if (startDateEndDate == '' && tempSubjectName == '' && tempBatchName == '' && assignmentIdFilter == '') {
        showError('','#ffc2b3','Select atlest 1 dropdown To generate the list.');
        return;
    } else showError('','','');

    document.getElementById('generateDetails').disabled = true;
    document.getElementById("successMessage").innerHTML = "Please wait while we load the data....";
    $.post('pendingAssignmentExecutionDetails.php', {
        'startDateEndDate': startDateEndDate.split(" - "),
        'subjectName': tempSubjectName.split('|'),
        'batchName': tempBatchName.split('|'),
        'assignmentIdFilter': assignmentIdFilter.split('|'),
        'flag': flag
    }, function (data) {
        $('#paeDetails').html(data);
        document.getElementById("successMessage").innerHTML = "";
        document.getElementById('generateDetails').disabled = false;
    });
});