function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    else if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");
    else if (selectName == "assignmentIdDrpodown") dummyOptions(theSelect, options, "ASSIGNMENT ID");
    let tempArray = [];

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("semester")) {
            options.value = options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("assignmentIdDrpodown")) {
            options.value = options.text = results[i].assignmentId.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function filterOtherDropDown(flag) {
    tempSemester = getSelectValues('', document.getElementById("semester")).trim();
    tempSubject = getSelectValues('', document.getElementById("subjectName")).trim();
    tempSubjectName = [];
    tempSessionCodeName = [];
    tempAssignmentId = [];
    newAssignmentIdArray = [];
    if (flag == "assignmentDate") {
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "semester") {
        loadDataDropdown("subjectName", []);
        loadDataDropdown("assignmentIdDrpodown", []);
        for (let i = 0; i < masterSubjectName.length; i++) {
            if (masterSubjectName[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": masterSubjectName[i].subjectId.trim(),
                    "subjectName": masterSubjectName[i].subjectName.trim()
                });
            }
            loadDataDropdown("subjectName", tempSubjectName);
        }
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester) {
                tempAssignmentId.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", tempAssignmentId);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "subjectName") {
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester && masterAssignmentData[i].subjectName == tempSubject) {
                newAssignmentIdArray.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", newAssignmentIdArray);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "assignment") {
        var table = $('#example1').DataTable();
        table.draw();
    }
}

function showDetails(lecId, id, lecSplitId) {
    encodedId = btoa(id);
    encodedLecId = btoa(lecId);
    encodedLecSplitId = btoa(lecSplitId);
    window.location.href = 'viewAssignmentExecution.php?aId=' + encodedId + "&lecId=" + encodedLecId + "&lSid=" + encodedLecSplitId;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    // document.getElementById('errorMessage').innerHTML = message;
}

function resetTableErrors() {
    const table = document.getElementById("tableBody");
    if (table.rows[0].cells[0].className != "dataTables_empty")
        for (let r = 0, n = table.rows.length; r < n; r++) {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        }
}

function checkTableContentIsNotEmpty() {
    resetTableErrors();
    const table = document.getElementById("tableBody");

    if (table.rows[0].cells[0].className != "dataTables_empty") {
        for (let r = 0, n = table.rows.length; r < n; r++) {

            // Lecture Date
            if (table.rows[r].cells[1].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Lecture Date.");
                return 0;
            } else
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

            // Lecture Date
            if (table.rows[r].cells[2].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Start Time.");
                return 0;
            } else
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

            // Lecture Date
            if (table.rows[r].cells[3].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter End Time.");
                return 0;
            } else
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        }
    }

    showError('', '', '');
    return 1;
}

function calculateDuration() {
    if (checkTableContentIsNotEmpty() == 0) return 0;
    grandTotalMin = 0;
    var table = document.getElementById("tableBody");
    for (let i = 0; i < table.rows.length; i++) {
        var totalMin = 0;
        sTime = document.getElementById("lectureStartTime" + i).value;
        eTime = document.getElementById("lectureEndTime" + i).value;

        if (sTime > eTime) {
            showError('lectureStartTime' + i, '#ff6666', "");
            showError('lectureEndTime' + i, '#ff6666', "Start Time cannot be greater than End Time.");
            return 0;
        } else {
            showError('lectureStartTime' + i, '', '');
            showError('lectureEndTime' + i, '', '');
        }

        sTime = sTime.split(':');
        eTime = eTime.split(':');

        var hours1 = parseInt(sTime[0], 10),
            hours2 = parseInt(eTime[0], 10),
            mins1 = parseInt(sTime[1], 10),
            mins2 = parseInt(eTime[1], 10);
        var hours = hours2 - hours1,
            mins = 0;

        if (hours < 0) hours = 24 + hours;

        if (mins2 >= mins1) {
            mins = mins2 - mins1;
        } else {
            mins = (mins2 + 60) - mins1;
            hours--;
        }

        if (hours > 0) {
            totalMin = 60 * hours;
        }
        totalMin = parseFloat(totalMin) + parseFloat(mins);
        $("#lectureDuration" + i).val(totalMin);
        grandTotalMin = parseFloat(grandTotalMin) + parseFloat(totalMin);
    }
    document.getElementById("totalHrs").innerHTML = grandTotalMin;
}

function addLectureDetailsRow(result, disFlag) {
    var mytable = document.getElementById("tableBody"),
        newRow,
        newCell;
    mytable.innerHTML = '';

    var currentIndex = 0;
    var currentIndex = mytable.rows.length;
    var newRow = document.createElement("tr");
    mytable.appendChild(newRow);

    if (result.length > 0) {
        lectureDate = result[0]['lectureDate'];
        lectureStartTime = result[0]['startTime'];
        lectureEndTime = result[0]['endTime'];
    }

    // index cell
    newCell = document.createElement("td");
    newCell.style.fontSize = "20px";
    newCell.innerHTML = currentIndex + 1;
    newRow.appendChild(newCell);

    // lecture date cell
    newCell = document.createElement("td");
    if (result.length > 0) var divMain = cDP(currentIndex, result[0]['lectureDate'], disFlag);
    else var divMain = cDP(currentIndex, '', false);

    newCell.appendChild(divMain);
    newRow.appendChild(newCell);

    // lecture start time cell
    newCell = document.createElement("td");
    let startTime = document.createElement("div");
    startTime.className = "form-group";
    let inputSt = document.createElement("input");
    inputSt.className = "form-control";
    inputSt.type = 'time';
    inputSt.disabled = disFlag;
    inputSt.id = "lectureStartTime" + currentIndex;
    inputSt.setAttribute("placeholder", "Lecture Start Time*");
    startTime.append(inputSt);
    newCell.appendChild(startTime);
    newRow.appendChild(newCell);

    // lecture End time cell
    newCell = document.createElement("td");
    let endTime = document.createElement("div");
    endTime.className = "form-group";
    let inputEt = document.createElement("input");
    inputEt.className = "form-control";
    inputEt.type = 'time';
    inputEt.disabled = disFlag;
    inputEt.id = "lectureEndTime" + currentIndex;
    inputEt.setAttribute("placeholder", "Lecture End Time*");
    endTime.append(inputEt);
    newCell.appendChild(endTime);
    newRow.appendChild(newCell);

    // lectre duration cell
    newCell = document.createElement("td");
    let lDuration = document.createElement("div");
    lDuration.className = "form-group";
    let inputDt = document.createElement("input");
    inputDt.className = "form-control tAC";
    inputDt.id = "lectureDuration" + currentIndex;
    inputDt.setAttribute("placeholder", "Lecture Duration");
    inputDt.disabled = true;
    lDuration.append(inputDt);
    newCell.appendChild(lDuration);
    newRow.appendChild(newCell);

    $('#lectureDate' + currentIndex).datetimepicker({
        format: 'DD/MM/YYYY',
        dateFormat: 'DD/MM/YYYY'
    });
    $('#lectureStartTime' + currentIndex).datetimepicker({
        format: 'H:m a',
        datepicker: false,
    });
    $('#lectureEndTime' + currentIndex).datetimepicker({
        format: 'H:m a',
        datepicker: false,
    });
    $("#lectureStartTime" + currentIndex).on('change keyup paste', function () {
        calculateDuration();
    });

    $("#lectureEndTime" + currentIndex).on('change keyup paste', function () {
        calculateDuration();
    });

    if (result.length > 0) {
        document.getElementById("lectureStartTime" + currentIndex).value = lectureStartTime;
        document.getElementById("lectureEndTime" + currentIndex).value = lectureEndTime;
        if (lectureStartTime != '' && lectureEndTime != '') calculateDuration();
    }
    resetTableErrors();
}