<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';

$masterSubjectName = [];
$sql2 = "SELECT * FROM subjects ORDER BY subjectName;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSubjectName, $row2);
    }
}

$masterAssignmentData = [];
$sql3 = "SELECT DISTINCT assignmentId,semester,subjectName FROM f_assignment WHERE assignmentStatus='PENDING'  AND facultyName NOT IN ('Not Selected')  ORDER BY assignmentId DESC;";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($masterAssignmentData, $row3);
    }
}

$masterBatchDetails = [];
$sql = "SELECT * FROM batchmaster ORDER BY batchId;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterBatchDetails, $row);
    }
}

require '../../common/navbar.php';
?>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/moment/moment.min.js"></script>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Manage All Assignment Execution List</h3>
                            <br><br>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Execution From To Date:</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control " id="assignmentDate" placeholder="Plan From To Date" onchange="filterOtherDropDown('assignmentDate');" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#assignmentDate">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>BATCH</label>
                                        <select class="select2" multiple="multiple" id="filterBatchCode" style="width: 100%;" onchange="filterOtherDropDown('batch');" data-placeholder="SELECT BATCH">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Subject Name</label>
                                        <select class="Select2" multiple="multiple" id="subjectName" style="width: 100%;" onchange="filterOtherDropDown('subjectName');" data-placeholder="SELECT SUBJECT">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Assignment Id</label>
                                        <select class="Select2" multiple="multiple" id="assignmentIdDrpodown" style="width: 100%;" onchange="filterOtherDropDown('assignment');" data-placeholder="SELECT ASSIGNMENT ID">
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 tAC">
                                    <div class="form-group">
                                        <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                        </p>
                                        <span id="savedData"></span>
                                        <input type="button" class="btn btn-primary" value="Get List" id="generateDetails" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php require 'manageAssignmentExecutionDetails.php' ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="manageAllAssignmentExecution.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var masterSubjectName = <?php echo json_encode($masterSubjectName); ?>;
    var masterAssignmentData = <?php echo json_encode($masterAssignmentData); ?>;
    var masterBatchDetails = <?php echo json_encode($masterBatchDetails) ?>;

    $(function() {
        $('#assignmentDate').daterangepicker({
            autoApply: true,
            "alwaysShowCalendars": true,
            locale: {
                format: 'DD/MM/YYYY',
            },
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                    .endOf('month')
                ]
            },
        });
        $('#assignmentDate').val("");
        $('.select2').select2();

        loadDataDropdown("subjectName", masterSubjectName);
        loadDataDropdown("filterBatchCode", masterBatchDetails);

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("assignmentDate").value;
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    if(data[2] == '') data[2] = '00/00/0000';
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[2]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ? (moment(empStartDate).isSameOrAfter(dateRangeStart) && moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                }

                selectedBatch = getSelectValues('', document.getElementById("filterBatchCode")).trim();
                selectedSubjectName = getSelectValues('', document.getElementById("subjectName")).trim();
                selectedAssignmentID = getSelectValues('', document.getElementById("assignmentIdDrpodown")).trim();

                var rowSubjectName = data[4];
                var rowAssignmentID = data[0];
                var rowBatch = data[3];

                if (selectedSubjectName != '') {
                    inSubjectName = (selectedSubjectName.indexOf(rowSubjectName) !== -1) ? rowSubjectName : false;
                } else inSubjectName = true;

                if (selectedAssignmentID != '') {
                    inAssignmentId = (selectedAssignmentID.indexOf(rowAssignmentID) !== -1) ? rowAssignmentID :false;
                } else inAssignmentId = true;

                if (selectedBatch != '') {
                    inBatch = (selectedBatch.indexOf(rowBatch) !== -1) ? rowBatch :false;
                } else inBatch = true;
                return inEmpStartingDateRange && inSubjectName && inAssignmentId && inBatch;
            }
        );
    });
</script>
<?php require '../../common/footer.php'; ?>