var assignmentId = '',
    semester = '',
    academicYear = '',
    subjectName = '',
    subjectId = '',
    sessionPlanId = '',
    batchCode = '',
    batchTitle = '',
    batchId = '',
    fromDateEndDate = '';
var facultyUnitArray = [];
var remunerationArray = [{ 'Flag': "Add" }];

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = true;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
        if (flag == "value") {
            if (opt.selected) {
                result += opt.value;
            }
        }
        if (flag == "MultipleValue") {
            if (opt.selected) {
                result += opt.value + "|";
            }
        }
    }
    return result.trim();
}

function loadDataDropdown(selectName, results, selectedValue) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    else if (selectName == "subjectNames") dummyOptions(theSelect, options, "SUBJECT");
    else if (selectName == "sessionPlan") dummyOptions(theSelect, options, "SESSION PLAN CODE");
    else if (selectName.includes("facultyName")) dummyOptions(theSelect, options, "FACULTY");
    else if (selectName.includes("paymentOptions")) dummyOptions(theSelect, options, "PAYMENT METHOD");
    else if (selectName.includes("academicYear")) dummyOptions(theSelect, options, "ACADEMIC YEAR");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("semester")) {
            options.value = results[i].semester.toUpperCase();
            options.text = results[i].semester.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectNames")) {
            options.value = results[i].subjectId.toUpperCase();
            options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("sessionPlan")) {
            options.value = results[i].toUpperCase();
            options.text = results[i].toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("facultyName")) {
            if (results[i].facultyName != 'Not Selected') {
                options.value = results[i].facultyId.trim();
                options.text = results[i].facultyName.trim().toUpperCase();
                theSelect.add(options);
            }
        } else if (selectName.includes("academicYear")) {
            academicYear1 = results[i].firstAcademicYear.split("-");
            academicYear2 = results[i].thirdAcademicYear.split("-");
            academicYear = academicYear1[0] + '-' + academicYear2[1];
            options.value = options.text = academicYear;
            theSelect.add(options);
        } else if (selectName.includes("paymentOptions")) {
            options.value = options.text = results[i].value.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("batchCode")) {
            options.value = results[i].batchId.toUpperCase();
            options.text = results[i].batchTitle.toUpperCase();
            theSelect.add(options);
        }
        if (options.text == selectedValue) options.selected = true;
    }
    return;
}

function filterOtherDropDown(flag) {
    tempSemester = getSelectValues('value', document.getElementById("semester")).trim();
    selectedAcademicYear = document.getElementById('academicYear').value.trim();
    tempSubjectName = [];
    tempSessionCodeName = [];
    filteredBatchListArray = []
    if (flag == 'semester') {
        loadDataDropdown("subjectNames", []);
        loadDataDropdown("sessionPlan", []);
        for (let i = 0; i < subjectNames.length; i++) {
            if (subjectNames[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": subjectNames[i].subjectId,
                    "subjectName": subjectNames[i].subjectName
                });
            }
            loadDataDropdown("subjectNames", tempSubjectName);
        }
    } else if (flag == "subject") {
        tempSessionPlanNo = '';
        tempSemesterData = getSelectValues('', document.getElementById("semester")).trim();
        tempSubjectData = getSelectValues('', document.getElementById("subjectNames")).trim();
        for (let k = 0; k < sessionCodeList.length; k++) {
            if (sessionCodeList[k].semester == tempSemesterData &&
                sessionCodeList[k].subjectName == tempSubjectData && (tempSessionPlanNo == '' || tempSessionPlanNo != sessionCodeList[k].sessionPlanId))
                tempSessionCodeName.push(sessionCodeList[k].sessionPlanId);
            tempSessionPlanNo = sessionCodeList[k].sessionPlanId;
        }
        loadDataDropdown("sessionPlan", tempSessionCodeName);
    } else if (flag == "aYear") {
        loadDataDropdown("batchCode", []);
        for (let j = 0; j < batchList.length; j++) {
            if (batchList[j].academicYear == selectedAcademicYear) {
                filteredBatchListArray.push(obj = {
                    "batchId": batchList[j].batchId,
                    "batchTitle": batchList[j].batchTitle
                });
            }
        }
        loadDataDropdown("batchCode", filteredBatchListArray);
    }
}

function addTableRowView(masterList, flag, flag2) {
    var mytable = document.getElementById("documentTable"),
        newRow,
        newCell;
    var tempUnit = '';
    var totalMin = 0;
    for (var i = 0; n = masterList.length, n > i; i++) {
        var newRow = document.createElement("tr");
        mytable.appendChild(newRow);

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].tableunitno;
        newRow.appendChild(newCell);
        if (flag == 'view') {
            newCell = document.createElement("td");
            newCell.innerHTML = masterList[i].planDate;
            newRow.appendChild(newCell);
        } else if (flag == 'create') {
            newCell = document.createElement("td");
            var dateInut = document.createElement("input");
            dateInut.setAttribute("class", "form-control");
            dateInut.setAttribute("id", "planDate" + (i + 1));
            dateInut.setAttribute("type", "text");
            dateInut.setAttribute("placeholder", "Enter Date");
            newCell.appendChild(dateInut);
            newRow.appendChild(newCell);
            if (flag2 == 'Edit') $("#planDate" + (i + 1)).val(masterList[i].planDate);
            $("#planDate" + (i + 1)).datepicker({
                format: 'dd/mm/yyyy',
                autoclose: true,
            });
            if (flag2 == 'Edit') {
                if (masterList[i].noOfSplits != '') dateInut.setAttribute("disabled", "disabled");
            }
        }

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].tableTopicCovered;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].noOfSubTopic;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var subTopicAndHours = document.createElement("ul");
        subTopicAndHours.setAttribute("class", "mT10 p0");

        if (masterList[i].noOfSubTopic > 0) {
            var tempSplit = masterList[i].subTopic.split("|");
            var tempHoursSplit = masterList[i].subTopicMinutes.split("|");

            for (var j = 0; n = masterList[i].noOfSubTopic, n > j; j++) {
                var li = document.createElement("li");

                li.setAttribute("class", "mT10");
                li.style = "display: -webkit-box";

                var subTopicValue = document.createElement("div");
                subTopicValue.setAttribute("id", "subTopicValue" + j);
                subTopicValue.innerHTML = tempSplit[j];
                subTopicValue.style = "width:70%";

                var subTopichoursValue = document.createElement("div");
                subTopichoursValue.setAttribute("id", "subTopicHours" + j);
                subTopichoursValue.innerHTML = tempHoursSplit[j];
                subTopichoursValue.style = "width:30%";

                totalMin = parseFloat(totalMin) + parseFloat(tempHoursSplit[j]);


                li.innerHTML += subTopicValue.outerHTML + subTopichoursValue.outerHTML;
                subTopicAndHours.appendChild(li);
                newCell.appendChild(subTopicAndHours);
                newRow.appendChild(newCell);
            }
        }

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].objective;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var subThePraPro = document.createElement("ul");
        subThePraPro.style = "padding:0px;";

        newCell = document.createElement("td");
        newCell.innerHTML = masterList[i].totalMinutes;
        newRow.appendChild(newCell);

        if (flag == "create") {
            newCell = document.createElement("td");
            if (tempUnit == '' || tempUnit != masterList[i].tableunitno) {

                var facultyListSelect = document.createElement("select");
                facultyListSelect.setAttribute("class", "form-control custom-select mT10");
                facultyListSelect.setAttribute("onchange", "addFacultyToTable(this);");
                facultyListSelect.setAttribute("id", "facultyName" + (i + 1));
                facultyListSelect.style.width = "100%";
                newCell.appendChild(facultyListSelect);
                newRow.appendChild(newCell);
                if (flag2 != 'Edit') loadDataDropdown("facultyName" + (i + 1), facultyList, '');
                else if (flag2 == "Edit") {
                    loadDataDropdown("facultyName" + (i + 1), facultyList, (masterList[i].facultyName).toUpperCase());
                }
                if (flag2 == 'Edit') {
                    if (masterList[i].noOfSplits != '') facultyListSelect.setAttribute("disabled", "disabled");
                }
            } else newRow.appendChild(newCell);
        } else if (flag == "view") {
            newCell = document.createElement("td");
            newCell.innerHTML = masterList[i].facultyName;
            newRow.appendChild(newCell);
        }

        tempUnit = masterList[i].tableunitno;
    }
    document.getElementById("totalHours").innerHTML = "Total Mins </ br>" + totalMin;
}

function deleteRow(unique) {
    var table2 = document.getElementById("facultyPaymentTableBody");
    for (var i = 0; i < table2.rows.length; i++) {
        if (unique.indexOf(table2.rows[i].cells[0].innerHTML) == -1) table2.deleteRow(i);
    }
    for (var i = 0; i < table2.rows.length; i++) {
        for (var j = 0; j < unique.length; j++) {
            if (table2.rows[i].cells[0].innerHTML == unique[j]) {
                table2.rows[i].cells[2].getElementsByTagName("select")[0].id = "paymentOptions" + (i + 1);
                table2.rows[i].cells[3].getElementsByTagName("input")[0].id = "paymentPerHrs" + (i + 1);
                table2.rows[i].cells[4].getElementsByTagName("input")[0].id = "totalAmount" + (i + 1);
            }
        }
    }
    calculateRowsTotal();
}

function calculateTotalMin(ul) {
    var tableUlRow = ul;
    var TotalMin = 0;
    var len = tableUlRow.getElementsByTagName("li").length;
    var li = tableUlRow.getElementsByTagName("li");
    if (len > 0) {
        for (var k = 0; k < len; k++) {
            var inputHours = li[k].getElementsByTagName("div")[1].innerHTML;
            if (inputHours == '') inputHours = 0;
            TotalMin += parseInt(inputHours);
        }
    }
    return TotalMin;
}

var paymentOptions = [{
    'value': 'HOURLY BASIS'
},
{
    'value': 'LUMPSUM'
}
];

function calculateRowsTotal() {
    var table2 = document.getElementById("facultyPaymentTableBody");

    for (var i = 0; i < table2.rows.length; i++) {
        var tempOption = table2.rows[i].cells[2].getElementsByTagName("select")[0];
        if (tempOption[tempOption.selectedIndex].text == "HOURLY BASIS" &&
            table2.rows[i].cells[3].innerHTML != '') {
            var tempHours = parseFloat(calculateHrs(table2.rows[i].cells[1].innerHTML)).toFixed(2);
            // added
            var tempTimeArray = tempHours.split(".");
            var tempHrs = tempTimeArray[0];
            var tempMins = tempTimeArray[1];
            // end
            var tempPerHours = table2.rows[i].cells[3].getElementsByTagName("input")[0].value;
            table2.rows[i].cells[4].getElementsByTagName("input")[0].value = parseFloat(parseInt(tempHrs * tempPerHours) + parseInt(tempMins * (tempPerHours / 60))).toFixed(2);
        }
    }
}

function calculateHrs(value) {
    let calculateHrs = parseInt(parseFloat(value) / 60);
    let calculatetotal = parseFloat(0.6 * (parseFloat(parseFloat(value) / 60) - parseInt(parseFloat(value) / 60)));
    return (parseFloat(calculateHrs) + parseFloat(calculatetotal)).toFixed(2);
}

function addFacultyToTable(rows, value) {
    var table = document.getElementById("documentTable"),
        newRow,
        newCell;
    var table2 = document.getElementById("facultyPaymentTableBody");
    var currentIndex = table2.rows.length;
    var masterRowId = currentIndex + 1;;

    //check if the faculty is present 
    tempFacultyName = getSelectValues('', document.getElementById(rows.id));
    tempFacultyId = getSelectValues('value', document.getElementById(rows.id));
    var checkFacultyName = 0;
    for (let i = 0; i < table2.rows.length; i++) {
        if (table2.rows[i].cells[0].innerHTML == tempFacultyName) checkFacultyName = 1;
    }
    //make all faculty array 
    var tableArray = [];
    var tableUnit = '';
    var tempTableUnit = '';
    var tempTableFacultyName = '';
    var totalMin = 0;
    for (let i = 0; i < table.rows.length; i++) {
        if (tableUnit == '') {
            tempOptions = table.rows[i].cells[7].getElementsByTagName("select")[0];
            tempText = tempOptions[tempOptions.selectedIndex].text;
            if (tempText != "Select Faculty") {
                tempTableUnit = table.rows[i].cells[0].innerHTML;
                tempTableFacultyName = tempText;
                totalMin = calculateTotalMin(table.rows[i].cells[4].getElementsByTagName("ul")[0]);
            }
            tableUnit = table.rows[i].cells[0].innerHTML;
        } else if (tableUnit == table.rows[i].cells[0].innerHTML) {
            tempTableUnit = table.rows[i].cells[0].innerHTML;
            totalMin = calculateTotalMin(table.rows[i].cells[4].getElementsByTagName("ul")[0]);
            tableUnit = table.rows[i].cells[0].innerHTML;
        } else if (tableUnit != '' && tableUnit != table.rows[i].cells[0].innerHTML) {
            tempOptions = table.rows[i].cells[7].getElementsByTagName("select")[0];
            tempText = tempOptions[tempOptions.selectedIndex].text;
            if (tempText != "Select Faculty") {
                tempTableUnit = table.rows[i].cells[0].innerHTML;
                tempTableFacultyName = tempText;
                totalMin = calculateTotalMin(table.rows[i].cells[4].getElementsByTagName("ul")[0]);
            } else if (tempText == "Select Faculty") tempTableFacultyName = '';
            tableUnit = table.rows[i].cells[0].innerHTML;
        }

        var obj = {
            facultyName: tempTableFacultyName,
            facultyUnit: tempTableUnit,
            totalMin: totalMin,
        };
        if (tempTableFacultyName != '') {
            tableArray.push(obj);
        }

    }
    tempArray = [];
    for (let i = 0; i < tableArray.length; i++) {
        tempArray.push(tableArray[i].facultyName);
    }
    //faculty name uniquely sort 
    let unique = tempArray.filter((item, i, ar) => ar.indexOf(item) === i);
    //calculate total hours of all faculty using faculty name 
    var tempMin = 0;
    tableNewArray = [];
    for (let i = 0; i < unique.length; i++) {
        tempMin = 0;
        for (let j = 0; j < tableArray.length; j++) {
            if (tableArray[j].facultyName == unique[i]) {
                // tempMin = parseFloat(parseFloat(tempMin) + parseFloat(tableArray[j].totalMin)).toFixed(2);
                tempMin = parseFloat(tempMin) + parseFloat(tableArray[j].totalMin);
            }
        }
        var obj = {
            facultyName: unique[i],
            // totalHours: parseFloat(calculateHrs(tempMin)).toFixed(2),
            totalMinutes: tempMin,
        };
        tableNewArray.push(obj);
    }
    //if faculty not present than add faculty  to the table
    if (checkFacultyName == 0 && tempFacultyName != "Select Faculty") {
        var newRow = document.createElement("tr");
        table2.appendChild(newRow);

        newCell = document.createElement("td");
        newCell.id = tempFacultyId;
        newCell.innerText = tempFacultyName;
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        newCell.innerText = "--";
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var select = document.createElement("select");
        select.setAttribute("class", "form-control custom-select");
        select.setAttribute("onchange", "checkPaymentOptions(this)");
        select.setAttribute("id", "paymentOptions" + masterRowId);
        newCell.appendChild(select);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var input = document.createElement("input");
        input.setAttribute("type", "number");
        input.setAttribute("class", "form-control");
        input.setAttribute("id", "paymentPerHrs" + masterRowId);
        input.setAttribute("onchange", "calculateRowsTotal()");
        input.setAttribute("placeholder", "Enter Amount Per Hrs");
        input.disabled = true;
        newCell.appendChild(input);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var input = document.createElement("input");
        input.setAttribute("type", "number");
        input.setAttribute("class", "form-control");
        input.setAttribute("placeholder", "Enter Amount");
        input.setAttribute("id", "totalAmount" + masterRowId);
        input.disabled = true;
        newCell.appendChild(input);
        newRow.appendChild(newCell);

        loadDataDropdown("paymentOptions" + masterRowId, paymentOptions);
    }
    //insert new total hrs value 

    for (var i = 0; i < table2.rows.length; i++) {
        for (j = 0; j < tableNewArray.length; j++) {
            if (table2.rows[i].cells[0].innerHTML == tableNewArray[j].facultyName)
                table2.rows[i].cells[1].innerHTML = tableNewArray[j].totalMinutes;
        }
    }
    //delete excess row faculty
    deleteRow(unique);
}

function checkPaymentOptions(rows) {
    tempText = rows.id
    var rowNo = tempText.split("paymentOptions");
    var tempOption = getSelectValues('', document.getElementById(tempText));
    if (tempOption == "HOURLY BASIS") {
        document.getElementById("paymentPerHrs" + rowNo[1]).disabled = false;
        document.getElementById("paymentPerHrs" + rowNo[1]).value = '';
        document.getElementById("totalAmount" + rowNo[1]).disabled = true;
        document.getElementById("totalAmount" + rowNo[1]).value = '';
    } else if (tempOption == "LUMPSUM") {
        document.getElementById("paymentPerHrs" + rowNo[1]).disabled = true;
        document.getElementById("paymentPerHrs" + rowNo[1]).value = '';
        document.getElementById("totalAmount" + rowNo[1]).disabled = false;
        document.getElementById("totalAmount" + rowNo[1]).value = '';
    }
}

function setHeaders() {
    assignmentId = '';
    semester = '';
    academicYear = '';
    subjectId = '';
    subjectName = '';
    sessionPlanId = '';
    batchCode = '';
    batchTitle = '';
    batchId = '';
    fromDateEndDate = '';
    facultyUnitArray = [];
    remunerationArray = [{ 'Flag': "Add" }];

    assignmentId = document.getElementById('assignmentId').value.trim();
    semester = getSelectValues('', document.getElementById("semester")).trim();
    subjectName = getSelectValues('', document.getElementById("subjectNames")).trim();
    subjectId = document.getElementById("subjectNames").value.trim();
    sessionPlanId = getSelectValues('', document.getElementById("sessionPlan")).trim();
    fromDateEndDate = document.getElementById("assignmentDate").value;
    academicYear = getSelectValues('', document.getElementById("academicYear")).trim();
    batchId = getSelectValues('MultipleValue', document.getElementById("batchCode")).slice(0, -1);
    batchTitle = getSelectValues('multiple', document.getElementById("batchCode")).slice(0, -1);
    return 1;
}

function formValidation() {
    if (setHeaders() == 0) return 0;

    if (semester == 'SELECT SEMESTER') {
        showError('semester', '#ff6666', "Select Semester.");
        return 0;
    } else showError('semester', '', '');

    if (subjectName == 'SELECT SUBJECT') {
        showError('subjectNames', '#ff6666', "Select Subject.");
        return 0;
    } else showError('subjectNames', '', '');

    if (sessionPlanId == 'SELECT SESSION PLAN CODE') {
        showError('sessionPlan', '#ff6666', "Select Session plan code.");
        return 0;
    } else showError('sessionPlan', '', '');

    if (fromDateEndDate == '') {
        showError('assignmentDate', '#ff6666', "Select Assignment Date.");
        return 0;
    } else showError('assignmentDate', '', '');

    if (academicYear == 'SELECT ACADEMIC YEAR') {
        showError('academicYear', '#ff6666', "Select Academic Year.");
        return 0;
    } else showError('academicYear', '', '');

    if (batchTitle == '') {
        showError('batchCode', '#ff6666', "Select Batch.");
        return 0;
    } else showError('batchCode', '', '');

    if (tableValidation() == 0) return 0;
    if (tableValidation2() == 0) return 0;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"")
    return output;
}

function tableValidation() {
    var table = document.getElementById("documentTable");
    facultyUnitArray = [];
    var tableUnit = '';
    var tempTableFacultyName = '';
    var tempTableFacultyId = '';
    for (var r = 0, n = table.rows.length; r < n; r++) {

        var tempOptions;
        if (tableUnit == '') {
            tempOptions = table.rows[r].cells[7].getElementsByTagName("select")[0];
            var tempText = tempOptions[tempOptions.selectedIndex].text;
            var tempFacultyId = tempOptions[tempOptions.selectedIndex].value;
            if (tempText != "SELECT FACULTY") {
                tempTableFacultyName = tempText;
                tempTableFacultyId = tempFacultyId;
            } else if (tempText == "SELECT FACULTY") {
                tempTableFacultyId = '';
                tempTableFacultyName = 'Not Selected';
            }
            tableUnit = table.rows[r].cells[0].innerHTML;
        } else if (tableUnit == table.rows[r].cells[0].innerHTML) {
            tableUnit = table.rows[r].cells[0].innerHTML;
        } else if (tableUnit != '' && tableUnit != table.rows[r].cells[0].innerHTML) {
            tempOptions = table.rows[r].cells[7].getElementsByTagName("select")[0];
            tempText = tempOptions[tempOptions.selectedIndex].text;
            var tempFacultyId = tempOptions[tempOptions.selectedIndex].value;
            if (tempText != "SELECT FACULTY") {
                tempTableFacultyName = tempText;
                tempTableFacultyId = tempFacultyId;
            } else if (tempText == "SELECT FACULTY") {
                tempTableFacultyId = '';
                tempTableFacultyName = 'Not Selected';
            }
            tableUnit = table.rows[r].cells[0].innerHTML;
        }
        var tableUnitTemp = table.rows[r].cells[0].innerHTML;
        var tableDate = table.rows[r].cells[1].children[0].value;
        if (tableDate == '') {
            showError('', '#ff6666', "Select Plan Date.");
            table.rows[r].cells[1].children[0].style.backgroundColor = "#ff6666";
            return 0;
        } else {
            table.rows[r].cells[1].children[0].style.backgroundColor = "";
            showError('', '', '');
        }
        var tableTopicCovered = table.rows[r].cells[2].innerHTML;
        var tableTotalNoOfSubTopic = table.rows[r].cells[3].innerHTML;
        var tableSubTopic = '',
            tableSubTopicHours = '';
        var tableUiRow = table.rows[r].cells[4].getElementsByTagName("ul")[0];
        var lim = tableUiRow.getElementsByTagName("li").length;
        for (let i = 0; i < lim; i++) {
            tableSubTopic = tableSubTopic + tableUiRow.getElementsByTagName("li")[i].getElementsByTagName("div")[0].innerHTML + "|";
            tableSubTopicHours = tableSubTopicHours + tableUiRow.getElementsByTagName("li")[i].getElementsByTagName("div")[1].innerHTML + "|";
        }
        var tableObjective = table.rows[r].cells[5].innerHTML;
        var tabletotalNoOfMinutes = table.rows[r].cells[6].innerHTML;
        tableTopicCovered = escapeSpecialCharacters(tableTopicCovered);
        tableSubTopic = escapeSpecialCharacters(tableSubTopic.slice(0, -1));
        tableObjective = escapeSpecialCharacters(tableObjective);
        var obj = {
            tableUnitNo: tableUnitTemp,
            tableDate: tableDate,
            tableTopicCovered: tableTopicCovered,
            tableTotalNoOfSubTopic: tableTotalNoOfSubTopic,
            tableSubTopic: tableSubTopic,
            tableSubTopicHours: tableSubTopicHours.slice(0, -1),
            tableObjective: tableObjective,
            tabletotalNoOfMinutes: tabletotalNoOfMinutes,
            tableFacultyId: tempTableFacultyId,
            tableFacultyName: tempTableFacultyName,
        };
        facultyUnitArray.push(obj);
    }
    return 1;
}

function tableValidation2() {
    var table = document.getElementById("facultyPaymentTableBody");
    remunerationArray = [{ 'Flag': "Add" }];
    for (var r = 0, n = table.rows.length; r < n; r++) {
        var tableFacultyId = table.rows[r].cells[0].id;
        var tableFacultyName = table.rows[r].cells[0].innerHTML;
        var tableTotalHours = table.rows[r].cells[1].innerHTML;
        var tempTypeOFPayment = table.rows[r].cells[2].getElementsByTagName("select")[0];
        var tableTypeofPayment = tempTypeOFPayment[tempTypeOFPayment.selectedIndex].text;
        var tablePerHrs = table.rows[r].cells[3].getElementsByTagName("input")[0].value;
        var tableTotalAmount = table.rows[r].cells[4].getElementsByTagName("input")[0].value;

        if (tableTypeofPayment == "SELECT PAYMENT METHOD") {
            showError('paymentOptions' + (r + 1), '#ff6666', "Select valid Payment Option.");
            return 0;
        } else showError('paymentOptions' + (r + 1), '', "");

        if (tableTypeofPayment == "HOURLY BASIS" && tablePerHrs == '') {
            showError('paymentPerHrs' + (r + 1), '#ff6666', "Per Hour Amount cannot be blank.");
            return 0;
        } else showError('paymentPerHrs' + (r + 1), '', "");

        if (tableTypeofPayment == "HOURLY BASIS" && parseFloat(tablePerHrs) < 0) {
            showError('paymentPerHrs' + (r + 1), '#ff6666', "Per Hour Amount cannot be negtive or zero.");
            return 0;
        } else showError('paymentPerHrs' + (r + 1), '', "");

        if (tableTypeofPayment == "LUMPSUM" && tableTotalAmount == '') {
            showError('totalAmount' + (r + 1), '#ff6666', "Total Amount cannot be blank.");
            return 0;
        } else showError('totalAmount' + (r + 1), '', "");

        if (tableTypeofPayment == "LUMPSUM" && parseFloat(tableTotalAmount) < 0) {
            showError('totalAmount' + (r + 1), '#ff6666', "Total Amount cannot be negtive or zero.");
            return 0;
        } else showError('totalAmount' + (r + 1), '', "");

        var obj = {
            tableFacultyId: tableFacultyId,
            tableFacultyName: tableFacultyName,
            tableTotalHours: tableTotalHours,
            tableTypeofPayment: tableTypeofPayment,
            tablePerHrs: tablePerHrs,
            tableTotalAmount: tableTotalAmount,
            // tableCheckBox: tableCheckBox,
        };
        remunerationArray.push(obj);
    }
    if (remunerationArray.length == 1)
        remunerationArray = [{ 'Flag': "Blank" }];
    return 1;
}

function saveAssignment() {
    document.getElementById("saveButton").disabled = true;
    var saveFlag = "SAVEFLAG";
    if (formValidation() == 0) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    if (checkOnline() == false) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    else {
        if (confirm("Are you sure you want to save Assignment ??? ")) {
            document.getElementById("saveButton").disabled = true;
            document.getElementById('successMessage').innerHTML = 'Saving Assignment... Please wait...';
            $.post('saveCreateAssignment.php', {
                'saveFlag': saveFlag,
                'assignmentId': assignmentId,
                'semester': semester,
                'subjectName': subjectName,
                'subjectId': subjectId,
                'academicYear': academicYear,
                'batchTitle': batchTitle,
                'batchId': batchId,
                'sessionPlanId': sessionPlanId,
                'fromDateEndDate': fromDateEndDate,
                'tableContent': facultyUnitArray,
                'remunerationTable': remunerationArray,
            }, function (data) {
                console.log(data);
                document.getElementById('successMessage').innerHTML = 'Assignment Saved Successfully. Please wait. The page will get auto-refresh...';
                location.reload();
            });
        }
        else document.getElementById("saveButton").disabled = false;
    }
}