<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
$studentId = '';
$encodedKey_studentId = base64_encode('studentId');
if (isset($_GET[$encodedKey_studentId])) {
    $studentId = base64_decode($_GET[$encodedKey_studentId]);
}

$studentDetails = [];
$sql    = "SELECT * FROM loginstudents WHERE admissionStatus='CONFIRMED' AND studentId = '$studentId'; ";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($studentDetails, $row);
    }
}
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <div class="row">
                                <div class="col-md-7">
                                    <h3 class="card-title">1. Personal Information</h3>
                                </div>
                                <label class="pdTop">Student Status:</label>
                                <div class="col-md-2">
                                    <select class="form-control custom-select custom-select1" id="studentStatus" value='<?php echo $studentDetails[0]['studentStatus'] ?>'>
                                        <option>SELECT STATUS</option>
                                        <option value="ACTIVE">ACTIVE</option>
                                        <option value="BLOCKED">BLOCKED</option>
                                    </select>
                                </div>
                                <div class="col-md-1">
                                    <input type="button" class="btn btn-primary" value="UPDATE" onclick="updateStudentStatus()" id="updateButton" style="padding: 0.20rem 1.00rem;" />
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-7">
                                </div>
                                <div class="col-md-4 pT-1">
                                    <p id='statusSuccessMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                    </p>
                                    <p id='statusErrorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <form role="form">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <label>Student Id</label>
                                            <input type="text" class="form-control" id="studentId" value="<?php echo $studentDetails[0]["studentId"]; ?>" disabled>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>First Name</label>
                                            <input type="text" value="<?php echo $studentDetails[0]["firstname"] ?>" class="form-control" id="firstName" placeholder="" disabled>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Middle Name</label>
                                            <input type="text" value="<?php echo $studentDetails[0]["middleName"] ?>" class="form-control" id="middleName" placeholder="" disabled>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label>Last Name</label>
                                            <input type="text" value="<?php echo $studentDetails[0]["lastname"] ?>" class="form-control" id="lastName" placeholder="" disabled>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label>Date Of Birth</label>
                                        <div class="input-group my-colorpicker2">
                                            <input type="date" class="form-control" id="dateOfBirth" value="<?php echo $studentDetails[0]['dateOfBirth'] ?>" onchange="submitBday(this.value)" disabled>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label>Age</label>
                                        <div class="input-group my-colorpicker2">
                                            <input type="number" class="form-control" id="age" value="<?php echo $studentDetails[0]['age'] ?>" placeholder="Age" disabled>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-4">
                                        <label> Contact No.</label>
                                        <div class="input-group my-colorpicker2">
                                            <input type="number" class="form-control" id="primaryNumber" placeholder=" Mobile No." value="<?php echo $studentDetails[0]["phoneNumber"]; ?>" disabled>
                                            <div class="input-group-append">
                                                <span class="input-group-text"> <i class="fas fa-phone"> </i> </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Alternate Contact No.</label>
                                            <div class="input-group my-colorpicker2">
                                                <input type="number" class="form-control" id="alternateNumber" placeholder="Alternate Mobile No." value="<?php echo $studentDetails[0]["alternateNo"]; ?>" disabled>
                                                <div class="input-group-append">
                                                    <span class="input-group-text"> <i class="fas fa-phone-volume"> </i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <label>WhatsApp No.</label>
                                        <div class="input-group my-colorpicker2">
                                            <input type="number" class="form-control" id="whatsAppNumber" placeholder="WhatsApp No." value="<?php echo $studentDetails[0]["whatsappNo"]; ?>" disabled>
                                            <div class="input-group-append">
                                                <span class="input-group-text"> <i class="fas fa-phone"> </i> </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row pT15">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Email Id</label>
                                            <div class="input-group my-colorpicker2">
                                                <input type="email" class="form-control" id="emailId" placeholder="Email ID" value="<?php echo $studentDetails[0]["username"]; ?>" disabled>
                                                <div class="input-group-append">
                                                    <span class="input-group-text"> <i class="fas fa-envelope"> </i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Password</label>
                                            <div class="input-group my-colorpicker2">
                                                <input type="email" class="form-control" id="password" placeholder="Password" value="<?php echo $studentDetails[0]["pass"]; ?>" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>Scholarship Expiry Date</label>
                                            <div class="input-group my-colorpicker2">
                                                <input type="date" class="form-control" id="scholarshipExpiryDate" placeholder="Scholarship Expiry Date" value="">
                                                <div class="input-group-append">
                                                    <span class="input-group-text"> <i class="fas fa-envelope"> </i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-1">
                                        <div class="form-group">
                                            <a type="btn" class="form-control btn btn-success mt-4 text-white" id="updateExpiryDate">UPDATE</a>
                                        </div>
                                        <p class="errorMessage mt-1" id="errorMessage" style="color: red;"></p>
                                        <p class="successMessage" id="successMessage"></p>
                                    </div>
                                </div>
                                <div class="col-md-3 tAC">
                                    <div class="custom-file">
                                        <label>Profile Photo</label>
                                        <input type="file" accept="image/*" id="uploadimage" name="<?php echo $studentDetails[0]['imageName'] ?>" onchange="loadFile(event)" hidden /><br>
                                    </div>
                                </div>
                                <div class="col-md-2 ml-5 mt-5 tAC">
                                    <div class="form-group">
                                        <img id="profilePhotoPreview" class="defaultImg" />
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card card-warning">
                        <div class="card-header newCardHeader">
                            <h3 class="card-title">2. Communication Address
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Address Line 1</label>
                                        <div class="input-group my-colorpicker2">
                                            <textarea class="form-control" rows="5" placeholder="Communication Address" id="address1" disabled><?php echo $studentDetails[0]['addressLine1'] ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Alternate Address</label>
                                        <div class="input-group my-colorpicker2">
                                            <textarea class="form-control" rows="5" placeholder="Alternate Address" id="alternateAddress" disabled><?php echo $studentDetails[0]['alternateAddress'] ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>City</label>
                                        <input class="form-control" id="city" value="<?php echo $studentDetails[0]['city'] ?>" disabled />
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label>State</label>
                                    <input class="form-control" id="state" value="<?php echo $studentDetails[0]['state'] ?>" disabled />
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>PinCode</label>
                                        <input type="number" class="form-control" value="<?php echo $studentDetails[0]['pinCode'] ?>" id="pinCode" placeholder="Pincode" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card card-warning">
                        <div class="card-header">
                            <h3 class="card-title">3. Guardian Information</h3>
                        </div>
                        <div class="card-body">
                            <form role="form">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Full Name</label>
                                            <input type="text" class="form-control" id="guardianName" placeholder="Full Name" value="<?php echo $studentDetails[0]["fullName"]; ?>" disabled>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Relation to Student</label>
                                            <input type="text" class="form-control" id="guardianRelation" placeholder="Relation to Student" value="<?php echo $studentDetails[0]["guardianType"]; ?>" disabled>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Primary Contact No.</label>
                                            <div class="input-group my-colorpicker2">
                                                <input type="number" class="form-control" id="guardianPrimaryNo" placeholder="Primary Mobile No." value="<?php echo $studentDetails[0]["contactNumber"]; ?>" disabled>
                                                <div class="input-group-append">
                                                    <span class="input-group-text"> <i class="fas fa-phone"> </i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Email Id</label>
                                            <div class="input-group my-colorpicker2">
                                                <input type="email" class="form-control" id="guardianEmailId" placeholder="Email ID" value="<?php echo $studentDetails[0]["emailId"]; ?>" disabled>
                                                <div class="input-group-append">
                                                    <span class="input-group-text"> <i class="fas fa-envelope"> </i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Guardian Password</label>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control" id="guardian password" placeholder="Password." value="<?php echo $studentDetails[0]["parentsPassword"]; ?>" disabled>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">4. Education Details</h3>
                        </div>
                        <div class="card-body p-0">
                            <table class="table tAC vAC">
                                <thead>
                                    <tr>
                                        <th class="w20">Degree</th>
                                        <th class="w30">Degree Description </th>
                                        <th class="w10">Passing Year</th>
                                        <th class="w30">Institute Name</th>
                                        <th class="w10">Percentage</th>
                                    </tr>
                                </thead>
                                <tbody id="educationTableBody">
                                    <?php
                                    $sql2 = "SELECT * FROM studenteducation where studentid = '$studentId';  ";
                                    $result = $conn->query($sql2);
                                    if ($result->num_rows > 0) {
                                        $srNo = 1;
                                        while ($row = $result->fetch_assoc()) {
                                            echo "
                                        <tr  class='tAC'>
                                            <td>" . $row["degree"] . "</td>
                                            <td>" . $row["degreeDescription"] . "</td>
                                            <td>" . $row["passingYear"] . "</td> 
                                            <td>" . $row["instituteName"] . "</td>
                                            <td>" . $row["percentage"] . "</td>
                                        </tr>
                                        ";
                                            $srNo += 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-md-12">
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">5. Fee Details</h3>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped projects tAC" id="utilityTable">
                                <thead>
                                    <tr>
                                        <th style="width: 20%">
                                            YEAR
                                        </th>
                                        <th style="width: 20%">
                                            SEM 1 TUITION FEE
                                        </th>
                                        <th style="width: 20%">
                                            SEM 2 TUITION FEE
                                        </th>
                                        <th style="width: 20%">
                                            POGRAM FEE
                                        </th>
                                        <th style="width: 20%">
                                            DOWN PAYMENT
                                        </th>
                                    </tr>
                                </thead>
                                <tbody id="utilityTableBody">
                                    <?php
                                    $feeMaster = [];
                                    $sql = "SELECT * FROM studentfee WHERE studentId='$studentId'  ORDER BY studentId DESC; ";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            array_push($feeMaster, $row);
                                        }
                                    }
                                    $academicYearArray = explode('-', $feeMaster[0]['academicYear']);
                                    $firstYear = $academicYearArray[0] . '-' . ($academicYearArray[0] + 1);
                                    $secondYear = ($academicYearArray[0] + 1) . '-' . ($academicYearArray[0] + 2);
                                    $thirdYear = ($academicYearArray[0] + 2) . '-' . ($academicYearArray[1]);
                                    ?>
                                    <tr>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="firstAcademicYear" value=<?php echo $firstYear ?> disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem1TuitionFee0" value=<?php echo $feeMaster[0]['FirstSem_TF'] ?> placeholder="Sem 1 Tuition Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem2TuitionFee0" value=<?php echo $feeMaster[0]['SecondSem_TF'] ?> placeholder="Sem 2 Tuition Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem2ProgramFee0" value=<?php echo $feeMaster[0]['FY_PF'] ?> placeholder="Sem 2 Program Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" value=<?php echo $feeMaster[0]['firstYearDownPayment'] ?> id="downPayment0" placeholder="Down Payment" disabled />
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="secondAcademicYear" value=<?php echo $secondYear ?> disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" value=<?php echo $feeMaster[0]['ThirdSem_TF'] ?> id="sem1TuitionFee1" placeholder="Sem 1 Tuition Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem2TuitionFee1" value=<?php echo $feeMaster[0]['FourthSem_TF'] ?> placeholder="Sem 2 Tuition Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem2ProgramFee1" value=<?php echo $feeMaster[0]['SY_PF'] ?> placeholder="Sem 2 Program Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="downPayment1" placeholder="Down Payment" value=<?php echo $feeMaster[0]['secondYearDownPayment'] ?> disabled />
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="thirdAcademicYear" value=<?php echo $thirdYear ?> disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem1TuitionFee2" value=<?php echo $feeMaster[0]['FifthSem_TF'] ?> placeholder="Sem 1 Tuition Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem2TuitionFee2" value=<?php echo $feeMaster[0]['SixthSem_TF'] ?> placeholder="Sem 2 Tuition Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="sem2ProgramFee2" value=<?php echo $feeMaster[0]['TY_PF'] ?> placeholder="Sem 2 Program Fee" disabled />
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group my-colorpicker2">
                                                <input type="text" class="form-control tAC" id="downPayment2" value=<?php echo $feeMaster[0]['thirdYearDownPayment'] ?> placeholder="Down Payment" disabled />
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="viewStudentDetails.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var studentId = '<?php echo $studentId ?>';
    $(function() {
        $(document).ready(function() {
            var scholarshipExpiryDate = '<?php echo $studentDetails[0]['scholarshipExpiryDate'] ?>';
            document.getElementById('scholarshipExpiryDate').value = scholarshipExpiryDate;
            var studentProfilePhoto = '<?php echo $studentDetails[0]['imageName']; ?>';
            var profilePhotoPreview = document.getElementById('profilePhotoPreview');
            if (studentProfilePhoto != '') {
                profilePhotoPreview.src = "../../../dist/img/studentphoto/" + studentProfilePhoto;
                profilePhotoPreview.style.height = 200;
                profilePhotoPreview.style.width = 180;
            } else {
                profilePhotoPreview.src = "../../../dist/img/studentphoto/default.jpg";
                profilePhotoPreview.style.height = 200;
                profilePhotoPreview.style.width = 180;
            }
            selectDropdownValue("studentStatus", "<?php echo $studentDetails[0]['studentStatus']; ?>");
            loadOldValues();
        });
    });
</script>
<?php require '../../common/footer.php'; ?>