var lifeCoachUserId = "",
    lifeCoachCompanyName = "",
    lifeCoachEmailId = "",
    lifeCoachPassword = "",
    lifeCoachFirstName = "",
    lifeCoachLastName = "",
    duplicatEmail = false,
    statement = '',
    flagForStatement = '';


const oldData = {
    lifeCoachId: "",
    lifeCoachFirstName: "",
    lifeCoachLastName: "",
    lifeCoachCompanyName: "",
    lifeCoachPassword: "",
    lifeCoachEmail: ""
}

function loadOldValues() {
    oldData.lifeCoachId = document.getElementById("lifeCoachUserId").value.trim();
    oldData.lifeCoachFirstName = document.getElementById("lifeCoachFirstName").value.trim().toUpperCase();
    oldData.lifeCoachLastName = document.getElementById("lifeCoachLastName").value.trim().toUpperCase();
    oldData.lifeCoachCompanyName = document.getElementById("lifeCoachCompanyName").value.trim();
    oldData.lifeCoachEmail = document.getElementById("lifeCoachEmailId").value.trim();
    oldData.lifeCoachPassword = document.getElementById("lifeCoachPassword").value.trim();
}

function compareNewValuesWithOld() {
    statement = "UPDATE done in Life Coach Profile-ID " + oldData.lifeCoachId + " Name " + oldData.lifeCoachFirstName + " " + oldData.lifeCoachLastName + ". ";
    var flagForStatement = 0;

    if (oldData.lifeCoachFirstName != lifeCoachFirstName) {
        flagForStatement = 1;
        statement = statement + "First Name changed from " + oldData.lifeCoachFirstName + " to " + lifeCoachFirstName + "<br>";
    }
    if (oldData.lifeCoachLastName != lifeCoachLastName) {
        flagForStatement = 1;
        statement = statement + "Last Name changed from " + oldData.lifeCoachLastName + " to " + lifeCoachLastName + "<br>";
    }
    if (oldData.lifeCoachCompanyName != lifeCoachCompanyName) {
        flagForStatement = 1;
        statement = statement + "Company Name changed from " + oldData.lifeCoachCompanyName + " to " + lifeCoachCompanyName + "<br>";
    }
    if (oldData.lifeCoachEmail != lifeCoachEmailId) {
        flagForStatement = 1;
        statement = statement + "Email ID changed from " + oldData.lifeCoachEmail + " to " + lifeCoachEmailId + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function checkDuplicate(emailId) {
    $.post('checkDuplicate.php', {
        'emailId': emailId
    },
        function (data) {
            if (data == 1) {
                showError('errorMessage', '', 'Duplicate email');
                document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
                duplicatEmail = true;
                return duplicatEmail;
            } else {
                showError('errorMessage', '', '');
                document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
                duplicatEmail = false;
                return duplicatEmail;
            }
        }
    );
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function setHeaders() {
    lifeCoachUserId = "";
    lifeCoachCompanyName = '';
    lifeCoachEmailId = '';
    lifeCoachPassword = "";
    lifeCoachFirstName = "";
    lifeCoachLastName = "";

    lifeCoachFirstName = document.getElementById("lifeCoachFirstName").value.trim().toUpperCase();
    lifeCoachLastName = document.getElementById("lifeCoachLastName").value.trim().toUpperCase();
    lifeCoachUserId = document.getElementById("lifeCoachUserId").value.trim();
    lifeCoachCompanyName = document.getElementById("lifeCoachCompanyName").value.trim().toUpperCase();
    lifeCoachEmailId = document.getElementById("lifeCoachEmailId").value.trim();
    lifeCoachPassword = document.getElementById("lifeCoachPassword").value.trim();

    return 1;
}

function lifeCoachValidation() {
    // life Coach first name
    if (lifeCoachFirstName.length <= 0) {
        document.getElementById("lifeCoachFirstName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter first name");
        return 0;
    } else {
        document.getElementById("lifeCoachFirstName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // life coach last name
    if (lifeCoachLastName.length <= 0) {
        document.getElementById("lifeCoachLastName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter last name");
        return 0;
    } else {
        document.getElementById("lifeCoachLastName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //lifeCoach company name validation
    if (lifeCoachCompanyName.length <= 0) {
        document.getElementById("lifeCoachCompanyName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter company name");
        return 0;
    } else {
        document.getElementById("lifeCoachCompanyName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //lifeCoach EmailId validation
    if (lifeCoachEmailId.length <= 0) {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter email");
        return 0;
    } else {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (!validateEmail(lifeCoachEmailId)) {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Email is not in correct format");
        // document.getElementById("errorMessage").style.display="block";
        return 0;
    } else {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (duplicatEmail) {
        showError('errorMessage', '', 'Email Alredy Exist. Please Change it...');
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
        return 0;
    } else {
        showError('errorMessage', '', '');
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
    }
    return 1;
}

function updateLifeCoach() {
    document.getElementById('updateButton').disabled = true;
    if (setHeaders() == 0) return;
    if (lifeCoachValidation() == 0) {
        document.getElementById('updateButton').disabled = false;
        return;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('updateButton').disabled = false;
        return;
    }

    var flagForUpdate = "TRUE";
    if (confirm("Are you sure you want to update details?")) {
        document.getElementById('successMessage').innerHTML = "Saving Please Wait...";
        document.getElementById('updateButton').disabled = true;
        $.post('updateLifeCoach.php', {
            'flagForUpdate': flagForUpdate,
            'lifeCoachFirstName': lifeCoachFirstName,
            'lifeCoachLastName': lifeCoachLastName,
            'lifeCoachUserId': lifeCoachUserId,
            'lifeCoachCompanyName': lifeCoachCompanyName,
            'lifeCoachEmailId': lifeCoachEmailId,
            'lifeCoachPassword': lifeCoachPassword,
            'logStatement': statement
        }, function (data) {
            document.getElementById('successMessage').innerHTML = "Saved successfully. Please wait page will get auto-refresh.";
            document.getElementById('updateButton').disabled = false;
            location.reload();
        });
    }
    else document.getElementById('updateButton').disabled = false;
}