var checkedValue = '';
checkedValueArray = [];

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

function showError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function checkout() {
    var checkBoxes = document.getElementsByClassName('mycheckbox');
    var checkBoxvalue = document.getElementsByName('checkvalue');
    var nbChecked = 0;

    for (var i = 0; i < checkBoxes.length; i++) {
        if (checkBoxes[i].checked) nbChecked++;
    }
    for (var i = 0; i < checkBoxvalue.length; i++) {
        if (checkBoxvalue[i].checked) checkedValue += checkBoxvalue[i].value + '|';
    }
    if (nbChecked == 0) {
        showError('', '', 'select user(s) who will be able to see this Announcement')
        return 0;
    } else showError('', '', '');
}

function saveAnnouncement() {
    saveFlag = "SaveAnnouncement";
    announcementId = document.getElementById("announcementId").value;
    fromDateEndDate = document.getElementById("announcementDate").value;
    announcementMessage = document.getElementById("announcementMessage").value;
    if (fromDateEndDate == '') {
        showError('announcementDate', '#ff6666', 'Date cannot be Blank')
        return 0;
    } else showError('announcementDate', '', '')
    if (announcementMessage == '') {
        showError('announcementMessage', '#ff6666', 'Announcement Message cannot be Blank')
        return 0;
    } else showError('announcementMessage', '', '')

    // if (announcementMessage.length >= 240) {
    //     showError('announcementMessage', '#ff6666', 'Character Limit Execeeded')
    //     return 0;
    // } else showError('announcementMessage', '', '')
    announcementMessage = escapeSpecialCharacters(announcementMessage);

    if (checkout() == 0) return 0;
    document.getElementById('successMessage').innerHTML = "SAVING PLEASE WAIT....";
    document.getElementById('saveButton').disabled = true;
    $.post('saveAnnouncement.php', {
        'saveFlag': saveFlag,
        'announcementId': announcementId,
        'fromDateEndDate': fromDateEndDate,
        'announcementMessage': announcementMessage,
        'checkedValue': checkedValue
    }, function (data) {
        document.getElementById('saveButton').disabled = true;
        document.getElementById('successMessage').innerHTML = 'Saved successfully';
        location.reload();
    });
}