<?php
session_start();
if (isset($_SESSION['counselorLoginsuccessAPT'])) {
    if ($_SESSION['counselorLoginsuccessAPT'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';

$counselorId = $_SESSION['councelorUserid'];
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">UPCOMING MEETINGS</h3>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY MEETING DATE</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="meetingDateFilter" placeholder="FROM TO DATE" onchange="" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#meetingDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="example1">
                                <thead>
                                    <tr>
                                        <th class="col-md-1">
                                            LEAD ID
                                        </th>
                                        <th class="col-md-1">
                                            NAME
                                        </th>
                                        <th class="col-md-2">
                                            PHONE NUMBER
                                        </th>
                                        <th class="col-md-1">
                                            Meeting Date
                                        </th>
                                        <th class="col-md-2">
                                            Meeting Time
                                        </th>
                                        <th class="col-md-4">
                                            Agenda
                                        </th>
                                        <th class="col-md-2">
                                            Action
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql2 = "SELECT followup.leadId,followup.followUpId,followup.planDate,followup.planStartTime,followup.planEndTime,leads.phoneNumber,followup.followUpMessage,leads.leadId,leads.leadFirstName,leads.leadLastName FROM followup INNER JOIN leads ON followup.leadId = leads.leadId where  followUpType = 'MEETING' AND followUpStatus = 'PENDING' AND agency_counselor_Id = $counselorId ORDER BY followUpId desc;";
                                    $result = $conn->query($sql2);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $leadId = '';
                                            $leadName = '';
                                            $followUpId = '';
                                            $meetingTime = '';

                                            $leadId = '"' . $row['leadId'] . '"';
                                            $leadName = $row['leadFirstName'] . " " . $row['leadLastName'];
                                            $followUpId = $row['followUpId'];
                                            $meetingTime = date('h:i a', strtotime($row['planStartTime'])) . '-' . date('h:i a', strtotime($row['planEndTime']));
                                            echo "
                                                <tr  class='tAC'>                                                                                                
                                                    <td>" . $row['leadId'] . "</td> 
                                                    <td>" . $leadName . "</td> 
                                                    <td>" . $row['phoneNumber'] . "</td> 
                                                    <td>" . str_replace('-', "/", $row['planDate']) . "</td>
                                                    <td>" . $meetingTime . "</td> 
                                                    <td>" . $row['followUpMessage'] . "</td>
                                                    <td>
                                                        <a class='btn btn-info tCW' href='#' title='Click here to Execute Meeting.' 
                                                        onclick='showDetails($leadId,$followUpId)' id = " . $leadId . " >
                                                    Execute</a>
                                                     <a class='btn btn-warning btn-sm fS15' href='#' title='Click here to Edit User.' onclick='editMeeting($leadId,$followUpId)' >
                                                    <i class='fas fa-edit'></i> Edit</a>
                                                    </td>
                                                </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="meetings.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    $('#meetingDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });


    $(function() {
        $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $("#meetingDateFilter").val("");
        $("#meetingDateFilter").change(function() {
            var table = $('#example1').DataTable();
            table.draw();
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("meetingDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[2]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;
                return inEmpStartingDateRange;
            }
        );
    });
</script>
<?php require '../../common/footer.php'; ?>