<?php
if (empty(session_id()) && !headers_sent()) {
    session_start();
}
?>
<span id="myDetails">
    <div class="row" style='margin-left: 0.5rem;'>
    
        <div class="col-md-4">
            <div class="form-group">
                <label>From To Date:</label>
                <div class="input-group">
                    <input type="text" class="form-control " id="myselfAssignTaskDate" placeholder="Ticket Deadline Date*" onchange="" />
                    <div class="input-group-append" data-target="#myselfAssignTaskDate" data-toggle="daterangepicker">
                        <div class="input-group-text"> <i class="fa fa-calendar"> </i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
      
    </div>
    <div class="card-body">
        <table class="table table-striped  tAC" id="myticketListTable">
            <thead>
                <tr>
                    <th style="width: 7%">
                        Sr No
                    </th>
                    <th style="width: 20%">
                        Ticket DeadLine
                    </th>

                    <th style="width: 20%">
                        Raised From
                    </th>
                    <th style="width: 33%">
                        Ticket Message
                    </th>

                    <th style="width: 10%">
                        Ticket Status
                    </th>
                    <th style="width: 10%">
                        Action
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                require_once '../../common/connectToDB.php';

                $sql2 = "SELECT * FROM tickets WHERE ticketRaisedTo = '" . $_SESSION['councelorUserid'] . "';";
                $result = $conn->query($sql2);
                if ($result->num_rows > 0) {
                    $rowId = 1;
                    while ($row = $result->fetch_assoc()) {
                        $hidBtn = '';

                        if ($row["status"] == 'PENDING') {
                            $statusCss = 'badge badge-danger';
                            $hidBtn = '';
                        }
                        if ($row["status"] == 'RESOLVED') {
                            $statusCss = 'badge badge-success';
                            $hidBtn = 'hidden';
                        }
                        $ticketResolvedMessage = '"' . $row["ticketResolvedMessage"] . '"';
                        if ($row["ticketResolvedMessage"] != '') {
                            $hideyeBtn = '';
                        }
                        if ($row["ticketResolvedMessage"] == '') {
                            $hideyeBtn = 'hidden';
                        }

                        $ticketMessage = substr($row['ticketMessage'], 0, 10);
                        $dateArray = explode('-', $row['ticketDeadlineDate']);
                        $date = $dateArray[2] . '/' . $dateArray[1] . '/' . $dateArray[0];
                        echo "
                        <tr  class='tAC'>
                            <td>" . $rowId . "</td>
                            <td>" . $date . "</td>
                            <td>" . $row["ticketRaisedFromName"] . "</td>
                            <td>" . $row['ticketMessage']. "</td>
                            <td><span class = '" . $statusCss . "'>" . $row["status"] . "</span></td>
                            <td class='project-actions'>
                                                
                                                <a class='btn btn-primary btn-sm'  href='#' id='tableDeleteButton'  data-toggle='modal'   onclick='showDetails(" . $row["ticketId"] . ",$ticketResolvedMessage)' title='Click here to View Ticket Resolve message.'>
                                                    <i class='fas fa-eye'>
                                                    </i>
                                                </a>
                                            </td> 
                            </tr>";
                        $rowId += 1;
                    }
                }
                ?>
            </tbody>
        </table>
    </div>
</span>

<script>
    $(() => {
        $(document).ready(() => {
            $('.select2').select2();
           
            $('#myselfAssignTaskDate').daterangepicker({
                autoApply: true,
                "alwaysShowCalendars": true,
                locale: {
                    format: 'DD/MM/YYYY',
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
            });

            $("#myselfAssignTaskDate").val("");
            $("#myselfAssignTaskDate").change(() => {
                table2.draw();
            });
            $.fn.dataTableExt.afnFiltering.push(
                (settings, data, dataIndex) => {
                    // console.log("IN 1 out")
                    var tempDate2 = document.getElementById("myselfAssignTaskDate").value;



                    // console.log(selecteduserStatus)
                    inEmpStartingDateRange2 = true;
                    if (tempDate2.length > 0) {
                        tempDate2 = tempDate2.split("-");
                        dateRangeStart2 = tempDate2[0];
                        dateRangeEnd2 = tempDate2[1];
                        var dateRangeStart2 = new Date(formatDate(dateRangeStart2));
                        var dateRangeEnd2 = new Date(formatDate(dateRangeEnd2));
                        var tempData2 = data[1].split(" ");
                        var empStartDate2 = new Date(formatDate(tempData2[0]));
                        inEmpStartingDateRange2 = (dateRangeStart2 && dateRangeEnd2) ?
                            (moment(empStartDate2).isSameOrAfter(dateRangeStart2) &&
                                moment(empStartDate2).isSameOrBefore(dateRangeEnd2)) : true;
                    }else inEmpStartingDateRange2 = true;

                 

                    return inEmpStartingDateRange2;
                }
            );
            var table2 = $("#myticketListTable").DataTable({
                "responsive": true,
                "autoWidth": false,
                "aLengthMenu": [
                    [5, 10, 25, 50, 75, -1],
                    [5, 10, 25, 50, 75, "All"]
                ],
                "pageLength": 5,
                "aaSorting": []
            });
           
            
        });
    });
</script>