<?php
session_start();
if (isset($_SESSION['BDELoginsuccessEdj'])) {
    if ($_SESSION['BDELoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

$BDEUserid = $_SESSION['BDEUserid'];
require_once '../../common/connectToDB.php';
$academicYearList = [];
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">STUDENT DOWNPAYMENT LIST</h3>
                                    <br><br>
                                    <div class="row">
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY PAYMENT DATE</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control fS13" id="paymentDateFilter"
                                                        placeholder="FROM TO DATE" onchange="" onclick="showIcon()" />
                                                    <div class="input-group-append" data-target="#paymentDateFilter"
                                                        data-toggle="daterangepicker">
                                                        <div class="input-group-text" id='iconBackground'> <i
                                                                class="fa fa-calendar" id='dateIcon'> </i><i
                                                                class="fas fa-times" id='clearDate'
                                                                onclick="clearDate()" hidden></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                                <select class="select2" multiple="multiple" id="filterAyear"
                                                    data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;"
                                                    onchange="filterOtherDropDown('studAyear')" ;>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="fS13">FILTER BY PAYMENT CONFIRMATION STATUS</label>
                                                <select class="select2" multiple="multiple" id="filterPaymentStaus"
                                                    data-placeholder="SELECT PAYMENT STATUS" style="width: 100%;"
                                                    onchange="filterOtherDropDown('paymentStatus')" ;>
                                                    <option>APPROVED</option>
                                                    <option>PENDING</option>

                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="example1">
                                <thead>
                                    <tr>
                                        <th style="width:10%;">
                                            Payment Id
                                        </th>
                                        <th style="width:10%;">
                                            Academic Year
                                        </th>
                                        <th style="width:15%;">
                                            Full Name
                                        </th>
                                        <th style="width:10%;">
                                            Payment Date
                                        </th>
                                        <th style="width:15%;">
                                            Payment Purpose
                                        </th>
                                        <th style="width:10%;">
                                            Amount
                                        </th>
                                        <th style="width:15%;">
                                            Payment Confirmation Status
                                        </th>
                                        <th style="width:15%;">
                                            Action
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql2 = "SELECT * from paymenthistory WHERE paymentAddBy = '$BDEUserid' ORDER BY paymentId desc; ";

                                    $result = $conn->query($sql2);

                                    $statusCSS = "badge badge-danger";
                                    $paymentConfirmationStatusCSS = '';
                                    if ($result->num_rows > 0) {
                                        $rowId = 1;
                                        while ($row = $result->fetch_assoc()) {
                                            $paymentId = $row["paymentId"];
                                            $leadId = $row["studentId"];
                                            $ledaName = $row["firstName"] . ' ' . $row["lastName"];
                                            $paymentDate1 = $row["paymentDate"];
                                            $paymentDate = str_replace('-', "/", $paymentDate1);
                                            $paymentMethod = $row['paymentMethod'];
                                            $paymnetPurpose = $row['paymentPurpose'];
                                            $amount = $row['amount'];
                                            $paymentConfirmationStatus = $row['paymentStatus'];

                                            if ($row['paymentStatus'] == "PENDING")
                                                $paymentConfirmationstatusCSS = "badge badge-danger";
                                            else if ($row['paymentStatus'] == "APPROVED")
                                                $paymentConfirmationstatusCSS = "badge badge-success";
                                            else
                                                $paymentConfirmationstatusCSS = "badge badge-secondary";
                                            $sql = "SELECT academicYear from studentfee  WHERE studentId='$leadId';";
                                            $result2 = $conn->query($sql);
                                            if ($result2->num_rows > 0) {
                                                while ($row2 = $result2->fetch_assoc()) {
                                                    $academicYear = $row2['academicYear'];
                                                }
                                            }
                                            echo "
                                            <tr  class='tAC'>
                                                <td ><a class='tCB' href='#' onclick='showDetails(this.id,$paymentId)' id = " . $leadId . ">" . $paymentId . "</a></td> 
                                                <td>" . $academicYear . "</td>  
                                                <td ><a class='tCB' href='#' onclick='showDetails(this.id,$paymentId)' id = " . $leadId . "> " . $ledaName . "</a></td> 
                                                    <td>" . $paymentDate . "</td>
                                                    <td>" . $paymnetPurpose . "</td> 
                                                    <td>" . $amount . "</td> 
                                                    <td><span class='" . $paymentConfirmationstatusCSS . "'>" . $paymentConfirmationStatus . "</span></td> 
                                                    <td class='project-actions'>
                                                        <a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id,$paymentId)' id = " . $leadId . " title='click hear to view Lead Details'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                        <a class='btn btn-warning btn-sm' href='#' title='Click here to Edit Payment.' onclick='editPayment($leadId,$paymentId)' >
                                                        <i class='fas fa-edit'></i>
                                                        </a>
                                                    </td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="paymentHistory.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    $('.select2').select2();

    $('#paymentDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });

    $(function () {
        $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $("#paymentDateFilter").val("");
        $("#paymentDateFilter").change(function () {
            var table = $('#example1').DataTable();
            table.draw();
        });

        $.fn.dataTableExt.afnFiltering.push(
            function (settings, data, dataIndex) {
                var tempDate = document.getElementById("paymentDateFilter").value.trim();
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();
                selectedPaymentStatus = getSelectValues('', document.getElementById("filterPaymentStaus")).trim();
                var rowAcademicYear = data[1].trim();
                var rowPaymentStatus = data[6].trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[3]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;
                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;
                if (selectedPaymentStatus != '') {
                    inPaymentStatus = (selectedPaymentStatus.indexOf(rowPaymentStatus) != -1) ? rowPaymentStatus : false;
                } else inPaymentStatus = true;
                return inEmpStartingDateRange && inStudAcademicYear && inPaymentStatus;
            }
        );
    });

    function filterOtherDropDown(flag) {

        var table = $('#example1').DataTable();
        table.draw();
    }
    loadDataDropdown("filterAyear", academicYearList);
</script>
<?php require '../../common/footer.php'; ?>