<?php
session_start();
if (isset($_SESSION['BDELoginsuccessEdj'])) {
    if ($_SESSION['BDELoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';

$BDEId = $_SESSION['BDEUserid'];
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">UPCOMING MEETINGS</h3>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label class='fS13'>FILTER BY MEETING DATE</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="meetingDateFilter" placeholder="FROM TO DATE" onchange="" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#meetingDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="example1">
                                <thead>
                                    <tr>

                                        <th class="col-md-1">
                                            Meeting Date
                                        </th>
                                        <th class="col-md-2">
                                            Meeting Time
                                        </th>
                                        <th class="col-md-2">
                                            Lead Counselor
                                        </th>
                                        <th class="col-md-1">
                                            LEAD ID
                                        </th>
                                        <th class="col-md-2">
                                            NAME
                                        </th>
                                        <th class="col-md-2">
                                            Agenda
                                        </th>
                                        <th class="col-md-1">
                                            Status
                                        </th>
                                        <th class="col-md-2">
                                            Action
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql2 = "SELECT f.leadId,f.followUpId,f.planDate,f.followUpMessage,f.followUpId,f.agency_counselor_Id,f.planStartTime,f.planEndTime,f.followUpStatus,l.leadFirstName,l.leadLastName FROM followup f INNER JOIN leads l ON f.leadId = l.leadId where  f.followUpType = 'MEETING' AND f.followUpStatus = 'PENDING' AND f.agency_bde_Id = $BDEId ORDER BY f.followUpId desc;";
                                    $result = $conn->query($sql2);

                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $leadId = '';
                                            $meetingDate = '';
                                            $followUpId = '';
                                            $meetingTime = '';
                                            $leadName = '';
                                            $leadCounselorID = '';
                                            $leadCounselorID = $row['agency_counselor_Id'];
                                            $leadCounselorName='';

                                            $leadId = '"' . $row['leadId'] . '"';
                                            $meetingDate = str_replace('-', "/", $row['planDate']);
                                            $meetingAgenda = '"' . $row['followUpMessage'] . '"';
                                            $followUpId = $row['followUpId'];
                                            $meetingTime = date('h:i a', strtotime($row['planStartTime'])) . '-' . date('h:i a', strtotime($row['planEndTime']));
                                            $leadName = $row['leadFirstName'] . " " . $row['leadLastName'];

                                            if ($row['followUpStatus'] == "PENDING") $statusCSS = "badge badge-danger";
                                            else if ($row['followUpStatus'] == "COMPLETED") $statusCSS = "badge badge-success";
                                            else $statusCSS = "badge badge-warning";

                                            $sql = "SELECT firstname,lastname FROM logindetail where userid='$leadCounselorID';";
                                            $result3 = $conn->query($sql);
                                            if ($result3->num_rows > 0) {
                                                while ($row2 = $result3->fetch_assoc()) {
                                                    $leadCounselorName=$row2['firstname'].' '.$row2['lastname'];
                                                }
                                            }

                                            echo "
                                                <tr  class='tAC'>  
                                                <td>" . $meetingDate . "</td> 
                                                <td>" . $meetingTime . "</td>   
                                                <td>" . $leadCounselorName . "</td>   
                                                <td>" . $row['leadId'] . "</td> 
                                                <td>" . $leadName . "</td> 
                                                <td>" . $row['followUpMessage'] . "</td>                                        
                                                  
                                                    
                                                    <td><span class='" . $statusCSS . "'>" . $row["followUpStatus"] . "</span></td> 
                                                    <td><a class='btn btn-warning btn-sm fS15' href='#' title='Click here to Edit Meeting.' onclick='editMeeting($leadId,$followUpId)' >
                                                        <i class='fas fa-edit'></i> Edit
                                                        </a>
                                                    </td> 
                                                </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="upComingMeetings.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    $('#meetingDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ]
        },
    });

    $(function() {
        $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $("#meetingDateFilter").val("");
        $("#meetingDateFilter").change(function() {
            var table = $('#example1').DataTable();
            table.draw();
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("meetingDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[0]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;
                return inEmpStartingDateRange;
            }
        );
    });
</script>
<?php require '../../common/footer.php'; ?>