var inputMeetingDate = "";
var meetingDate = "";
var leadCounselorText = "";
var oldLeadCounselorText = "";

function loadDataDropdown(selectName, results, centerId) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("leadCounselor")) {
            if (i == 0) {
                options.value = options.text = "SELECT COUNSELOR";
                theSelect.add(options);
                options.selected = true;
                options.disabled = true;
                options = document.createElement("option");
            }
            options.value = results[i].userid;
            options.text = results[i].firstname + " " + results[i].lastname.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}
function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}



function onDateChange(id) {
    if (id == "meetingDate") {
        inputMeetingDate = document.getElementById(id);
        var dateSplit = inputMeetingDate.value.split('-'),
            date,
            month,
            year;
        date = dateSplit[2];
        month = dateSplit[1];
        year = dateSplit[0];
        meetingDate = date + '-' + month + '-' + year;
        newMeetingDate = year + '-' + month + '-' + date;
    }
}

function clearDate() {
    document.getElementById('meetingDateFilter').value = '';
    var element = document.getElementById('meetingDateFilter');
    var event = new Event('change');
    element.dispatchEvent(event);
    document.getElementById('dateIcon').hidden = false;
    document.getElementById('clearDate').hidden = true;
    document.getElementById('iconBackground').style.backgroundColor = '';
}

function showIcon() {
    document.getElementById('dateIcon').hidden = true;
    document.getElementById('clearDate').hidden = false;
    document.getElementById('iconBackground').style.backgroundColor = '#ff6666';
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}
function oldMeetingDetails() {
    OldMeetingDate = '',
        oldMeetingStartTime = '',
        oldMeetingEndTime = '',
        oldAgenda = '',
        leadId = '';
    leadFirstName = '';
    leadLastName = '';
    leadId = '';
    oldLeadCounselorText = '';

    leadId = document.getElementById('leadId').innerHTML;
    leadFirstName = document.getElementById('leadFirstName').innerHTML;
    leadLastName = document.getElementById('leadLastName').innerHTML;
    OldMeetingDate = document.getElementById('meetingDate').value;
    oldMeetingStartTime = document.getElementById('meetingStartTime').value;
    oldMeetingEndTime = document.getElementById('meetingEndTime').value;
    oldAgenda = document.getElementById('meetingAgenda').innerHTML;

    var tempSelOpt = document.getElementById("leadCounselor");
    oldLeadCounselorText = tempSelOpt.options[tempSelOpt.selectedIndex].text.trim();

}
function validateMeetingUpdateDetails() {
    statement = "Meeting of Lead ID:" + leadId + " LeadName: " + leadFirstName + " " + leadLastName + ", ";
    flagForStatement = 0;

    if (OldMeetingDate != newMeetingDate) {
        flagForStatement = 1;
        statement = statement + "Meeting Date changed from " + OldMeetingDate + " to " + newMeetingDate + "<br>";
    }
    if (oldMeetingStartTime != meetingStartTime) {
        flagForStatement = 1;
        statement = statement + "Meeting Start Time changed from " + oldMeetingStartTime + " to " + meetingStartTime + "<br>";
    }
    if (oldMeetingEndTime != meetingEndTime) {
        flagForStatement = 1;
        statement = statement + "Meeting End Time changed from " + oldMeetingEndTime + " to " + meetingEndTime + "<br>";
    }
    if (oldAgenda != meetingAgenda) {
        flagForStatement = 1;
        statement = statement + "Meeting Agenda changed from " + oldAgenda + " to " + meetingAgenda + "<br>";
    }

    if (oldLeadCounselorText != leadCounselorText) {
        flagForStatement = 1;
        statement = statement + "Lead Counselor changed from " + oldLeadCounselorText + " to " + leadCounselorText + "<br>";
    }
    if (flagForStatement == 0) {
        document.getElementById('meetingErrorMessage').innerHTML = "No Changes Done";
        return 0;
    } else document.getElementById('meetingErrorMessage').innerHTML = "";
    return 1;

}
function buttonDisabled(id, status) {
    document.getElementById(id).disabled = status;
}

function editMeeting(leadId, followUpId) {
    encodedValue_LeadId = btoa(leadId);
    encodedValue_followUpId = btoa(followUpId);
    encodedKey_LeadId = btoa('leadId');
    encodedKey_fId = btoa('fId');
    window.location.href = "editMeeting.php?" + encodedKey_LeadId + "=" + encodedValue_LeadId + "&" + encodedKey_fId + "=" + encodedValue_followUpId;
}

function editMeetingDetails(followUpId) {
    var flagForUpdateMeeting = true;
    meetingStartTime = document.getElementById("meetingStartTime").value;
    meetingEndTime = document.getElementById("meetingEndTime").value;
    meetingAgenda = document.getElementById("meetingAgenda").value;
    var tempSelOpt = document.getElementById("leadCounselor");
    leadCounselor = document.getElementById("leadCounselor").value;
    leadCounselorText = tempSelOpt.options[tempSelOpt.selectedIndex].text.trim();
    saveMeetingAgenda = escapeSpecialCharacters(meetingAgenda);
    var meetingFollowUpId = followUpId;
    if (validateMeetingUpdateDetails() == 0) return 0;
    buttonDisabled('editMeeting', true);
    if (meetingAgenda != "") {
        document.getElementById("meetingSuccessMessage").innerHTML = "Updating Please Wait....";
        document.getElementById("editMeeting").disabled = true;
        document.getElementById("cancelMeeting").disabled = true;
        $.post('saveMeeting.php', {
            'flagForUpdateMeeting': flagForUpdateMeeting,
            'meetingDate': meetingDate,
            'meetingStartTime': meetingStartTime,
            'meetingEndTime': meetingEndTime,
            'meetingAgenda': saveMeetingAgenda,
            'followUpId': meetingFollowUpId,
            'leadCounselor': leadCounselor,
            'statement': statement
        }, function (data) {
            document.getElementById("meetingSuccessMessage").innerHTML = "Saved.";
            // buttonDisabled('editMeeting', false);
            location.reload();
        });

    }
}

function cancelMeeting(followUpId) {
    var flagForCancel = true;
    if (confirm("Are you sure you want to cancel meeting ?")) {
        buttonDisabled('editMeeting', true);
        buttonDisabled('cancelMeeting', true);
        document.getElementById("meetingSuccessMessage").innerHTML = "Cancelling please wait";
        $.post("saveMeeting.php", {
            'flagForCancel': flagForCancel,
            'followUpId': followUpId
        }, function (data) {
            buttonDisabled('editMeeting', true);
            document.getElementById("meetingSuccessMessage").innerHTML = "Meeting cancelled";
            location.reload();
        });
    }
    // buttonDisabled('editMeeting', false);
}