<?php
session_start();
if (isset($_SESSION['BDELoginsuccessEdj'])) {
    if ($_SESSION['BDELoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
$BDEId = $_SESSION['BDEUserid'];
$academicYearList = [];

$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">Lead Pool</h3>
                            <br>
                            <br>
                            <div class='row'>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY ACADEMIC YEAR</label>
                                        <select class="select2" multiple="multiple" id="filterAyear"
                                            data-placeholder="SELECT ACADEMIC YEAR" style="width: 100%;"
                                            onchange="filterTable('studAyear')" ;>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">FILTER BY LEAD QUALIFICATION</label>
                                        <select class="select2" multiple="multiple" id="filterLeadQualificartion"
                                            data-placeholder="SELECT LEAD QUALIFICATION" style="width: 100%;"
                                            onchange="filterTable('studAyear')" ;>
                                            <option>NEW LEAD</option>
                                            <option>RECEIVED FROM CENTER</option>
                                            <option>INTERESTED</option>
                                            <option>CONNECTED</option>
                                            <option>TRANSFERRED TO BDO</option>
                                            <option>SEEK ADMISSION</option>
                                            <option>ADMISSION CONFIRMED</option>
                                            <option>DROPPED</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="fS13">EXCEL DOWNLOAD</label><br>
                                        <button class="btn btn-success" onclick="downloadTableAsCSV()">Download Excel</button>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="leadTable">
                                <thead>
                                    <tr>
                                        <th>
                                            SR NO.
                                        </th>
                                        <th>
                                            NAME
                                        </th>
                                        <th>
                                            PHONE NO.
                                        </th>

                                        <th>
                                            LOCATION
                                        </th>
                                        <th>
                                            LEAD QUALIFICATION
                                        </th>
                                        <th>
                                            LEAD ID
                                        </th>
                                        <th>
                                            LEAD SOURCE
                                        </th>
                                        <th>
                                            STATUS
                                        </th>
                                        <th>
                                            ACADEMIC YEAR
                                        </th>
                                        <th>
                                            COUNSELOR NAME
                                        </th>
                                        <th>
                                            Action
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from leads WHERE leadBDEId='$BDEId' AND qualification!='ADMISSION CONFIRMED' ORDER BY leadId DESC; ";
                                    $result = $conn->query($sql);
                                    $sr = 0;
                                    $srNo = 1;

                                    if ($result->num_rows > 0) {
                                        $rowId = 1;
                                        while ($row = $result->fetch_assoc()) {
                                            $sr = $sr + 1;
                                            $leadId = $row["leadId"];
                                            $leadName = $row["leadFirstName"] . ' ' . $row["leadMiddleName"] . ' ' . $row["leadLastName"];
                                            $leadEmail = $row['emailId'];
                                            $leadcontactNo = $row['phoneNumber'];
                                            $leadCity = $row['city'];
                                            $qualificationCSS = '';
                                            $leadQualification = '';
                                            $councelorName = '';
                                            $sql2 = "SELECT * FROM logindetail where user_type IN('BUSINESS DEVELOPMENT OFFICER','BUSINESS DEVELOPMENT EXECUTIVE') AND userStatus='ACTIVE' AND userId IN('" . $row["leadCounselorId2"] . "');";
                                            $result2 = $conn->query($sql2);
                                            if ($result2->num_rows > 0) {
                                                while ($row2 = $result2->fetch_assoc()) {
                                                    $councelorName = $row2['salutation'] . ' ' . $row2['firstname'] . ' ' . $row2['lastname'];
                                                }
                                            }

                                            if ($row['qualification'] == "NEW LEAD") {
                                                $qualificationCSS = "badge badge-info";
                                                $leadQualification = "NEW LEAD";
                                            } else if ($row['qualification'] == "TRANSFERRED TO BDE") {
                                                $qualificationCSS = "badge badge-warning";
                                                $leadQualification = "RECEIVED FROM BO";
                                            } else if ($row['qualification'] == "TRANSFERRED TO COUNSELOR") {
                                                $qualificationCSS = "badge badge-warning";
                                                $leadQualification = "TRANSFERRED TO BDO";
                                            } else if ($row['qualification'] == "SEEK ADMISSION") {
                                                $qualificationCSS = "badge badge-success";
                                                $leadQualification = "SEEK ADMISSION";
                                            } else if ($row['qualification'] == "ADMISSION CONFIRMED") {
                                                $qualificationCSS = "badge badge-primary";
                                                $leadQualification = "ADMISSION CONFIRMED";
                                            } else if ($row['qualification'] == "DROPPED") {
                                                $qualificationCSS = "badge badge-danger";
                                                $leadQualification = "DROPPED";
                                            } else if ($row['qualification'] == "RECEIVED FROM BDO") {
                                                $qualificationCSS = "badge badge-warning";
                                                $leadQualification = "TRANSFERRED TO BDO";
                                            } else {
                                                $qualificationCSS = "badge badge-warning";
                                                $leadQualification = $row['qualification'];
                                            }
                                            if ($row['status'] == "MILD")
                                                $leadStatusCSS = "badge badge-secondary";
                                            else if ($row['status'] == "HOT")
                                                $leadStatusCSS = "badge badge-success";
                                            else if ($row['status'] == "COLD")
                                                $leadStatusCSS = "badge badge-primary";
                                            echo "
                                                <tr  class='tAC'>
                                                <td >" . $srNo . "</td>
                                                <td ><a class='tCB' href='#' onclick='showDetails(this.id)' id = " . $leadId . "> " . $leadName . "</a></td> 
                                                <td >" . $leadcontactNo . "</td>
                                                <td>" . $leadCity . "</td>
                                                <td><span class='" . $qualificationCSS . "'>" . $leadQualification . "</span></td>
                                                <td> <span href='#' onclick='showDetails(this.id)' id = " . $leadId . ">" . $row["leadId"] . "</span></a></td> 
                                                <td>" . $row["leadSource"] . "</td>
                                                <td> <span class='" . $leadStatusCSS . "'>" . $row["status"] . "</span></a></td> 
                                                <td>" . $row['academicYear'] . "</td>
                                                <td>" . $councelorName . "</td>
                                                <td class='project-actions'>
                                                <a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id)' id = " . $leadId . " title='click hear to view Lead Details'>
                                                            <i class='fas fa-eye'>
                                                            </i>
                                                        </a>
                                                        <a class='btn btn-secondary btn-sm' href='#' title='Click here to Edit Details.' onclick='editDetails($leadId)' >
                                                        <i class='fas fa-user-edit'>
                                                    </i>
                                                </a>";
                                            echo "
                                                </td>
                                                </tr> 
                                            ";
                                            $srNo++;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageLead.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    $(function() {

        $('.select2').select2();
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                selectedAcademicYear = getSelectValues('', document.getElementById("filterAyear")).trim();
                selectedLeadQualification = getSelectValues('', document.getElementById("filterLeadQualificartion")).trim();

                var rowAcademicYear = data[8].trim();
                var rowLeadQualification = data[4].trim();

                if (selectedAcademicYear != '') {
                    inStudAcademicYear = (selectedAcademicYear.indexOf(rowAcademicYear) != -1) ? rowAcademicYear : false;
                } else inStudAcademicYear = true;
                if (selectedLeadQualification != '') {
                    inStudLeadQualification = (selectedLeadQualification.indexOf(rowLeadQualification) != -1) ? rowLeadQualification : false;
                } else inStudLeadQualification = true;
                return inStudAcademicYear && inStudLeadQualification;


            }
        );
        $("#leadTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
    loadDataDropdown("filterAyear", academicYearList);
</script>
<?php require '../../common/footer.php'; ?>