<?php
session_start();
if (isset($_SESSION['auditorLoginSuccessEdj'])) {
    if ($_SESSION['auditorLoginSuccessEdj'] > 0) {
    } else {
        header('Location:../../auditorLogin.php');
        exit;
    }
} else {
    header('Location:../../auditorLogin.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10 card-info">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PENDING PAYMENTS</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                        <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Filter by Invoice Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="paymentDateFilter" placeholder="FROM TO DATE" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#paymentDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <table class="table table-striped projects tAC" id="pendingPaymentTable">
                                <thead>
                                    <tr>
                                        <th>
                                            Vendor ID
                                        </th>
                                        <th>
                                            Invoice Date
                                        </th>
                                        <th>
                                            Company Name
                                        </th>
                                        <th>
                                            Vendor Name
                                        </th>
                                        <th>
                                            Pending Amount
                                        </th>
                                        <th>
                                            Total Amount
                                        </th>
                                        <th>
                                            Approval Status
                                        </th>
                                        <th>
                                            Invoice
                                        </th>
                                        <th>
                                            Actions
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql    = "SELECT * from vendor_invoice where invoice!='' AND invoiceStatus NOT IN('REJECTED BY AUDITOR','REJECTED BY OWNER') ORDER BY InvoiceId desc; ";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $invoice = $row['invoice'];
                                            $VendorId = $row['vendorId'];
                                            $invoiceId = $row['InvoiceId'];
                                            $invoiceDateArray = explode("-",$row['invoiceDate']);

                                            $sqlV = "SELECT * from vendordetails where vendorId='$VendorId';";
                                            $resultV = $conn->query($sqlV);
                                            if ($resultV->num_rows > 0) {
                                                while ($rowV = $resultV->fetch_assoc()) {
                                                    $vendorCompanyName = $rowV['vendorCompanyName'];
                                                    $vendorName = $rowV['firstName'] . ' ' . $rowV['lastName'];
                                                }
                                            }


                                            if ($row['invoiceStatus'] == 'PENDING AT OWNER') $invoiceStatusCss = "badge badge-primary fS13";
                                            if ($row['invoiceStatus'] == 'PENDING AT AUDITOR') $invoiceStatusCss = "badge badge-warning fS13";
                                            if ($row['invoiceStatus'] == 'PENDING AT ACCOUNTS') $invoiceStatusCss = "badge badge-light fS13";
                                            if ($row['invoiceStatus'] == 'REJECTED BY OWNER') $invoiceStatusCss = "badge badge-danger fS13";
                                            if ($row['invoiceStatus'] == 'REJECTED BY AUDITOR') $invoiceStatusCss = "badge badge-danger fS13";
                                            if ($row['invoiceStatus'] == 'ON HOLD AT OWNER') $invoiceStatusCss = "badge badge-info fS13";
                                            if ($row['invoiceStatus'] == 'COMPLETED') $invoiceStatusCss = "badge badge-success fS13";

                                            if ($row['invoiceStatus'] == 'COMPLETED') {
                                                $hidBtn = 'hidden';
                                            } else {
                                                $hidBtn = '';
                                            }
                                            if ($row['invoiceStatus'] == 'PENDING AT ACCOUNTS') {
                                                $disBtn = 'disabled';
                                            } else {
                                                $disBtn = '';
                                            }
                                            echo "
                                            <tr  class='tAC'>
                                            <td>" . $row["vendorId"] . "</td> 
                                            <td>" . $invoiceDateArray[2].'/'.$invoiceDateArray[1].'/'.$invoiceDateArray[0] . "</td> 
                                            <td>" . $vendorCompanyName . "</td> 
                                            <td>" . $vendorName . "</td> 
                                            <td>" . $row["pendingAmount"] . "</td> 
                                            <td>" . $row["totalAmount"] . "</td> 
                                            <td><span class='" . $invoiceStatusCss . "'>" . $row["invoiceStatus"] . "</td> 
                                            <td><a class='btn btn-primary btn-sm' target='_blank' id='' href='../../../dist/img/vendorImage/Invoicedocuments/$VendorId/$invoice'>
                                            <i class='fas fa-eye'></i></a></td>
                                                <td class='project-actions'>
                                                <a class='btn btn-primary btn-sm' style='color:white;' target='_blank' id='$invoiceId' onclick='showDetails(this.id,$VendorId)'>
                                                <i class='fas fa-eye'>   </i>    </a>
                                                <a class='btn btn-info btn-sm $disBtn' style='color:white;' target='_blank' id='$invoiceId' onclick=editOwnerInvoiceStatus(this.id,$VendorId) $hidBtn>
                                                    <i class='far fa-edit'></i>
                                                </a>
                                      
                                            
                                                    ";
                                            echo "    
                                            </td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>

<script src="pendingPayment.js?v=<?php echo $fileVersion; ?>"></script>

<script>
     $('#paymentDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });
    $(function() {
        $("#pendingPaymentTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("paymentDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[1]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;

                

                return inEmpStartingDateRange ;
            }
        );
        $("#paymentDateFilter").val("");
        $("#paymentDateFilter").change(function() {
            var table = $('#pendingPaymentTable').DataTable();
            table.draw();
        });
    });
</script>

<?php require '../../common/footer.php'; ?>