<?php
session_start();
if (isset($_SESSION['auditorLoginSuccessEdj'])) {
    if ($_SESSION['auditorLoginSuccessEdj'] > 0) {
    } else {
        header('Location:../../auditorLogin.php');
        exit;
    }
} else {
    header('Location:../../auditorLogin.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PENDING BONUS</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingBonusTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                        <th>
                                            AVERAGE REVIEW
                                        </th>
                                        <th>
                                            AMOUNT
                                        </th>
                                        <th>
                                            STATUS
                                        </th>
                                        <th>
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';

                                    $sql = "SELECT b.bonusId,b.assignmentId,b.bonusValue,b.invoiceStatus,b.facultyId,b.facultyName,b.flag,a.semester,a.subjectName,r.assignmentId, (SELECT (sum(r.noOfRatings)/count(r.noOfRatings))) as reviewNumber FROM f_bonus AS b,f_assignment AS a,review AS r WHERE a.assignmentId = b.assignmentId AND b.assignmentId = r.assignmentId AND b.invoiceStatus NOT IN ('REJECTED BY OWNER','REJECTED BY AUDITOR','OWNER COMFIRMATION PENDING','CONFIRMED','TDS CALCULATION PENDING') GROUP BY b.assignmentId;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = '';
                                            $id = $row['bonusId'];
                                            $statusCss = '';
                                            $assignmentId = $row['assignmentId'];
                                            $facultyId = $row['facultyId'];

                                            if ($row['invoiceStatus'] == 'PENDING AT OWNER') $statusCss = "badge badge-primary fS13";
                                            if ($row['invoiceStatus'] == 'PENDING AT AUDITOR') $statusCss = "badge badge-warning fS13";
                                            if ($row['invoiceStatus'] == 'PENDING AT ACCOUNTS') $statusCss = "badge badge-light fS13";
                                            if ($row['invoiceStatus'] == 'REJECTED BY OWNER') $statusCss = "badge badge-danger fS13";
                                            if ($row['invoiceStatus'] == 'REJECTED BY AUDITOR') $statusCss = "badge badge-danger fS13";
                                            if ($row['invoiceStatus'] == 'ON HOLD AT OWNER') $statusCss = "badge badge-info fS13";
                                            if ($row['invoiceStatus'] == 'COMPLETED') $statusCss = "badge badge-success fS13";
                                          
                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $row['assignmentId'] . "</td>
                                                <td>" . $row['semester'] . "</td>
                                                <td>" . $row['subjectName'] . "</td>
                                                <td>" . $row['facultyName'] . "</td>
                                                <td>" . $row['reviewNumber'] . "</td>
                                                <td>" . $row['bonusValue'] . "</td>
                                                <td><span class = '" . $statusCss . "'>" . $row['invoiceStatus'] . "</span></td>
                                                <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm fS18' href='#' id = " . $id . " title='Click hear to add payment' onclick='viewbonusApproval(this.id,$facultyId)'>
                                                    <i class='fas fa-eye fS15'></i> 
                                                    </a>
                                                </td>
                                            </tr>";
                                            // <td class='project-actions'>
                                            //         <a class='btn btn-primary btn-sm fS18' href='#' id = " . $id . " title='Click hear to add payment' onclick='addPayment(this.id,$assignmentId)'>
                                            //         <i class='fas fa-rupee-sign fS15'></i> Pay
                                            //         </a>
                                            //     </td>
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
    // function addPayment(bonusId, assignmentId) {
    //     encodedValue_bonusId = btoa(bonusId);
    //     encodedValue_assignmentId = btoa(assignmentId);
    //     window.location.href = "addPayment.php?bId=" + encodedValue_bonusId + "&aId=" + encodedValue_assignmentId;
    // }
    function viewbonusApproval(bonusId, facultyId) {
        encodedValue_bonusId = btoa(bonusId);
        encodedValue_facultyId = btoa(facultyId);
        encodedKey_aId = btoa("aId");
        encodedKey_fId = btoa("fId");

        // window.location.href = "addPayment.php?aId=" + bonusId + "&fId=" + facultyId;
        window.location.href = "viewbonusApproval.php?" + encodedKey_aId + "=" + encodedValue_bonusId + "&" + encodedKey_fId + "=" + encodedValue_facultyId;
    }
    $(function() {
        $("#pendingBonusTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>