<?php
session_start();
if (isset($_SESSION['auditorLoginSuccessEdj'])) {
    if ($_SESSION['auditorLoginSuccessEdj'] > 0) {
    } else {
        header('Location:../../auditorLogin.php');
        exit;
    }
} else {
    header('Location:../../auditorLogin.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">PENDING PAYMENT</h3>
                        </div>

                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Filter by Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="paymentDateFilter" placeholder="FROM TO DATE" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#paymentDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <table class="table table-striped projects tAC" id="pendingtaxpayment">

                                <thead>
                                    <tr>
                                        <th width='10%'>EMPLOYEE ID</th>
                                        <th width='10%'>DATE</th>
                                        <th width='20%'>EMPLOYEE NAME</th>
                                        <th width='20%'>DESIGNATION</th>
                                        <th width='15%'>SALARY MONTH</th>
                                        <th width='15%'>APPROVAL</th>
                                        <th width='5%'>AMOUNT</th>
                                        <th width='5%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from user_tax_payment where paymentApprovalStatus NOT IN('REJECTED BY AUDITOR','REJECTED BY OWNER') AND pendingTaxAmount != 0 ORDER BY userid DESC;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            if ($row['paymentApprovalStatus'] == 'PENDING AT OWNER') $PaymentApprovalStatusCss = "badge badge-primary fS13";
                                            if ($row['paymentApprovalStatus'] == 'PENDING AT AUDITOR') $PaymentApprovalStatusCss = "badge badge-warning fS13";
                                            if ($row['paymentApprovalStatus'] == 'PENDING AT ACCOUNTS') $PaymentApprovalStatusCss = "badge badge-light fS13";
                                            if ($row['paymentApprovalStatus'] == 'ON HOLD AT OWNER') $PaymentApprovalStatusCss = "badge badge-info fS13";
                                            if ($row['paymentApprovalStatus'] == 'REJECTED BY OWNER') $PaymentApprovalStatusCss = "badge badge-danger fS13";
                                            if ($row['paymentApprovalStatus'] == 'REJECTED BY AUDITOR') $PaymentApprovalStatusCss = "badge badge-danger fS13";
                                            $attendanceMonth = '"' . $row['salaryMonth'] . '"';
                                            $taxType = '"' . $row['paymentType'] . '"';
                                            if ($row['paymentApprovalStatus'] == 'COMPLETED') {
                                                $hidBtn = 'hidden';
                                            } else {
                                                $hidBtn = '';
                                            }
                                            if ($row['paymentApprovalStatus'] == 'PENDING AT ACCOUNTS') {
                                                $disBtn = 'disabled';
                                            } else {
                                                $disBtn = '';
                                            }
                                            $taxAddTimeStamp = $row['paymentAddTimestamp'];
                                            $taxAddTimeStampArray = explode(":", $taxAddTimeStamp);
                                            $taxAddedDate = str_replace('-', '/', $taxAddTimeStampArray[0]);



                                            echo "<tr  class='tAC'>
                                            <td > " . $row['userid']  . "</td>
                                            <td > " . $taxAddedDate  . "</td>
                                            <td > " . $row['userName'] . "</td>
                                            <td > " . $row['user_type']  . "</td>
                                            <td > " . $row['salaryMonth']  . "</td>
                                            <td ><span class ='$PaymentApprovalStatusCss'> " . $row['paymentApprovalStatus']  . "</td>
                                            <td > " . $row['pendingTaxAmount']  . "</td>
                                            <td>
                                                <a class='btn btn-primary' title='Click hear to payment' id = " . $row['userid'] . " onclick='viewTaxApproval(this.id,$attendanceMonth,$taxType)'>
                                                <i class='fas fa-eye fS15'></i>
                                                </a>
                                              
                                            </td> 
                                        </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="pendingTaxPayment.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    $('#paymentDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });
    $(function() {
        $("#pendingtaxpayment").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("paymentDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[1]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;



                return inEmpStartingDateRange;
            }
        );
        $("#paymentDateFilter").val("");
        $("#paymentDateFilter").change(function() {
            var table = $('#pendingtaxpayment').DataTable();
            table.draw();
        });
    });
</script>

<?php require '../../common/footer.php'; ?>