<?php
session_start();
if (isset($_SESSION['auditorLoginSuccessEdj'])) {
    if ($_SESSION['auditorLoginSuccessEdj'] > 0) {
    } else {
        header('Location:../../auditorLogin.php');
        exit;
    }
} else {
    header('Location:../../auditorLogin.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PAYMENT HISTORY</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                        <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Filter by Payment Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="paymentDateFilter" placeholder="FROM TO DATE" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#paymentDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <table class="table table-striped projects tAC" id="pendingValidationTable">
                                <thead>
                                    <tr>
                                        <th style="width:10%;">
                                            PAYMENT ID
                                        </th>
                                        <th style="width:10%;">
                                            EMPLOYEE ID
                                        </th>
                                        <th style="width:15%;">
                                            EMPLOYEE NAME
                                        </th>
                                 
                                        <th style="width:15%;">
                                            DESIGNATION
                                        </th>
                                        <th style="width:15%;">
                                            PAYMENT DATE
                                        </th>
                                        <th style="width:20%;">
                                            PAYMENT TYPE
                                        </th>
                                        <th style="width:10%;">
                                            AMOUNT
                                        </th>
                                        <th style="width:10%;">
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from user_paymenthistory WHERE validationStatus = 'COMPLETED' ORDER BY paymentId desc; ";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $paymentPurpose = '';

                                            $paymentId = '"' . $row['paymentId'] . '"';
                                            $salaryMonth = '"' . $row['salaryMonth'] . '"';
                                            $payablePaymentId = $row['paymentId'];
                                            $userId = $row['userId'];

                                            if ($row['paymentDescription'] == 'COLLEGE PAYMENT') $paymentPurpose = ' (' . $row['paymentPurpose'] . ')';
                                            else $paymentPurpose = '';



                                            echo "
                                                <tr  class='tAC'>
                                                <td >" . $row['paymentId'] . "</td>
                                                <td >" . $row['userId'] . "</td>
                                                <td >" . $row['userName'] . "</td>
                                                <td >" . $row['userType'] . "</td>
                                                <td >" . str_replace('-','/',$row['paymentDate']) . "</td>
                                                <td >" . $row['paymentDescription'] . "</td>
                                                <td >" . $row['amountPaid'] . "</td>
                                                <td ><a class='btn btn-primary btn-sm' href='#' id='".$row['userId']."' onclick='showPaymentDetails($userId,$paymentId,$salaryMonth)' title='click hear to view Payment Details'>
                                                        <i class='fas fa-eye'></i>
                                                    </a>
                                                </td>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="pendingEmployeePayment.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    function showPaymentDetails(id,paymentId,salaryMonth) {
        encodedValue_id = btoa(id);
        encodedValue_paymentId = btoa(paymentId);
        encodedValue_salaryMonth = btoa(salaryMonth);
        window.location.href = "viewPaymentDetails.php?id=" + encodedValue_id + "&pID=" + encodedValue_paymentId +"&aM=" + encodedValue_salaryMonth;
    }
    $('#paymentDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });
    $(function() {
        $("#pendingValidationTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("paymentDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[4]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;



                return inEmpStartingDateRange;
            }
        );
        $("#paymentDateFilter").val("");
        $("#paymentDateFilter").change(function() {
            var table = $('#pendingValidationTable').DataTable();
            table.draw();
        });
    });

    function showIcon() {
    document.getElementById('dateIcon').hidden = true;
    document.getElementById('clearDate').hidden = false;
    document.getElementById('iconBackground').style.backgroundColor = '#ff6666';
}

function clearDate() {
    document.getElementById('paymentDateFilter').value = '';
    var element = document.getElementById('paymentDateFilter');
    var event = new Event('change');
    element.dispatchEvent(event);
    document.getElementById('dateIcon').hidden = false;
    document.getElementById('clearDate').hidden = true;
    document.getElementById('iconBackground').style.backgroundColor = '';
}
</script>

<?php require '../../common/footer.php'; ?>